/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolStack
extends Protocol
implements Transport {
    private Protocol top_prot = null;
    private Protocol bottom_prot = null;
    private String setup_string;
    private JChannel channel = null;
    private boolean stopped = true;
    public final TimeScheduler timer;
    protected ThreadGroup timer_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Timers");
    private final Map<Thread, ReentrantLock> locks = new ConcurrentHashMap<Thread, ReentrantLock>();
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    private static final String TIMER_NAME = "Timer";

    public ProtocolStack(JChannel channel, String setup_string) throws ChannelException {
        this.setup_string = setup_string;
        this.channel = channel;
        ClassConfigurator.getInstance(true);
        this.timer = this.createTimer();
    }

    public ProtocolStack() {
        this.timer = this.createTimer();
    }

    public Map<Thread, ReentrantLock> getLocks() {
        return this.locks;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getTimerThreads() {
        return this.timer.getCorePoolSize();
    }

    public Vector<Protocol> getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.addElement(p);
        }
        return v;
    }

    public Protocol getTransport() {
        Vector<Protocol> prots = this.getProtocols();
        return !prots.isEmpty() ? prots.lastElement() : null;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            String prot_name = p.getName();
            Map<String, Object> tmp = p.dumpStats();
            if (prot_name == null || tmp == null) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public String dumpTimerQueue() {
        return this.timer.dumpTaskQueue();
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties tmpProps;
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append(name);
            if (include_properties && (tmpProps = prot.getProperties()) != null) {
                sb.append('\n');
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    sb.append(entry).append("\n");
                }
            }
            sb.append('\n');
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public String printProtocolSpecAsXML() {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.bottom_prot;
        int max_len = 30;
        sb.append("<config>\n");
        while (prot != null) {
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append("  <").append(name).append(" ");
            Properties tmpProps = prot.getProperties();
            if (tmpProps != null) {
                int len = name.length();
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    String s = entry.getKey() + "=\"" + entry.getValue() + "\" ";
                    if (len + s.length() > max_len) {
                        sb.append("\n       ");
                        len = 8;
                    }
                    sb.append(s);
                    len += s.length();
                }
            }
            sb.append("/>\n");
            prot = prot.getUpProtocol();
        }
        sb.append("</config>");
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.top_prot = Configurator.setupProtocolStack(this.setup_string, this);
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = Configurator.getBottommostProtocol(this.top_prot);
            Configurator.initProtocolStack(this.bottom_prot);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return Configurator.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        Configurator.insertProtocol(prot, position, neighbor_prot, this);
    }

    public Protocol removeProtocol(String prot_name) throws Exception {
        return Configurator.removeProtocol(this.top_prot, prot_name);
    }

    public Protocol findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (prot_name == null || !prot_name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.top_prot != null) {
            Configurator.destroyProtocolStack(this.top_prot);
            this.top_prot = null;
        }
        try {
            this.timer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startStack() throws Exception {
        if (!this.stopped) {
            return;
        }
        this.timer.start();
        Configurator.startProtocolStack(this.top_prot);
        this.stopped = false;
    }

    public void stopStack() {
        if (this.stopped) {
            return;
        }
        Configurator.stopProtocolStack(this.top_prot);
        this.stopped = true;
    }

    public void flushEvents() {
    }

    @Override
    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    @Override
    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    @Override
    public String getName() {
        return "ProtocolStack";
    }

    @Override
    public Object up(Event evt) {
        return this.channel.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 4: {
                Object retval = this.top_prot.down(evt);
                this.renameTimerThreads(TIMER_NAME);
                return retval;
            }
        }
        ReentrantLock lock = this.locks.remove(Thread.currentThread());
        if (lock != null && lock.isHeldByCurrentThread()) {
            lock.unlock();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("released lock held by " + Thread.currentThread()));
            }
        }
        if (this.top_prot != null) {
            return this.top_prot.down(evt);
        }
        return null;
    }

    private TimeScheduler createTimer() {
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable command) {
                Thread thread = new Thread(ProtocolStack.this.timer_thread_group, command, ProtocolStack.TIMER_NAME);
                thread.setDaemon(true);
                ProtocolStack.this.renameThread(ProtocolStack.TIMER_NAME, thread);
                return thread;
            }
        };
        return new TimeScheduler(factory);
    }

    private void renameTimerThreads(String base_name) {
        if (this.timer_thread_group == null) {
            return;
        }
        String cluster_name = this.getClusterName();
        Address local_addr = this.getLocalAddress();
        int num_threads = this.timer_thread_group.activeCount();
        Thread[] timers = new Thread[num_threads];
        num_threads = this.timer_thread_group.enumerate(timers);
        for (int i = 0; i < num_threads; ++i) {
            Thread thread = timers[i];
            this.renameThread(base_name, thread, cluster_name, local_addr);
        }
    }

    private String renameThread(String base_name, Thread runner) {
        return this.renameThread(base_name, runner, this.getClusterName(), this.getLocalAddress());
    }

    private String renameThread(String base_name, Thread runner, String cluster_name, Address local_addr) {
        String oldName = null;
        if (runner != null) {
            oldName = runner.getName();
            StringBuilder threadName = new StringBuilder();
            threadName.append(base_name);
            if (threadName.length() > 0) {
                threadName.append(',');
            }
            if (cluster_name == null) {
                cluster_name = this.getClusterName();
            }
            threadName.append(cluster_name);
            if (threadName.length() > 0) {
                threadName.append(',');
            }
            if (local_addr == null) {
                local_addr = this.getLocalAddress();
            }
            threadName.append(local_addr);
            runner.setName(threadName.toString());
        }
        return oldName;
    }

    private Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    private String getClusterName() {
        return this.channel != null ? this.channel.getClusterName() : "n/a";
    }
}

