/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionChangesLog
implements CompositeChangesLog,
Externalizable {
    private static final long serialVersionUID = 4866736965040228027L;
    protected String systemId;
    protected List<PlainChangesLog> changesLogs = new ArrayList<PlainChangesLog>();

    public TransactionChangesLog() {
    }

    public TransactionChangesLog(PlainChangesLog changesLog) {
        this.changesLogs.add(changesLog);
    }

    @Override
    public void addLog(PlainChangesLog log) {
        this.changesLogs.add(log);
    }

    @Override
    public ChangesLogIterator getLogIterator() {
        return new ChangesLogIterator(this.changesLogs);
    }

    @Override
    public List<ItemState> getAllStates() {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (PlainChangesLog changesLog : this.changesLogs) {
            for (ItemState state : changesLog.getAllStates()) {
                states.add(state);
            }
        }
        return states;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (PlainChangesLog changesLog : this.changesLogs) {
            size += changesLog.getSize();
        }
        return size;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public ItemState getItemState(String itemIdentifier) {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (!state.getData().getIdentifier().equals(itemIdentifier)) continue;
            return state;
        }
        return null;
    }

    public ItemState getItemState(NodeData parentData, QPathEntry name) {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (!state.getData().getParentIdentifier().equals(parentData.getIdentifier()) || !state.getData().getQPath().getEntries()[state.getData().getQPath().getEntries().length - 1].isSame(name)) continue;
            return state;
        }
        return null;
    }

    public List<ItemState> getChildrenChanges(String rootIdentifier, boolean forNodes) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (ItemState state : this.getAllStates()) {
            ItemData item = state.getData();
            if (!item.getParentIdentifier().equals(rootIdentifier) || item.isNode() != forNodes) continue;
            list.add(state);
        }
        return list;
    }

    @Deprecated
    public ItemState[] findRenamed(ItemData item) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (state.getState() != 4 || state.isPersisted() || !item.getQPath().isDescendantOf(state.getData().getQPath())) continue;
            try {
                ItemState delete = state;
                ItemState rename = allStates.get(i + 1);
                if (rename.getState() != 32 || !rename.isPersisted() || !rename.getData().getIdentifier().equals(delete.getData().getIdentifier())) continue;
                for (int bi = allStates.size() - 1; bi >= i + 2; --bi) {
                    state = allStates.get(bi);
                    if (state.getState() != 32 || !state.isPersisted() || !state.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    rename = state;
                    delete = allStates.get(i - 1);
                    if (!delete.getData().getIdentifier().equals(rename.getData().getIdentifier())) continue;
                    return new ItemState[]{delete, rename};
                }
                return new ItemState[]{delete, rename};
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String dump() {
        String str = "ChangesLog: size" + this.changesLogs.size() + "\n ";
        for (PlainChangesLog cLog : this.changesLogs) {
            str = str + cLog.dump() + "\n";
        }
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.systemId != null) {
            out.writeInt(1);
            out.writeInt(this.systemId.getBytes().length);
            out.write(this.systemId.getBytes());
        } else {
            out.writeInt(-1);
        }
        int listSize = this.changesLogs.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.changesLogs.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readInt() == 1) {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.systemId = new String(buf, "UTF-8");
        }
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.changesLogs.add((PlainChangesLogImpl)in.readObject());
        }
    }
}

