/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractIncrementalBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.PendingChangesLog;
import org.exoplatform.services.jcr.ext.backup.impl.fs.FileNameProducer;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IncrementalBackupJob
extends AbstractIncrementalBackupJob {
    protected static Log log = ExoLogger.getLogger("ext.IncrementalBackupJob");
    private ObjectOutputStream oosFileData;
    private FileCleaner fileCleaner = new FileCleaner(10000L);

    public void init(ManageableRepository repository, String workspaceName, BackupConfig config, Calendar timeStamp) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.config = config;
        this.timeStamp = timeStamp;
        try {
            this.url = this.createStorage();
        }
        catch (FileNotFoundException e) {
            log.error("Incremental backup initialization failed ", e);
            this.notifyError("Incremental backup initialization failed ", e);
        }
        catch (IOException e) {
            log.error("Incremental backup initialization failed ", e);
            this.notifyError("Incremental backup initialization failed ", e);
        }
    }

    public void stop() {
        this.state = 4;
        log.info("Stop requested " + this.getStorageURL().getPath());
        this.notifyListeners();
    }

    protected URL createStorage() throws FileNotFoundException, IOException {
        FileNameProducer fnp = new FileNameProducer(this.config.getRepository(), this.config.getWorkspace(), this.config.getBackupDir().getAbsolutePath(), this.timeStamp, false);
        File backupFileData = fnp.getNextFile();
        this.oosFileData = new ObjectOutputStream(new FileOutputStream(backupFileData));
        return new URL("file:" + backupFileData.getAbsoluteFile());
    }

    protected void save(ItemStateChangesLog persistentLog) throws IOException {
        TransactionChangesLog changesLog = (TransactionChangesLog)persistentLog;
        if (changesLog != null && !this.isSessionNull(changesLog)) {
            long start = System.currentTimeMillis();
            this.writeExternal(this.oosFileData, changesLog, this.fileCleaner);
            long total = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("Time : " + total + " ms" + "    Itemstates count : " + changesLog.getAllStates().size());
            }
        }
    }

    public void writeExternal(ObjectOutputStream out, TransactionChangesLog changesLog, FileCleaner fileCleaner) throws IOException {
        PendingChangesLog pendingChangesLog = new PendingChangesLog(changesLog, fileCleaner);
        if (pendingChangesLog.getConteinerType() == 2) {
            out.writeInt(2);
            out.writeObject(changesLog);
            List<FixupStream> listfs = pendingChangesLog.getFixupStreams();
            out.writeInt(listfs.size());
            for (int i = 0; i < listfs.size(); ++i) {
                listfs.get(i).writeExternal(out);
            }
            List<InputStream> listInputList = pendingChangesLog.getInputStreams();
            out.writeInt(listInputList.size());
            for (int i = 0; i < listInputList.size(); ++i) {
                File tempFile = this.getAsFile(listInputList.get(i));
                FileInputStream fis = new FileInputStream(tempFile);
                out.writeLong(tempFile.length());
                this.writeContent(fis, out);
                fis.close();
                fileCleaner.addFile(tempFile);
            }
        } else {
            out.writeInt(1);
            out.writeObject(changesLog);
        }
        out.flush();
    }

    private File getAsFile(InputStream is) throws IOException {
        int len;
        byte[] buf = new byte[20480];
        File tempFile = File.createTempFile("" + System.currentTimeMillis(), "" + System.nanoTime());
        FileOutputStream fos = new FileOutputStream(tempFile);
        while ((len = is.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    private void writeContent(InputStream is, ObjectOutputStream oos) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        int size = 0;
        while ((len = is.read(buf)) > 0) {
            oos.write(buf, 0, len);
            size += len;
        }
        oos.flush();
    }

    private boolean isSessionNull(TransactionChangesLog changesLog) {
        boolean isSessionNull = false;
        ChangesLogIterator logIterator = changesLog.getLogIterator();
        while (logIterator.hasNextLog()) {
            if (logIterator.nextLog().getSessionId() != null) continue;
            isSessionNull = true;
            break;
        }
        return isSessionNull;
    }
}

