/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.groovyscript.text.TemplateStatistic;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="statistic"), @Property(key="type", value="template")})
@ManagedDescription(value="Template statistic service")
public class TemplateStatisticService {
    final Map<String, TemplateStatistic> apps = new ConcurrentHashMap<String, TemplateStatistic>();
    private final String ASC = "ASC";
    private final String DESC = "DESC";

    public TemplateStatistic getTemplateStatistic(String name) {
        TemplateStatistic app = this.apps.get(name);
        if (app == null) {
            app = new TemplateStatistic(name);
            this.apps.put(name, app);
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The list of template identifiers sorted alphabetically")
    public String[] getTemplateList() {
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        String[] app = new String[list.size()];
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            ++index;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The maximum rendering time of a specified template in seconds")
    public double getMaxTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getMaxTime());
    }

    @Managed
    @ManagedDescription(value="The minimum rendering time of a specified template in seconds")
    public double getMinTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getMinTime());
    }

    @Managed
    @ManagedDescription(value="The rendering count of a specified template")
    public long getExecutionCount(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.executionCount();
    }

    @Managed
    @ManagedDescription(value="The average rendering time of a specified template in seconds")
    public double getAverageTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getAverageTime());
    }

    @Managed
    @ManagedDescription(value="The list of the 10 slowest templates")
    public String[] getSlowestTemplates() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="The list of the 10 most executed templates")
    public String[] getMostExecutedTemplates() {
        HashMap<String, Long> application = new HashMap<String, Long>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.getExecutionCount(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="The list of the 10 fastest templates")
    public String[] getFastestTemplates() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "ASC");
    }

    private String[] sort(Map source, String order) {
        String[] app = new String[10];
        LinkedList list = new LinkedList(source.entrySet());
        if (order.equals("ASC")) {
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    double value2;
                    double value1 = Double.parseDouble(((Map.Entry)o1).getValue().toString());
                    if (value1 > (value2 = Double.parseDouble(((Map.Entry)o2).getValue().toString()))) {
                        return 1;
                    }
                    if (value1 < value2) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (order.equals("DESC")) {
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    double value1 = Double.parseDouble(((Map.Entry)o1).getValue().toString());
                    double value2 = Double.parseDouble(((Map.Entry)o2).getValue().toString());
                    if (value2 > value1) {
                        return 1;
                    }
                    if (value2 < value1) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            if (++index < app.length) continue;
            break;
        }
        return app;
    }

    private double toSeconds(double value) {
        return value == -1.0 ? -1.0 : value / 1000.0;
    }
}

