/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    private final Vector initial_mbrs = new Vector(11);
    private boolean initial_mbrs_received = false;
    private final Promise join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        super.init();
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.clear();
            this.initial_mbrs_received = false;
        }
        this.join_promise.reset();
    }

    public void join(Address mbr) {
        this.leaving = false;
        this.join_promise.reset();
        while (!this.leaving) {
            block28: {
                this.findInitialMembers();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("initial_mbrs are " + this.initial_mbrs));
                }
                if (this.initial_mbrs.isEmpty()) {
                    if (this.gms.disable_initial_coord) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)"received an initial membership of 0, but cannot become coordinator (disable_initial_coord=true), will retry fetching the initial membership");
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"no initial members discovered: creating group as first member");
                    }
                    this.becomeSingletonMember(mbr);
                    return;
                }
                Address coord = this.determineCoord(this.initial_mbrs);
                if (coord == null) {
                    Address new_coord;
                    if (!this.gms.handle_concurrent_startup) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"handle_concurrent_startup is false; ignoring responses of initial clients");
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("could not determine coordinator from responses " + this.initial_mbrs));
                    }
                    TreeSet<Address> clients = new TreeSet<Address>();
                    clients.add(mbr);
                    for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                        PingRsp pingRsp = (PingRsp)this.initial_mbrs.elementAt(i);
                        Address client_addr = pingRsp.getAddress();
                        if (client_addr == null) continue;
                        clients.add(client_addr);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("clients to choose new coord from are: " + clients));
                    }
                    if ((new_coord = (Address)clients.iterator().next()).equals(mbr)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("I (" + mbr + ") am the first of the clients, will become coordinator"));
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("I (" + mbr + ") am not the first of the clients, " + "waiting for another client to become coordinator"));
                    }
                    Util.sleep(500L);
                    continue;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("sending handleJoin(" + mbr + ") to " + coord));
                    }
                    this.sendJoinMessage(coord, mbr);
                    JoinRsp rsp = (JoinRsp)this.join_promise.getResult(this.gms.join_timeout);
                    if (rsp == null) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)("join(" + mbr + ") sent to " + coord + " timed out, retrying"));
                        }
                        break block28;
                    }
                    String failure = rsp.getFailReason();
                    if (failure != null) {
                        throw new SecurityException(failure);
                    }
                    MutableDigest tmp_digest = new MutableDigest(rsp.getDigest());
                    View tmp_view = rsp.getView();
                    if (tmp_digest == null || tmp_view == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("JoinRsp has a null view or digest: view=" + tmp_view + ", digest=" + tmp_digest + ", skipping it"));
                        }
                        break block28;
                    }
                    tmp_digest.incrementHighestDeliveredSeqno(coord);
                    tmp_digest.seal();
                    this.gms.setDigest(tmp_digest);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[" + this.gms.local_addr + "]: JoinRsp=" + tmp_view + " [size=" + tmp_view.size() + "]\n\n"));
                    }
                    if (!this.installView(tmp_view)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"view installation failed, retrying to join group");
                        }
                        Util.sleep(this.gms.join_retry_timeout);
                        continue;
                    }
                    Message view_ack = new Message(coord, null, null);
                    view_ack.setFlag((byte)1);
                    GMS.GmsHeader tmphdr = new GMS.GmsHeader(10);
                    view_ack.putHeader("GMS", tmphdr);
                    if (!this.gms.members.contains(coord)) {
                        this.gms.getDownProtocol().down(new Event(67, coord));
                    }
                    this.gms.getDownProtocol().down(new Event(1, view_ack));
                    this.gms.getUpProtocol().up(new Event(16));
                    this.gms.getDownProtocol().down(new Event(16));
                    return;
                }
                catch (SecurityException security_ex) {
                    throw security_ex;
                }
                catch (IllegalArgumentException illegal_arg) {
                    throw illegal_arg;
                }
                catch (Throwable e) {
                    if (!this.log.isDebugEnabled()) break block28;
                    this.log.debug((Object)("exception=" + e + ", retrying"));
                }
            }
            Util.sleep(this.gms.join_retry_timeout);
        }
    }

    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    public void handleLeaveResponse() {
    }

    public void suspect(Address mbr) {
    }

    public void unsuspect(Address mbr) {
    }

    public void handleMembershipChange(Collection newMembers, Collection leavingMembers, Collection suspectedMembers) {
    }

    public synchronized void handleViewChange(View new_view, Digest digest) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("view " + new_view.getVid() + " is discarded as we are not a participant"));
        }
    }

    private boolean installView(View new_view) {
        Vector<Address> mems = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new_view=" + new_view));
        }
        if (this.gms.local_addr == null || mems == null || !mems.contains(this.gms.local_addr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("I (" + this.gms.local_addr + ") am not member of " + mems + ", will not install view"));
            }
            return false;
        }
        this.gms.installView(new_view);
        this.gms.becomeParticipant();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 13: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (tmp != null && !tmp.isEmpty()) {
                        this.initial_mbrs.addAll(tmp);
                    }
                    this.initial_mbrs_received = true;
                    this.initial_mbrs.notifyAll();
                }
                return false;
            }
        }
        return true;
    }

    void sendJoinMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(1, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.getDownProtocol().down(new Event(67, coord));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.removeAllElements();
            this.initial_mbrs_received = false;
            this.gms.getDownProtocol().down(new Event(12));
            if (!this.initial_mbrs_received) {
                try {
                    this.initial_mbrs.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                PingRsp ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr == null || this.gms.local_addr == null || !ping_rsp.own_addr.equals(this.gms.local_addr)) continue;
                this.initial_mbrs.removeElementAt(i);
                break;
            }
        }
    }

    private Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>(5);
        for (int i = 0; i < mbrs.size(); ++i) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (!mbr.is_server || mbr.coord_addr == null) continue;
            if (!votes.containsKey(mbr.coord_addr)) {
                votes.put(mbr.coord_addr, new Integer(1));
                continue;
            }
            count = (Integer)votes.get(mbr.coord_addr);
            votes.put(mbr.coord_addr, new Integer(count + 1));
        }
        if (votes.size() > 1) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("there was more than 1 candidate for coordinator: " + votes));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("election results: " + votes));
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        Vector<Address> mbrs = new Vector<Address>(1);
        Digest initial_digest = new Digest(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        ViewId view_id = new ViewId(mbr);
        mbrs.addElement(mbr);
        this.gms.installView(new View(view_id, mbrs));
        this.gms.becomeCoordinator();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("created group (first member). My view is " + this.gms.view_id + ", impl is " + this.gms.getImpl().getClass().getName()));
        }
    }
}

