/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoResourceBundle
extends ListResourceBundle
implements Serializable {
    private static Pattern LINE_SEPARATOR = Pattern.compile("[\\r]?\\n");
    private static Pattern UNICODE_CHARACTER = Pattern.compile("\\\\u[\\p{XDigit}]{4}+");
    private Object[][] contents;

    public ExoResourceBundle(String data) {
        String[] tokens = LINE_SEPARATOR.split(data);
        ArrayList<String[]> properties = new ArrayList<String[]>();
        for (String token : tokens) {
            String key;
            int idx = token.indexOf(61);
            if (idx < 0 || idx >= token.length() - 1 || (key = token.substring(0, idx)).trim().startsWith("#")) continue;
            String value = ExoResourceBundle.convert(token.substring(idx + 1, token.length()));
            properties.add(new String[]{key, value});
        }
        String[][] aProperties = new String[properties.size()][2];
        this.contents = (String[][])properties.toArray((T[])aProperties);
    }

    public ExoResourceBundle(String data, ResourceBundle parent) {
        this(data);
        this.setParent(parent);
    }

    @Override
    public Object[][] getContents() {
        return this.contents;
    }

    public void putAll(Map<? super Object, ? super Object> map) {
        Enumeration<String> keys = this.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            map.put(key, this.getString(key));
        }
    }

    static String convert(String content) {
        Matcher matcher = UNICODE_CHARACTER.matcher(content);
        StringBuilder buffer = new StringBuilder(content.length());
        int start = 0;
        while (matcher.find(start)) {
            buffer.append(content.substring(start, matcher.start()));
            buffer.append(ExoResourceBundle.unicode2Char(matcher.group()));
            start = matcher.end();
        }
        if (start >= 0 && start < content.length()) {
            buffer.append(content.substring(start));
        }
        return buffer.toString();
    }

    static char unicode2Char(String unicodeChar) {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            char aChar = unicodeChar.charAt(i + 2);
            switch (aChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + aChar - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + 10 + aChar - 97;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + 10 + aChar - 65;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                }
            }
        }
        return (char)value;
    }
}

