/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.api.composer;

import java.util.ArrayList;
import java.util.Iterator;
import org.gatein.mop.api.composer.ComponentIterator;
import org.gatein.mop.api.composer.IterationType;
import org.gatein.mop.api.composer.PageIteratorStrategy;
import org.gatein.mop.api.composer.StructureIterator;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.ui.UIBody;
import org.gatein.mop.api.workspace.ui.UIComponent;

public class PageIterator
implements StructureIterator {
    private final ArrayList<PageVisit> list;
    private int index;
    private UIComponent current;

    public PageIterator(Page page, PageIteratorStrategy strategy) {
        ArrayList<PageVisit> list = new ArrayList<PageVisit>();
        Iterator<Page> iterator = strategy.iterator(page);
        while (iterator.hasNext()) {
            Page p = iterator.next();
            list.add(new PageVisit(p, new ComponentIterator(p.getRootComponent())));
        }
        this.list = list;
        this.index = list.size() - 1;
        this.current = null;
    }

    public UIComponent getComponent() {
        return this.current;
    }

    public IterationType next() {
        while (this.index < this.list.size()) {
            PageVisit visit = this.list.get(this.index);
            switch (visit.iterator.next()) {
                case START: {
                    UIComponent current = visit.iterator.getComponent();
                    if (current instanceof UIBody) {
                        --this.index;
                        break;
                    }
                    this.current = current;
                    return IterationType.START;
                }
                case END: {
                    UIComponent current = visit.iterator.getComponent();
                    if (current instanceof UIBody) break;
                    this.current = current;
                    return IterationType.END;
                }
                case DONE: {
                    this.current = null;
                    ++this.index;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return IterationType.DONE;
    }

    private static class PageVisit {
        private final Page page;
        private final ComponentIterator iterator;

        private PageVisit(Page page, ComponentIterator iterator) {
            this.page = page;
            this.iterator = iterator;
        }
    }
}

