/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.SetMap;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.CollectionPropertyInfo;
import org.chromattic.core.bean.ListPropertyInfo;
import org.chromattic.core.bean.MapPropertyInfo;
import org.chromattic.core.bean.MultiValuedPropertyInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.NodeTypeKind;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.mapper.RelatedPropertyMapper;
import org.chromattic.core.mapper.nodeattribute.JCRNodeAttributePropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.AnyChildMultiValueMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildCollectionPropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildParentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRNamedReferentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRReferentCollectionPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyListPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyMapPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyPropertyMapper;
import org.chromattic.core.mapping.CreateMapping;
import org.chromattic.core.mapping.DestroyMapping;
import org.chromattic.core.mapping.FindByIdMapping;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.MixinTypeMapping;
import org.chromattic.core.mapping.NodeTypeMapping;
import org.chromattic.core.mapping.PrimaryTypeMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.chromattic.core.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.core.mapping.jcr.JCRPropertyMapping;
import org.chromattic.core.mapping.value.ManyToOneMapping;
import org.chromattic.core.mapping.value.NamedManyToOneMapping;
import org.chromattic.core.mapping.value.NamedOneToManyMapping;
import org.chromattic.core.mapping.value.NamedOneToOneMapping;
import org.chromattic.core.mapping.value.OneToManyMapping;
import org.chromattic.core.mapping.value.PropertyMapMapping;
import org.chromattic.core.mapping.value.RelationshipMapping;
import org.chromattic.core.mapping.value.SimpleMapping;
import org.chromattic.spi.instrument.Instrumentor;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapperBuilder {
    private static final EnumMap<RelationshipType, LinkType> relationshipToLinkMapping;
    private final Set<NodeTypeMapping> typeMappings;
    private final Instrumentor instrumentor;
    private final Map<ClassTypeInfo, NodeTypeMapping> classToMapping;
    private SetMap<ClassTypeInfo, RelatedPropertyMapper> relatedProperties = new SetMap();
    private SetMap<ClassTypeInfo, MethodMapper.Create> relatedMethods = new SetMap();

    public TypeMapperBuilder(Set<NodeTypeMapping> typeMappings, Instrumentor instrumentor) {
        HashMap<ClassTypeInfo, NodeTypeMapping> classToMapping = new HashMap<ClassTypeInfo, NodeTypeMapping>();
        for (NodeTypeMapping typeMapping : typeMappings) {
            classToMapping.put(typeMapping.getObjectClass(), typeMapping);
        }
        this.typeMappings = typeMappings;
        this.instrumentor = instrumentor;
        this.classToMapping = classToMapping;
    }

    public Collection<ObjectMapper> build() {
        try {
            return this._build();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<ObjectMapper> _build() throws ClassNotFoundException {
        HashMap<String, ObjectMapper> mappers = new HashMap<String, ObjectMapper>();
        for (NodeTypeMapping typeMapping : this.typeMappings) {
            Class contextType = typeMapping instanceof PrimaryTypeMapping ? EntityContext.class : EmbeddedContext.class;
            ObjectMapper mapper = this.createMapper(contextType, typeMapping);
            mappers.put(typeMapping.getObjectClass().getName(), mapper);
        }
        for (ClassTypeInfo relatedType : this.relatedProperties.keySet()) {
            Set properties = this.relatedProperties.get((Object)relatedType);
            HashSet<ObjectMapper> relatedTypes = new HashSet<ObjectMapper>();
            for (ObjectMapper type : mappers.values()) {
                Class<?> relatedClass = Thread.currentThread().getContextClassLoader().loadClass(relatedType.getName());
                if (!relatedClass.isAssignableFrom(type.getObjectClass())) continue;
                relatedTypes.add(type);
            }
            for (RelatedPropertyMapper propertyMapper : properties) {
                propertyMapper.relatedTypes = relatedTypes;
            }
        }
        for (ClassTypeInfo relatedType : this.relatedMethods.keySet()) {
            Set methods = this.relatedMethods.get((Object)relatedType);
            ObjectMapper relatedMapper = (ObjectMapper)mappers.get(relatedType.getName());
            if (relatedMapper == null) {
                throw new IllegalStateException("Could not find mapper for " + relatedType.getName() + " referenced by " + methods);
            }
            for (MethodMapper.Create createMapper : methods) {
                createMapper.type = relatedMapper;
            }
        }
        return new ArrayList<ObjectMapper>(mappers.values());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <C extends ObjectContext> ObjectMapper createMapper(Class<C> contextType, NodeTypeMapping typeMapping) throws ClassNotFoundException {
        ObjectMapper mapper;
        HashSet<MethodMapper> methodMappers = new HashSet<MethodMapper>();
        HashSet<MethodMapper.Destroy> methodMappersForE = new HashSet<MethodMapper.Destroy>();
        HashSet<PropertyMapper> propertyMappers = new HashSet<PropertyMapper>();
        HashSet<PropertyMapper> propertyMappersForE = new HashSet<PropertyMapper>();
        HashSet<JCREmbeddedPropertyMapper> propertyMappersForM = new HashSet<JCREmbeddedPropertyMapper>();
        for (PropertyMapping pm : typeMapping.getPropertyMappings()) {
            Object pmvm;
            if (pm.getInfo() instanceof SingleValuedPropertyInfo) {
                NamedManyToOneMapping nmtovm;
                LinkType linkType;
                pmvm = pm.getValueMapping();
                SingleValuedPropertyInfo propertyInfo = (SingleValuedPropertyInfo)pm.getInfo();
                if (pmvm instanceof SimpleMapping) {
                    SimpleMapping pmdm = (SimpleMapping)pmvm;
                    Object m = pmdm.getJCRMember();
                    if (m instanceof JCRPropertyMapping) {
                        JCRPropertyMapping jCRPropertyMapping = (JCRPropertyMapping)m;
                        JCRPropertyPropertyMapper<C> jCRPropertyPropertyMapper = new JCRPropertyPropertyMapper<C>(contextType, (SingleValuedPropertyInfo)pm.getInfo(), jCRPropertyMapping.getName());
                        propertyMappers.add(jCRPropertyPropertyMapper);
                    } else if (m instanceof JCRNodeAttributeMapping) {
                        JCRNodeAttributeMapping jCRNodeAttributeMapping = (JCRNodeAttributeMapping)m;
                        JCRNodeAttributePropertyMapper jCRNodeAttributePropertyMapper = new JCRNodeAttributePropertyMapper((SingleValuedPropertyInfo)pm.getInfo(), jCRNodeAttributeMapping.getType());
                        if (contextType != EntityContext.class) throw new UnsupportedOperationException("todo");
                        propertyMappersForE.add(jCRNodeAttributePropertyMapper);
                    }
                } else if (pmvm instanceof RelationshipMapping) {
                    RelationshipMapping pmhm = (RelationshipMapping)pmvm;
                    if (pmhm.getType() == RelationshipType.HIERARCHIC) {
                        if (pmhm instanceof ManyToOneMapping) {
                            JCRAnyChildCollectionPropertyMapper jCRAnyChildCollectionPropertyMapper = new JCRAnyChildCollectionPropertyMapper(propertyInfo);
                            this.relatedProperties.get((Object)pmhm.getRelatedType()).add(jCRAnyChildCollectionPropertyMapper);
                            propertyMappersForE.add(jCRAnyChildCollectionPropertyMapper);
                        }
                        if (pmhm instanceof NamedOneToOneMapping) {
                            NamedOneToOneMapping namedOneToOneMapping = (NamedOneToOneMapping)pmhm;
                            if (namedOneToOneMapping.isOwner()) {
                                JCRNamedChildParentPropertyMapper<C> jCRNamedChildParentPropertyMapper = new JCRNamedChildParentPropertyMapper<C>(contextType, propertyInfo, namedOneToOneMapping.getName());
                                this.relatedProperties.get((Object)pmhm.getRelatedType()).add(jCRNamedChildParentPropertyMapper);
                                propertyMappers.add(jCRNamedChildParentPropertyMapper);
                            } else {
                                JCRNamedChildPropertyMapper jCRNamedChildPropertyMapper = new JCRNamedChildPropertyMapper(propertyInfo, namedOneToOneMapping.getName());
                                this.relatedProperties.get((Object)namedOneToOneMapping.getRelatedType()).add(jCRNamedChildPropertyMapper);
                                propertyMappersForE.add(jCRNamedChildPropertyMapper);
                            }
                        }
                    } else if (pmhm.getType() == RelationshipType.EMBEDDED) {
                        NodeTypeMapping nodeTypeMapping = this.classToMapping.get(((BeanValueInfo)propertyInfo.getValue()).getTypeInfo());
                        if (typeMapping instanceof PrimaryTypeMapping) {
                            JCREmbeddedParentPropertyMapper jCREmbeddedParentPropertyMapper = new JCREmbeddedParentPropertyMapper(propertyInfo);
                            propertyMappersForE.add(jCREmbeddedParentPropertyMapper);
                        } else {
                            if (!(typeMapping instanceof MixinTypeMapping)) throw new AssertionError();
                            if (!(nodeTypeMapping instanceof PrimaryTypeMapping)) throw new BuilderException("Related class in mixin mapping must be annotated with @" + PrimaryType.class.getSimpleName());
                            JCREmbeddedPropertyMapper jCREmbeddedPropertyMapper = new JCREmbeddedPropertyMapper(propertyInfo);
                            propertyMappersForM.add(jCREmbeddedPropertyMapper);
                        }
                    }
                }
                if (!(pmvm instanceof ManyToOneMapping) || !(pmvm instanceof NamedManyToOneMapping) || (linkType = relationshipToLinkMapping.get((nmtovm = (NamedManyToOneMapping)pmvm).getType())) == null) continue;
                JCRNamedReferentPropertyMapper<C> jCRNamedReferentPropertyMapper = new JCRNamedReferentPropertyMapper<C>(contextType, propertyInfo, nmtovm.getRelatedName(), linkType);
                propertyMappers.add(jCRNamedReferentPropertyMapper);
                this.relatedProperties.get((Object)nmtovm.getRelatedType()).add(jCRNamedReferentPropertyMapper);
                continue;
            }
            if (!(pm.getInfo() instanceof MultiValuedPropertyInfo)) continue;
            pmvm = pm.getValueMapping();
            if (pmvm instanceof RelationshipMapping) {
                void var13_23;
                RelationshipMapping pmhm = (RelationshipMapping)pmvm;
                if (!(pmhm instanceof OneToManyMapping)) continue;
                if (pmhm instanceof NamedOneToManyMapping) {
                    LinkType linkType = relationshipToLinkMapping.get(pmhm.getType());
                    if (linkType == null) continue;
                    NamedOneToManyMapping namedOneToManyMapping = (NamedOneToManyMapping)pmhm;
                    JCRReferentCollectionPropertyMapper jCRReferentCollectionPropertyMapper = new JCRReferentCollectionPropertyMapper((CollectionPropertyInfo)pm.getInfo(), namedOneToManyMapping.getName(), linkType);
                    this.relatedProperties.get((Object)pmhm.getRelatedType()).add(jCRReferentCollectionPropertyMapper);
                    propertyMappersForE.add(jCRReferentCollectionPropertyMapper);
                    continue;
                }
                if (pmhm.getType() != RelationshipType.HIERARCHIC) continue;
                MultiValuedPropertyInfo mpi = (MultiValuedPropertyInfo)pm.getInfo();
                if (mpi instanceof MapPropertyInfo) {
                    AnyChildMultiValueMapper.Map map = new AnyChildMultiValueMapper.Map();
                } else {
                    if (!(mpi instanceof CollectionPropertyInfo)) throw new IllegalStateException();
                    if (mpi instanceof ListPropertyInfo) {
                        AnyChildMultiValueMapper.List list = new AnyChildMultiValueMapper.List();
                    } else {
                        AnyChildMultiValueMapper.Collection collection = new AnyChildMultiValueMapper.Collection();
                    }
                }
                JCRAnyChildParentPropertyMapper<C> jCRAnyChildParentPropertyMapper = new JCRAnyChildParentPropertyMapper<C>(contextType, mpi, (AnyChildMultiValueMapper)var13_23);
                this.relatedProperties.get((Object)pmhm.getRelatedType()).add(jCRAnyChildParentPropertyMapper);
                propertyMappers.add(jCRAnyChildParentPropertyMapper);
                continue;
            }
            if (pmvm instanceof SimpleMapping) {
                SimpleMapping sm = (SimpleMapping)pmvm;
                Object jcrMember = sm.getJCRMember();
                if (!(jcrMember instanceof JCRPropertyMapping)) continue;
                JCRPropertyMapping jCRPropertyMapping = (JCRPropertyMapping)jcrMember;
                JCRPropertyListPropertyMapper<C> jCRPropertyListPropertyMapper = new JCRPropertyListPropertyMapper<C>(contextType, (MultiValuedPropertyInfo)pm.getInfo(), jCRPropertyMapping.getName());
                propertyMappers.add(jCRPropertyListPropertyMapper);
                continue;
            }
            if (!(pmvm instanceof PropertyMapMapping)) continue;
            JCRPropertyMapPropertyMapper<C> bilto = new JCRPropertyMapPropertyMapper<C>(contextType, (MapPropertyInfo)pm.getInfo());
            propertyMappers.add(bilto);
        }
        for (MethodMapping methodMapping : typeMapping.getMethodMappings()) {
            if (methodMapping instanceof CreateMapping) {
                CreateMapping createMapping = (CreateMapping)methodMapping;
                MethodMapper.Create createMapper = new MethodMapper.Create((Method)createMapping.getMethod().getMethod());
                methodMappers.add(createMapper);
                Set alffl = this.relatedMethods.get((Object)createMapping.getType());
                alffl.add(createMapper);
                continue;
            }
            if (methodMapping instanceof DestroyMapping) {
                MethodMapper.Destroy destroyMapper = new MethodMapper.Destroy((Method)methodMapping.getMethod().getMethod());
                methodMappersForE.add(destroyMapper);
                continue;
            }
            if (!(methodMapping instanceof FindByIdMapping)) throw new UnsupportedOperationException();
            FindByIdMapping findMapping = (FindByIdMapping)methodMapping;
            MethodMapper.FindById findMapper = new MethodMapper.FindById((Method)findMapping.getMethod().getMethod(), findMapping.getType());
            methodMappers.add(findMapper);
        }
        if (typeMapping instanceof PrimaryTypeMapping) {
            PrimaryTypeMapping nodeTypeMapping = (PrimaryTypeMapping)typeMapping;
            ObjectFormatter formatter = null;
            if (nodeTypeMapping.getFormatterClass() != null) {
                formatter = (ObjectFormatter)ObjectInstantiator.newInstance(nodeTypeMapping.getFormatterClass());
            }
            HashSet tmp = new HashSet(propertyMappersForE);
            HashSet tmp2 = new HashSet(methodMappersForE);
            if (propertyMappersForM.size() > 0) {
                throw new AssertionError();
            }
            for (PropertyMapper propertyMapper : propertyMappers) {
                tmp.add(propertyMapper);
            }
            for (MethodMapper methodMapper : methodMappers) {
                tmp2.add(methodMapper);
            }
            mapper = new ObjectMapper((Class)typeMapping.getObjectClass().getType(), tmp, tmp2, typeMapping.getOnDuplicate(), formatter, this.instrumentor, nodeTypeMapping.getNodeTypeName(), NodeTypeKind.PRIMARY);
        } else {
            MixinTypeMapping mixinTypeMapping = (MixinTypeMapping)typeMapping;
            if (propertyMappersForE.size() > 0) {
                throw new AssertionError();
            }
            if (methodMappersForE.size() > 0) {
                throw new AssertionError();
            }
            HashSet tmp = new HashSet(propertyMappersForM);
            HashSet tmp2 = new HashSet();
            for (PropertyMapper propertyMapper : propertyMappers) {
                tmp.add(propertyMapper);
            }
            for (MethodMapper methodMapper : methodMappers) {
                tmp2.add(methodMapper);
            }
            mapper = new ObjectMapper((Class)typeMapping.getObjectClass().getType(), tmp, tmp2, typeMapping.getOnDuplicate(), null, this.instrumentor, mixinTypeMapping.getMixinTypeName(), NodeTypeKind.MIXIN);
        }
        for (PropertyMapper pm : propertyMappers) {
            pm.mapper = mapper;
        }
        for (MethodMapper methodMapper : methodMappers) {
            methodMapper.mapper = mapper;
        }
        return mapper;
    }

    static {
        EnumMap<RelationshipType, LinkType> tmp = new EnumMap<RelationshipType, LinkType>(RelationshipType.class);
        tmp.put(RelationshipType.REFERENCE, LinkType.REFERENCE);
        tmp.put(RelationshipType.PATH, LinkType.PATH);
        relationshipToLinkMapping = tmp;
    }
}

