/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.NodeIterator;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumStatisticsService;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.InitializeForumPlugin;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.impl.ForumServiceManaged;
import org.exoplatform.forum.service.impl.JobManager;
import org.exoplatform.ks.common.conf.ManagedPlugin;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.picocontainer.Startable;
import org.quartz.JobDetail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBy(value=ForumServiceManaged.class)
public class ForumServiceImpl
implements ForumService,
Startable {
    private static final Log log = ExoLogger.getLogger(ForumServiceImpl.class);
    private DataStorage storage;
    private ForumServiceManaged managementView;
    final List<String> onlineUserList_ = new CopyOnWriteArrayList<String>();
    private String lastLogin_ = "";
    private ForumStatisticsService forumStatisticsService;
    private JobSchedulerService jobSchedulerService;

    public ForumServiceImpl(InitParams params, ExoContainerContext context, DataStorage dataStorage, ForumStatisticsService forumStatisticsService, JobSchedulerService jobSchedulerService) {
        this.storage = dataStorage;
        this.forumStatisticsService = forumStatisticsService;
        this.jobSchedulerService = jobSchedulerService;
    }

    @Override
    public void addInitRssPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitRssPlugin(plugin);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDataPlugin(plugin);
    }

    public void start() {
        try {
            log.info((Object)"initializing category listeners...");
            this.storage.initCategoryListener();
        }
        catch (Exception e) {
            log.error((Object)("Error while updating category listeners " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing default data...");
            this.storage.initDefaultData();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing default data: " + e.getMessage()));
        }
        try {
            log.info((Object)"Calculating active users...");
            this.storage.evaluateActiveUsers("");
        }
        catch (Exception e) {
            log.error((Object)("Error while calculating active users: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing RSS listeners...");
            this.storage.addRSSEventListenner();
        }
        catch (Exception e) {
            log.error((Object)("Error while RSS listeners: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing Calculate Moderators listeners...");
            this.storage.addCalculateModeratorEventListenner();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Moderators listeners: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing prune schedulers...");
            this.storage.initAutoPruneSchedules();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Prune schedulers: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing management view...");
            this.managePlugins();
            this.manageStorage();
            this.manageJobs();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Management view: " + e.getMessage()));
        }
    }

    private void manageStorage() {
        this.managementView.registerStorageManager(this.storage);
    }

    private void manageJobs() {
        try {
            List jobs = this.jobSchedulerService.getAllJobs();
            for (JobDetail jobDetail : jobs) {
                this.managementView.registerJobManager(new JobManager(jobDetail));
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to register jobs manager", (Throwable)e);
        }
    }

    private void managePlugins() {
        List<RoleRulesPlugin> plugins = this.storage.getRulesPlugins();
        for (RoleRulesPlugin plugin2 : plugins) {
            this.managementView.registerPlugin((ManagedPlugin)plugin2);
        }
        List<InitializeForumPlugin> defaultPlugins = this.storage.getDefaultPlugins();
        for (InitializeForumPlugin plugin2 : defaultPlugins) {
            this.managementView.registerPlugin(plugin2);
        }
    }

    public void stop() {
    }

    @Override
    public void addMember(User user, UserProfile profileTemplate) throws Exception {
        boolean added = this.storage.populateUserProfile(user, true);
        if (added) {
            this.forumStatisticsService.addMember(user.getUserName());
        }
    }

    @Override
    public void removeMember(User user) throws Exception {
        this.storage.deleteUserProfile(user);
        this.forumStatisticsService.removeMember(user.getUserName());
    }

    @Override
    public void createUserProfile(User user) throws Exception {
    }

    @Override
    public void updateUserProfile(User user) throws Exception {
        this.storage.populateUserProfile(user, false);
    }

    public void saveEmailUserProfile(String userId, String email) throws Exception {
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        this.storage.saveCategory(category, isNew);
    }

    @Override
    public void calculateModerator(String categoryPath, boolean isNew) throws Exception {
        this.storage.calculateModerator(categoryPath, false);
    }

    @Override
    public Category getCategory(String categoryId) throws Exception {
        return this.storage.getCategory(categoryId);
    }

    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        return this.storage.getPermissionTopicByCategory(categoryId, type);
    }

    @Override
    public List<Category> getCategories() throws Exception {
        return this.storage.getCategories();
    }

    @Override
    public Category removeCategory(String categoryId) throws Exception {
        return this.storage.removeCategory(categoryId);
    }

    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        this.storage.saveModOfCategory(moderatorCate, userId, isAdd);
    }

    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        this.storage.modifyForum(forum, type);
    }

    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage.saveForum(categoryId, forum, isNew);
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage.saveModerateOfForums(forumPaths, userName, isDelete);
    }

    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        this.storage.moveForum(forums, destCategoryPath);
    }

    @Override
    public Forum getForum(String categoryId, String forumId) throws Exception {
        return this.storage.getForum(categoryId, forumId);
    }

    @Override
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.storage.getForums(categoryId, strQuery);
    }

    @Override
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.storage.getForumSummaries(categoryId, strQuery);
    }

    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        return this.storage.removeForum(categoryId, forumId);
    }

    @Override
    public void modifyTopic(List<Topic> topics, int type) throws Exception {
        this.storage.modifyTopic(topics, type);
    }

    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        this.storage.saveTopic(categoryId, forumId, topic, isNew, isMove, defaultEmailContent);
    }

    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        return this.storage.getTopic(categoryId, forumId, topicId, userRead);
    }

    @Override
    public void setViewCountTopic(String path, String userRead) throws Exception {
        this.storage.setViewCountTopic(path, userRead);
    }

    @Override
    public Topic getTopicSummary(String topicPath) throws Exception {
        return this.storage.getTopicSummary(topicPath, true);
    }

    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        return this.storage.getTopicByPath(topicPath, isLastPost);
    }

    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String strQuery, String strOrderBy, int pageSize) throws Exception {
        return this.storage.getTopicList(categoryId, forumId, strQuery, strOrderBy, pageSize);
    }

    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        return this.storage.getTopics(categoryId, forumId);
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage.moveTopic(topics, destForumPath, mailContent, link);
    }

    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage.removeTopic(categoryId, forumId, topicId);
    }

    @Override
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage.getPost(categoryId, forumId, topicId, postId);
    }

    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getLastReadIndex(path, isApproved, isHidden, userLogin);
    }

    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        return this.storage.getPostForSplitTopic(topicPath);
    }

    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getAvailablePost(categoryId, forumId, topicId, isApproved, isHidden, userLogin);
    }

    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        this.storage.savePost(categoryId, forumId, topicId, post, isNew, defaultEmailContent);
    }

    @Override
    public void modifyPost(List<Post> posts, int type) throws Exception {
        this.storage.modifyPost(posts, type);
    }

    public void movePost(List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        String[] postPaths = new String[posts.size()];
        int i = 0;
        for (Post p : posts) {
            postPaths[i] = p.getPath();
            ++i;
        }
        this.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        this.storage.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        this.storage.mergeTopic(srcTopicPath, destTopicPath, mailContent, link);
    }

    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage.removePost(categoryId, forumId, topicId, postId);
    }

    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        return this.storage.getObjectNameByPath(path);
    }

    @Override
    public Object getObjectNameById(String path, String type) throws Exception {
        return this.storage.getObjectNameById(path, type);
    }

    @Override
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        return this.storage.getAllLink(strQueryCate, strQueryForum);
    }

    @Override
    public String getForumHomePath() throws Exception {
        return this.storage.getDataLocation().getForumHomeLocation();
    }

    @Override
    public Poll getPoll(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage.getPoll(categoryId, forumId, topicId);
    }

    @Override
    public Poll removePoll(String categoryId, String forumId, String topicId) throws Exception {
        return this.storage.removePoll(categoryId, forumId, topicId);
    }

    @Override
    public void savePoll(String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        this.storage.savePoll(categoryId, forumId, topicId, poll, isNew, isVote);
    }

    @Override
    public void setClosedPoll(String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        this.storage.setClosedPoll(categoryId, forumId, topicId, poll);
    }

    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        this.storage.addTag(tags, userName, topicPath);
    }

    @Override
    public List<Tag> getAllTags() throws Exception {
        return this.storage.getAllTags();
    }

    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        return this.storage.getMyTagInTopic(tagIds);
    }

    @Override
    public Tag getTag(String tagId) throws Exception {
        return this.storage.getTag(tagId);
    }

    @Override
    public List<String> getAllTagName(String strQuery, String userAndTopicId) throws Exception {
        return this.storage.getAllTagName(strQuery, userAndTopicId);
    }

    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        return this.storage.getTagNameInTopic(userAndTopicId);
    }

    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        return this.storage.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    @Override
    public void saveTag(Tag newTag) throws Exception {
        this.storage.saveTag(newTag);
    }

    @Override
    public void unTag(String tagId, String userName, String topicPath) throws Exception {
        this.storage.unTag(tagId, userName, topicPath);
    }

    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        this.storage.saveUserModerator(userName, ids, isModeCate);
    }

    @Override
    public void saveUserProfile(UserProfile userProfile, boolean isOption, boolean isBan) throws Exception {
        this.storage.saveUserProfile(userProfile, isOption, isBan);
    }

    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        return this.storage.getUserInfo(userName);
    }

    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        return this.storage.getUserModerator(userName, isModeCate);
    }

    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        return this.storage.getUserProfileManagement(userName);
    }

    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        this.storage.saveLastPostIdRead(userId, lastReadPostOfForum, lastReadPostOfTopic);
    }

    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        this.storage.saveUserBookmark(userName, bookMark, isNew);
    }

    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        this.storage.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        return this.storage.getPageListUserProfile();
    }

    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        return this.storage.getPrivateMessage(userName, type);
    }

    @Override
    public long getNewPrivateMessage(String userName) throws Exception {
        return this.storage.getNewPrivateMessage(userName);
    }

    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        this.storage.removePrivateMessage(messageId, userName, type);
    }

    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        this.storage.saveReadMessage(messageId, userName, type);
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        this.storage.savePrivateMessage(privateMessage);
    }

    @Override
    public ForumSubscription getForumSubscription(String userId) throws Exception {
        return this.storage.getForumSubscription(userId);
    }

    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        this.storage.saveForumSubscription(forumSubscription, userId);
    }

    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        return this.storage.getPageTopicOld(date, forumPatch);
    }

    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        return this.storage.getAllTopicsOld(date, forumPatch);
    }

    @Override
    public long getTotalTopicOld(long date, String forumPatch) {
        return this.storage.getTotalTopicOld(date, forumPatch);
    }

    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        return this.storage.getForumStatistic();
    }

    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        this.storage.saveForumStatistic(forumStatistic);
    }

    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage.updateStatisticCounts(topicCount, postCount);
    }

    @Override
    public List<ForumSearch> getQuickSearch(String textQuery, String type, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage.getQuickSearch(textQuery, type, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearch> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) throws Exception {
        return this.storage.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        return this.storage.getForumAdministration();
    }

    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        this.storage.saveForumAdministration(forumAdministration);
    }

    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage.addWatch(watchType, path, values, currentUser);
    }

    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        this.storage.removeWatch(watchType, path, values);
    }

    @Override
    public List<ForumSearch> getJobWattingForModerator(String[] paths) throws Exception {
        return this.storage.getJobWattingForModerator(paths);
    }

    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        return this.storage.getJobWattingForModeratorByUser(userId);
    }

    @Override
    public void userLogin(String userId) throws Exception {
        int ol;
        this.lastLogin_ = userId;
        if (!this.onlineUserList_.contains(userId)) {
            this.onlineUserList_.add(userId);
        }
        this.storage.updateLastLoginDate(userId);
        ForumStatistic stats = this.storage.getForumStatistic();
        int mostOnline = 0;
        String mostUsersOnline = stats.getMostUsersOnline();
        if (mostUsersOnline != null && mostUsersOnline.length() > 0) {
            String[] array = mostUsersOnline.split(",");
            try {
                mostOnline = Integer.parseInt(array[0].trim());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((ol = this.onlineUserList_.size()) > mostOnline) {
            stats.setMostUsersOnline(ol + ", at " + this.storage.getGreenwichMeanTime().getTimeInMillis());
        } else {
            stats.setMostUsersOnline("1, at " + this.storage.getGreenwichMeanTime().getTimeInMillis());
        }
        this.storage.saveForumStatistic(stats);
    }

    @Override
    public void userLogout(String userId) throws Exception {
        if (this.onlineUserList_.contains(userId)) {
            this.onlineUserList_.remove(userId);
        }
    }

    @Override
    public boolean isOnline(String userId) throws Exception {
        try {
            if (this.onlineUserList_.contains(userId)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("could not determine if user " + userId + " is online"), (Throwable)e);
        }
        return false;
    }

    @Override
    public List<String> getOnlineUsers() throws Exception {
        return this.onlineUserList_;
    }

    @Override
    public String getLastLogin() throws Exception {
        return this.lastLogin_;
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage.getMessageInfo(name);
    }

    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        return this.storage.searchUserProfile(userSearch);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.storage.isAdminRole(userName);
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        return this.storage.getNewPosts(number);
    }

    @Override
    public NodeIterator search(String queryString) throws Exception {
        return this.storage.search(queryString);
    }

    @Override
    public void evaluateActiveUsers(String query) throws Exception {
        this.storage.evaluateActiveUsers(query);
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        this.storage.updateTopicAccess(userId, topicId);
    }

    @Override
    public void updateForumAccess(String userId, String forumId) throws Exception {
        this.storage.updateForumAccess(userId, forumId);
    }

    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        return this.storage.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        return this.storage.getQuickProfiles(userList);
    }

    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        return this.storage.getQuickProfile(userName);
    }

    @Override
    public String getScreenName(String userName) throws Exception {
        return this.storage.getScreenName(userName);
    }

    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        return this.storage.getUserInformations(userProfile);
    }

    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        return this.storage.getDefaultUserProfile(userName, ip);
    }

    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        return this.storage.updateUserProfileSetting(userProfile);
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        return this.storage.getBookmarks(userName);
    }

    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        return this.storage.getUserSettingProfile(userName);
    }

    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        this.storage.saveUserSettingProfile(userProfile);
    }

    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        this.storage.importXML(nodePath, bis, typeImport);
    }

    @Override
    public void updateDataImported() throws Exception {
        this.storage.updateDataImported();
    }

    @Override
    public void updateForum(String path) throws Exception {
        this.storage.updateForum(path);
    }

    @Override
    public List<String> getBanList() throws Exception {
        return this.storage.getBanList();
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        return this.storage.addBanIP(ip);
    }

    @Override
    public void removeBan(String ip) throws Exception {
        this.storage.removeBan(ip);
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        return this.storage.getListPostsByIP(ip, strOrderBy);
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage.getForumBanList(forumId);
    }

    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        return this.storage.addBanIPForum(ip, forumId);
    }

    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        this.storage.removeBanIPForum(ip, forumId);
    }

    @Override
    public void registerListenerForCategory(String categoryId) throws Exception {
        this.storage.registerListenerForCategory(categoryId);
    }

    @Override
    public void unRegisterListenerForCategory(String path) throws Exception {
        this.storage.unRegisterListenerForCategory(path);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        return this.storage.getUserAvatar(userName);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        this.storage.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        this.storage.setDefaultAvatar(userName);
    }

    @Override
    public List<Watch> getWatchByUser(String userId) throws Exception {
        return this.storage.getWatchByUser(userId);
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        this.storage.updateEmailWatch(listNodeId, newEmailAdd, userId);
    }

    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        return this.storage.getAllPruneSetting();
    }

    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        this.storage.savePruneSetting(pruneSetting);
    }

    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        return this.storage.getPruneSetting(forumPath);
    }

    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        this.storage.runPrune(pSetting);
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.storage.runPrune(forumPath);
    }

    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        return this.storage.checkPrune(pSetting);
    }

    @Override
    public JCRPageList getPageTopicByType(String type) throws Exception {
        return this.storage.getPageTopicByType(type);
    }

    @Override
    public TopicType getTopicType(String Id) throws Exception {
        return this.storage.getTopicType(Id);
    }

    @Override
    public List<TopicType> getTopicTypes() throws Exception {
        return this.storage.getTopicTypes();
    }

    @Override
    public void removeTopicType(String topicTypeId) throws Exception {
        this.storage.removeTopicType(topicTypeId);
    }

    @Override
    public void saveTopicType(TopicType topicType) throws Exception {
        this.storage.saveTopicType(topicType);
    }

    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        this.storage.updateUserProfileInfo(name);
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    public void setStorage(DataStorage storage) {
        this.storage = storage;
    }

    public ForumServiceManaged getManagementView() {
        return this.managementView;
    }

    public void setManagementView(ForumServiceManaged managementView) {
        this.managementView = managementView;
    }

    public ForumStatisticsService getForumStatisticsService() {
        return this.forumStatisticsService;
    }

    public void setForumStatisticsService(ForumStatisticsService forumStatisticsService) {
        this.forumStatisticsService = forumStatisticsService;
    }

    public JobSchedulerService getJobSchedulerService() {
        return this.jobSchedulerService;
    }

    public void setJobSchedulerService(JobSchedulerService jobSchedulerService) {
        this.jobSchedulerService = jobSchedulerService;
    }
}

