/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterMap;
import org.gatein.common.util.SimpleMultiValuedPropertyMap;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.PortletManagedModeInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.PropertyContext;
import org.gatein.pc.portlet.impl.info.ContainerCapabilitiesInfo;
import org.gatein.pc.portlet.impl.info.ContainerNavigationInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.portlet.impl.info.ContainerSecurityInfo;
import org.gatein.pc.portlet.impl.jsr168.PortletApplicationImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletContainerImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletRequestAttributes;
import org.gatein.pc.portlet.impl.jsr168.PortletRequestParameterMap;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.pc.portlet.impl.jsr168.api.PortalContextImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletPreferencesImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestImpl
implements PortletRequest {
    protected static final Logger log = Logger.getLogger(PortletRequestImpl.class);
    protected PortletInvocation invocation;
    protected ClientContext clientContext;
    protected UserContext userContext;
    protected SecurityContext securityContext;
    protected ServerContext serverContext;
    protected WindowContext windowContext;
    protected PortletPreferences preferences;
    protected PortletContainerImpl container;
    private HttpServletRequestWrapper realReq;
    protected javax.portlet.PortalContext portalContext;
    protected PortletSessionImpl psession;
    protected int sessionStatus;
    protected ContainerNavigationInfo navigationInfo;
    private MultiValuedPropertyMap<String> properties;
    protected final PortletRequestAttributes attributes;
    protected final PortletRequestParameterMap requestParameterMap;
    protected final Set<Mode> supportedModes;
    protected final Set<org.gatein.pc.api.WindowState> supportedWindowStates;
    private final String contextPath;

    public PortletRequestImpl(PortletContainerImpl container, PortletInvocation invocation) {
        int mode = this instanceof RenderRequest ? 0 : 1;
        PropertyContext prefs = (PropertyContext)invocation.getAttribute("preferences");
        PreferencesValidator validator = container.getPreferencesValidator();
        ContainerPortletInfo info = container.getInfo();
        ContainerPreferencesInfo containerPrefs = info.getPreferences();
        ContainerNavigationInfo navigationInfo = info.getNavigation();
        UserContext userContext = invocation.getUserContext();
        HttpServletRequestWrapper realReq = new HttpServletRequestWrapper(invocation.getDispatchedRequest());
        PortletRequestAttributes attributes = new PortletRequestAttributes(invocation.getSecurityContext(), container, userContext, realReq);
        if (invocation.getRequestAttributes() != null) {
            attributes.setAttributeMap(invocation.getRequestAttributes());
        }
        this.contextPath = (String)invocation.getDispatchedRequest().getAttribute("javax.servlet.include.context_path");
        this.invocation = invocation;
        this.userContext = userContext;
        this.securityContext = invocation.getSecurityContext();
        this.serverContext = invocation.getServerContext();
        this.clientContext = invocation.getClientContext();
        this.windowContext = invocation.getWindowContext();
        this.container = container;
        this.realReq = realReq;
        this.portalContext = new PortalContextImpl(invocation.getPortalContext());
        this.attributes = attributes;
        this.preferences = new PortletPreferencesImpl(prefs, containerPrefs, validator, mode);
        this.navigationInfo = navigationInfo;
        this.requestParameterMap = PortletRequestParameterMap.create((NavigationInfo)navigationInfo, invocation);
        this.supportedModes = this.buildSupportedModes();
        this.supportedWindowStates = this.buildSupportedWindowState();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name should not be null");
        }
        ParameterMap parameters = this.requestParameterMap.getParameters();
        return parameters != null ? parameters.getValue(name) : null;
    }

    public Enumeration<String> getParameterNames() {
        ParameterMap parameters = this.requestParameterMap.getParameters();
        return parameters != null ? Collections.enumeration(parameters.keySet()) : Tools.EMPTY_ENUMERATION;
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name shoudl not be null");
        }
        ParameterMap parameters = this.requestParameterMap.getParameters();
        return parameters != null ? parameters.getValues(name) : null;
    }

    public Map<String, String[]> getParameterMap() {
        ParameterMap parameters = this.requestParameterMap.getParameters();
        if (parameters != null) {
            return Collections.unmodifiableMap(parameters);
        }
        return Collections.emptyMap();
    }

    public WindowState getWindowState() {
        String s = this.invocation.getWindowState().toString();
        return PortletUtils.decodeWindowState(s);
    }

    public PortletMode getPortletMode() {
        String s = this.invocation.getMode().toString();
        return PortletUtils.decodePortletMode(s);
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        return this.attributes.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Tools.toEnumeration(this.attributes.getAttributeNames());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.removeAttribute(name);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return (String)this.getProperties().getValue(name);
    }

    public Enumeration<String> getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        List properties = this.getProperties().getValues(name);
        if (properties == null) {
            return Tools.emptyEnumeration();
        }
        return Collections.enumeration(properties);
    }

    public Enumeration<String> getPropertyNames() {
        Set names = this.getProperties().keySet();
        return Collections.enumeration(names);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getAuthType() {
        return this.securityContext.getAuthType();
    }

    public String getRemoteUser() {
        return this.securityContext.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public boolean isUserInRole(String roleName) {
        ContainerSecurityInfo securityRoleRefsMap = this.container.getInfo().getSecurity();
        String roleLink = securityRoleRefsMap.getRoleRef(roleName);
        if (roleLink == null) {
            if (securityRoleRefsMap.containsRoleRef(roleName)) {
                return this.securityContext.isUserInRole(roleName);
            }
            return false;
        }
        return this.securityContext.isUserInRole(roleLink);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public String getResponseContentType() {
        return this.invocation.getContext().getMarkupInfo().getMediaType().getValue();
    }

    public Enumeration<String> getResponseContentTypes() {
        return Tools.toEnumeration((Object)this.getResponseContentType());
    }

    public Locale getLocale() {
        return this.userContext.getLocale();
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        if (portletMode == null) {
            log.warn((Object)"Try to test a null portlet mode");
            return false;
        }
        return this.supportedModes.contains(Mode.create((String)portletMode.toString()));
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return this.supportedWindowStates.contains(org.gatein.pc.api.WindowState.create((String)windowState.toString()));
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        if (this.psession != null && !this.psession.isValid()) {
            this.psession = null;
        }
        if (this.psession == null) {
            if (create) {
                HttpSession hsession = this.realReq.getSession();
                PortletApplicationImpl portletApp = (PortletApplicationImpl)this.container.getPortletApplication();
                this.psession = new PortletSessionImpl(hsession, this.windowContext.getId(), portletApp.getPortletContext());
            } else {
                HttpSession hsession = this.realReq.getSession(false);
                if (hsession != null) {
                    PortletApplicationImpl portletApp = (PortletApplicationImpl)this.container.getPortletApplication();
                    this.psession = new PortletSessionImpl(hsession, this.windowContext.getId(), portletApp.getPortletContext());
                }
            }
        }
        return this.psession;
    }

    public javax.portlet.PortalContext getPortalContext() {
        return this.portalContext;
    }

    public String getRequestedSessionId() {
        return this.realReq.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.realReq.isRequestedSessionIdValid();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.userContext.getLocales());
    }

    public String getScheme() {
        return this.serverContext.getScheme();
    }

    public String getServerName() {
        return this.serverContext.getServerName();
    }

    public int getServerPort() {
        return this.serverContext.getServerPort();
    }

    public PortletPreferences getPreferences() {
        return this.preferences;
    }

    public PortletRequestAttributes getAttributes() {
        return this.attributes;
    }

    public String getWindowID() {
        return this.windowContext.getId();
    }

    public Cookie[] getCookies() {
        List cookies = this.clientContext.getCookies();
        if (cookies.isEmpty()) {
            return null;
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public Map<String, String[]> getPrivateParameterMap() {
        ParameterMap parameters = this.requestParameterMap.getPrivateParameters();
        if (parameters != null) {
            return Collections.unmodifiableMap(parameters);
        }
        return Collections.emptyMap();
    }

    public Map<String, String[]> getPublicParameterMap() {
        ParameterMap parameters = this.requestParameterMap.getPublicParameters();
        if (parameters != null) {
            return Collections.unmodifiableMap(parameters);
        }
        return Collections.emptyMap();
    }

    public final HttpServletRequestWrapper getRealRequest() {
        return this.realReq;
    }

    private MultiValuedPropertyMap<String> getProperties() {
        if (this.properties == null) {
            SimpleMultiValuedPropertyMap properties = new SimpleMultiValuedPropertyMap();
            properties.append(this.clientContext.getProperties());
            this.initProperties((MultiValuedPropertyMap<String>)properties);
            this.properties = properties;
        }
        return this.properties;
    }

    protected void initProperties(MultiValuedPropertyMap<String> properties) {
    }

    private Set<Mode> buildSupportedModes() {
        MarkupInfo si = this.invocation.getContext().getMarkupInfo();
        PortalContext portalContext = this.invocation.getPortalContext();
        ContainerCapabilitiesInfo capabilities = this.container.getInfo().getCapabilities();
        HashSet<Mode> modes = new HashSet<Mode>();
        for (ModeInfo modeInfo : capabilities.getModes(si.getMediaType())) {
            Mode mode = modeInfo.getMode();
            if (!(modeInfo instanceof PortletManagedModeInfo) && !portalContext.getModes().contains(mode)) continue;
            modes.add(mode);
        }
        return modes;
    }

    private Set<org.gatein.pc.api.WindowState> buildSupportedWindowState() {
        return new HashSet<org.gatein.pc.api.WindowState>(this.invocation.getPortalContext().getWindowStates());
    }
}

