/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.HashMap;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDefinitionDataHolder {
    private static Log LOG = ExoLogger.getLogger((String)"jcr.ItemDefinitionDataHolder");
    private final HashMap<ChildNodeDefKey, NodeDefinitionData> nodeDefinitions;
    private final HashMap<PropertyDefKey, PropertyDefinitionData> propertyDefinitions;
    private final HashMap<DefaultNodeDefKey, NodeDefinitionData> defNodeDefinitions;

    public ItemDefinitionDataHolder() {
        this.nodeDefinitions = new HashMap();
        this.propertyDefinitions = new HashMap();
        this.defNodeDefinitions = new HashMap();
    }

    private ItemDefinitionDataHolder(HashMap<ChildNodeDefKey, NodeDefinitionData> nodeDefinitions, HashMap<PropertyDefKey, PropertyDefinitionData> propertyDefinitions, HashMap<DefaultNodeDefKey, NodeDefinitionData> defNodeDefinitions) {
        this.nodeDefinitions = nodeDefinitions;
        this.propertyDefinitions = propertyDefinitions;
        this.defNodeDefinitions = defNodeDefinitions;
    }

    public NodeDefinitionData getChildNodeDefinition(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.getNodeDefinitionFromThisOrSupertypes(parentNodeType, childName, childNodeType);
        return def;
    }

    public NodeDefinitionData getDefaultChildNodeDefinition(InternalQName childName, InternalQName ... nodeTypes) {
        NodeDefinitionData def;
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.defNodeDefinitions.get(new DefaultNodeDefKey(parentNodeType, childName));
            if (def == null) continue;
            return def;
        }
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.defNodeDefinitions.get(new DefaultNodeDefKey(parentNodeType, Constants.JCR_ANY_NAME));
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public PropertyDefinitionData getPropertyDefinition(InternalQName childName, boolean multiValued, InternalQName parentNodeType) {
        PropertyDefKey key = new PropertyDefKey(parentNodeType, childName, multiValued);
        PropertyDefinitionData def = this.propertyDefinitions.get(key);
        if (def == null) {
            return this.propertyDefinitions.get(new PropertyDefKey(parentNodeType, Constants.JCR_ANY_NAME, multiValued));
        }
        return def;
    }

    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName ... nodeTypes) {
        PropertyDefinitionDatas pdefs = new PropertyDefinitionDatas();
        for (InternalQName nt : nodeTypes) {
            PropertyDefinitionData def = this.propertyDefinitions.get(new PropertyDefKey(nt, propertyName, false));
            if (def != null && pdefs.getDefinition(def.isMultiple()) == null) {
                pdefs.setDefinition(def);
            }
            if ((def = this.propertyDefinitions.get(new PropertyDefKey(nt, propertyName, true))) == null || pdefs.getDefinition(def.isMultiple()) != null) continue;
            pdefs.setDefinition(def);
        }
        return pdefs.getAnyDefinition() != null ? pdefs : null;
    }

    void putDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                ChildNodeDefKey nodeDefKey = new ChildNodeDefKey(name, nodeDef.getName(), rnt);
                this.nodeDefinitions.put(nodeDefKey, nodeDef);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString() + " hash: " + nodeDefKey.hashCode()));
            }
            DefaultNodeDefKey defNodeDefKey = new DefaultNodeDefKey(name, nodeDef.getName());
            this.defNodeDefinitions.put(defNodeDefKey, nodeDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Default NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + (Object)((Object)nodeDef.getName()) + " hash: " + defNodeDefKey.hashCode()));
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            PropertyDefKey propDefKey = new PropertyDefKey(name, propDef.getName(), propDef.isMultiple());
            this.propertyDefinitions.put(propDefKey, propDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("PropDef added: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple() + " hash: " + propDefKey.hashCode()));
        }
    }

    void removeDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                ChildNodeDefKey nodeDefKey = new ChildNodeDefKey(name, nodeDef.getName(), rnt);
                this.nodeDefinitions.remove(nodeDefKey);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString() + " hash: " + nodeDefKey.hashCode()));
            }
            DefaultNodeDefKey defNodeDefKey = new DefaultNodeDefKey(name, nodeDef.getName());
            this.defNodeDefinitions.remove(defNodeDefKey);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Default NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + (Object)((Object)nodeDef.getName()) + " hash: " + defNodeDefKey.hashCode()));
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            PropertyDefKey propDefKey = new PropertyDefKey(name, propDef.getName(), propDef.isMultiple());
            this.propertyDefinitions.remove(propDefKey);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("PropDef remode: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple() + " hash: " + propDefKey.hashCode()));
        }
    }

    private NodeDefinitionData getNodeDefinitionFromThisOrSupertypes(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.nodeDefinitions.get(new ChildNodeDefKey(parentNodeType, childName, childNodeType));
        if (def != null) {
            return def;
        }
        return def;
    }

    protected ItemDefinitionDataHolder createCopy() {
        return new ItemDefinitionDataHolder(new HashMap<ChildNodeDefKey, NodeDefinitionData>(this.nodeDefinitions), new HashMap<PropertyDefKey, PropertyDefinitionData>(this.propertyDefinitions), new HashMap<DefaultNodeDefKey, NodeDefinitionData>(this.defNodeDefinitions));
    }

    private class PropertyDefKey
    extends ItemDefKey {
        private final boolean multiValued;
        private int hashCode;

        private PropertyDefKey(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
            super(parentNodeType, childName);
            this.hashCode = -1;
            this.multiValued = multiValued;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof PropertyDefKey)) {
                return false;
            }
            PropertyDefKey other = (PropertyDefKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.multiValued == other.multiValued;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + this.getOuterType().hashCode();
                this.hashCode = result = 31 * result + (this.multiValued ? 1231 : 1237);
            }
            return this.hashCode;
        }

        public String toString() {
            String result = super.toString();
            result = result + " multiValued=" + this.multiValued;
            return result;
        }

        private ItemDefinitionDataHolder getOuterType() {
            return ItemDefinitionDataHolder.this;
        }
    }

    private abstract class ItemDefKey {
        private final InternalQName parentNodeType;
        private final InternalQName childName;
        private int hashCode = -1;

        protected ItemDefKey(InternalQName parentNodeType, InternalQName childName) {
            this.parentNodeType = parentNodeType;
            this.childName = childName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ItemDefKey)) {
                return false;
            }
            ItemDefKey other = (ItemDefKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.childName == null ? other.childName != null : !this.childName.equals((Object)other.childName)) {
                return false;
            }
            return !(this.parentNodeType == null ? other.parentNodeType != null : !this.parentNodeType.equals((Object)other.parentNodeType));
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getOuterType().hashCode();
                result = 31 * result + (this.childName == null ? 0 : this.childName.hashCode());
                this.hashCode = result = 31 * result + (this.parentNodeType == null ? 0 : this.parentNodeType.hashCode());
            }
            return this.hashCode;
        }

        public String toString() {
            String result = "";
            result = result + (this.childName == null ? Integer.valueOf(0) : this.childName.getAsString());
            result = result + (this.parentNodeType == null ? Integer.valueOf(0) : this.parentNodeType.getAsString());
            return result;
        }

        private ItemDefinitionDataHolder getOuterType() {
            return ItemDefinitionDataHolder.this;
        }
    }

    private class DefaultNodeDefKey
    extends ItemDefKey {
        private DefaultNodeDefKey(InternalQName parentNodeType, InternalQName childName) {
            super(parentNodeType, childName);
        }
    }

    private class ChildNodeDefKey
    extends ItemDefKey {
        private int hashCode;
        private final InternalQName childNodeType;

        private ChildNodeDefKey(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
            super(parentNodeType, childName);
            this.hashCode = -1;
            this.childNodeType = childNodeType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ChildNodeDefKey)) {
                return false;
            }
            ChildNodeDefKey other = (ChildNodeDefKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.childNodeType == null ? other.childNodeType != null : !this.childNodeType.equals((Object)other.childNodeType));
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + this.getOuterType().hashCode();
                this.hashCode = result = 31 * result + (this.childNodeType == null ? 0 : this.childNodeType.hashCode());
            }
            return this.hashCode;
        }

        public String toString() {
            String result = super.toString();
            result = result + (this.childNodeType == null ? "" : this.childNodeType.getAsString());
            return result;
        }

        private ItemDefinitionDataHolder getOuterType() {
            return ItemDefinitionDataHolder.this;
        }
    }
}

