/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.ks.common.jcr.JCRTask;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.VoidReturn;
import org.exoplatform.ks.rss.FeedContentProvider;
import org.exoplatform.ks.rss.FeedListener;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.ks.rss.RSSProcess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnswersFeedGenerator
extends RSSProcess
implements FeedContentProvider,
FeedListener {
    private static final Log LOG = ExoLogger.getLogger(AnswersFeedGenerator.class);
    public static final String FAQ_RSS_TYPE = "exo:faqRSS".intern();
    public static final String KS_FAQ = "faq".intern();
    public static final String FAQ_APP = "faqApp".intern();

    public AnswersFeedGenerator() {
    }

    public AnswersFeedGenerator(KSDataLocation dataLocator) {
        super(dataLocator);
    }

    @Override
    public void itemAdded(String path) {
        try {
            ItemSavedTask task = new ItemSavedTask(path, false);
            this.dataLocator.getSessionManager().executeAndSave((JCRTask)task);
        }
        catch (Exception e) {
            LOG.error((Object)("itemAdded failed for" + path), (Throwable)e);
        }
    }

    @Override
    public void itemUpdated(String path) {
        try {
            ItemSavedTask task = new ItemSavedTask(path, true);
            this.dataLocator.getSessionManager().executeAndSave((JCRTask)task);
        }
        catch (Exception e) {
            LOG.error((Object)("itemUpdated failed for" + path), (Throwable)e);
        }
    }

    protected void itemSaved(String path, boolean updated) throws Exception {
        Node questionNode = this.findQuestionNode(path);
        if (questionNode == null) {
            LOG.debug((Object)("generate Feed event was ignored on " + path));
            return;
        }
        String questionNodeName = questionNode.getName();
        PropertyReader question = new PropertyReader(questionNode);
        Node categoryNode = questionNode.getParent().getParent();
        PropertyReader category = new PropertyReader(categoryNode);
        String categoryDescription = category.string("exo:description", "eXo link:" + RSS.DEFAULT_FEED_LINK);
        String categoryTitle = category.string("exo:name", "Home");
        if (!question.bool("exo:isActivated").booleanValue() || !question.bool("exo:isApproved").booleanValue()) {
            RSS rss = new RSS(categoryNode);
            SyndFeed feed = rss.removeEntry(questionNodeName);
            feed.setTitle(categoryTitle);
            feed.setDescription(categoryDescription);
            rss.saveFeed(feed, FAQ_RSS_TYPE);
            return;
        }
        SyndEntry entry = this.createQuestionEntry(questionNode);
        RSS data = new RSS(categoryNode);
        if (data.feedExists()) {
            SyndFeed feed = null;
            if (updated) {
                feed = data.removeEntry(questionNodeName);
            }
            feed = data.addEntry(entry);
            feed.setDescription(categoryDescription);
            feed.setTitle(categoryTitle);
            data.saveFeed(feed, FAQ_RSS_TYPE);
        } else {
            SyndFeed feed = RSS.createNewFeed(categoryTitle, category.date("exo:createdDate", new Date()));
            feed.setDescription(categoryDescription);
            String categoryLink = entry.getLink() + "?portal:componentId=faq&portal:type=action&portal:isSecure=false&uicomponent=UICategories&op=OpenCategory&" + "objectId=" + question.string("exo:categoryId");
            feed.setLink(categoryLink);
            feed.setEntries(Arrays.asList(entry));
            data.saveFeed(feed, FAQ_RSS_TYPE);
        }
    }

    private SyndEntry createQuestionEntry(Node questionNode) throws Exception {
        String linkItem = this.getPageLink();
        linkItem = linkItem + "?portal:componentId=faq&portal:type=action&portal:isSecure=false&uicomponent=UIQuestions&op=ViewQuestion&objectId=";
        linkItem = linkItem + questionNode.getPath().substring(questionNode.getPath().indexOf("/categories/") + 1);
        ArrayList<String> listContent = new ArrayList<String>();
        StringBuffer content = new StringBuffer();
        if (questionNode.hasNode("faqAnswerHome") && questionNode.getNode("faqAnswerHome").hasNodes()) {
            for (String answer : this.getAnswers(questionNode)) {
                content.append(" <b><u>Answer:</u></b> ").append(answer).append(". ");
            }
        }
        if (questionNode.hasNode("faqCommentHome") && questionNode.getNode("faqCommentHome").hasNodes()) {
            for (String comment : this.getComments(questionNode)) {
                content.append(" <b><u>Comment:</u></b> ").append(comment).append(". ");
            }
        }
        listContent.add(content.toString());
        SyndContentImpl description = new SyndContentImpl();
        description.setType(RSS.PLAIN_TEXT);
        String questionNodeName = questionNode.getName();
        PropertyReader question = new PropertyReader(questionNode);
        description.setValue(question.string("exo:name") + ". " + content);
        String title = question.string("exo:title");
        Date created = question.date("exo:createdDate");
        String owner = question.string("exo:author");
        SyndEntry entry = RSS.createNewEntry(questionNodeName, title, linkItem, listContent, (SyndContent)description, created, owner);
        entry.setLink(linkItem);
        return entry;
    }

    private Node findQuestionNode(String nodePath) {
        try {
            Node questionNode = (Node)this.getCurrentSession().getItem(nodePath);
            if (!(questionNode.isNodeType("exo:faqQuestion") || questionNode.isNodeType("exo:answer") || questionNode.isNodeType("exo:answerHome") || questionNode.isNodeType("exo:comment") || questionNode.isNodeType("exo:commentHome"))) {
                return null;
            }
            if (questionNode.isNodeType("exo:answer") || questionNode.isNodeType("exo:comment") ? !(questionNode = questionNode.getParent().getParent()).isNodeType("exo:faqQuestion") : (questionNode.isNodeType("exo:answerHome") || questionNode.isNodeType("exo:commentHome")) && !(questionNode = questionNode.getParent()).isNodeType("exo:faqQuestion")) {
                return null;
            }
            if (!questionNode.isNodeType("exo:faqQuestion")) {
                return null;
            }
            return questionNode;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to identify question Node for path" + nodePath), (Throwable)e);
            return null;
        }
    }

    List<String> getAnswers(Node questionNode) throws Exception {
        ArrayList<String> listAnswers = new ArrayList<String>();
        try {
            if (questionNode.hasNode("faqAnswerHome")) {
                NodeIterator nodeIterator = questionNode.getNode("faqAnswerHome").getNodes();
                Node answerNode = null;
                int i = 0;
                while (nodeIterator.hasNext()) {
                    answerNode = nodeIterator.nextNode();
                    if (answerNode.hasProperty("exo:responses") && answerNode.getProperty("exo:approveResponses").getBoolean() && answerNode.getProperty("exo:activateResponses").getBoolean()) {
                        listAnswers.add(answerNode.getProperty("exo:responses").getValue().getString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get answers for " + questionNode.getName()), (Throwable)e);
        }
        return listAnswers;
    }

    List<String> getComments(Node questionNode) throws Exception {
        ArrayList<String> listComment = new ArrayList<String>();
        try {
            if (questionNode.hasNode("faqCommentHome")) {
                NodeIterator nodeIterator = questionNode.getNode("faqCommentHome").getNodes();
                Node commentNode = null;
                while (nodeIterator.hasNext()) {
                    commentNode = nodeIterator.nextNode();
                    if (!commentNode.hasProperty("exo:comments")) continue;
                    listComment.add(commentNode.getProperty("exo:comments").getValue().getString());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get comments for " + questionNode.getName()), (Throwable)e);
        }
        return listComment;
    }

    @Override
    public InputStream getFeedContent(String targetId) {
        return (InputStream)this.dataLocator.getSessionManager().executeAndSave((JCRTask)new GetFeedStreamTask(targetId));
    }

    private Node getAnswersServiceHome() throws Exception {
        String path = this.dataLocator.getFaqHomeLocation();
        return this.dataLocator.getSessionManager().getCurrentSession().getRootNode().getNode(path);
    }

    @Override
    public void itemRemoved(String path) {
        this.dataLocator.getSessionManager().executeAndSave((JCRTask)new ItemRemovedTask(path));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemRemovedTask
    implements JCRTask<VoidReturn> {
        private String path;

        public ItemRemovedTask(String path) {
            this.path = path;
        }

        public VoidReturn execute(Session session) throws Exception {
            String categoryPath = this.path.substring(0, this.path.indexOf("/questions/"));
            Node categoryNode = (Node)AnswersFeedGenerator.this.getCurrentSession().getItem(categoryPath);
            while (!categoryNode.isNodeType("exo:faqCategory")) {
                categoryNode = categoryNode.getParent();
            }
            String itemId = this.path.substring(this.path.lastIndexOf("/") + 1);
            RSS rss = new RSS(categoryNode);
            SyndFeed feed = rss.removeEntry(itemId);
            String title = new PropertyReader(categoryNode).string("exo:name", "Root");
            feed.setTitle(title);
            rss.saveFeed(feed, FAQ_RSS_TYPE);
            return VoidReturn.VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetFeedStreamTask
    implements JCRTask<InputStream> {
        private String targetId;

        public GetFeedStreamTask(String targetId) {
            this.targetId = targetId;
        }

        public InputStream execute(Session session) throws Exception {
            Node parentNode = AnswersFeedGenerator.this.getAnswersServiceHome().getNode(this.targetId);
            return AnswersFeedGenerator.this.getFeedStream(parentNode, FAQ_RSS_TYPE, "ANSWERS RSS FEED");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemSavedTask
    implements JCRTask<VoidReturn> {
        private String path;
        private boolean updated;

        public ItemSavedTask(String path, boolean updated) {
            this.path = path;
            this.updated = updated;
        }

        public VoidReturn execute(Session session) throws Exception {
            AnswersFeedGenerator.this.itemSaved(this.path, this.updated);
            return VoidReturn.VALUE;
        }
    }
}

