/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.jboss.aop.ConstructionInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructionInvocationWrapper;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructionInvocation
extends InvocationBase {
    private static final long serialVersionUID = -6040602776303875808L;
    protected Object[] arguments = null;
    protected transient Constructor<?> constructor = null;

    public ConstructionInvocation(Interceptor[] interceptors, Constructor<?> con, Object[] args) {
        super(interceptors);
        this.constructor = con;
        this.arguments = args;
    }

    public ConstructionInvocation(Interceptor[] interceptors, Constructor<?> con) {
        super(interceptors);
        this.constructor = con;
    }

    public ConstructionInvocation(ConstructionInfo info, Interceptor[] interceptors) {
        super(interceptors);
        this.constructor = info.getConstructor();
        this.advisor = info.getAdvisor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeNext() throws Throwable {
        if (this.interceptors != null && this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        return this.invokeTarget();
    }

    @Override
    public Object invokeTarget() throws Throwable {
        return null;
    }

    @Override
    public Object resolveAnnotation(Class<? extends Annotation> annotation) {
        return this.resolveTypedAnnotation(annotation);
    }

    @Override
    public <T extends Annotation> T resolveTypedAnnotation(Class<T> annotation) {
        T val = super.resolveTypedAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveTypedAnnotation(this.constructor, annotation)) != null) {
            return val;
        }
        return null;
    }

    @Override
    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getConstructorMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getDefaultMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        return null;
    }

    @Override
    public Invocation getWrapper(Interceptor[] newchain) {
        ConstructionInvocationWrapper wrapper = new ConstructionInvocationWrapper(this, newchain);
        return wrapper;
    }

    @Override
    public Invocation copy() {
        ConstructionInvocation wrapper = new ConstructionInvocation(this.interceptors, this.constructor, this.arguments);
        wrapper.setAdvisor(this.getAdvisor());
        wrapper.currentInterceptor = this.currentInterceptor;
        wrapper.metadata = this.metadata;
        return wrapper;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }
}

