/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.serialize;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.common.ThreadSoftRef;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.token.attribute.Attribute;
import org.exoplatform.services.token.attribute.AttributeParser;
import org.exoplatform.services.token.attribute.Attributes;
import org.exoplatform.services.xml.parser.XMLDocument;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.serialize.NodeMap;
import org.exoplatform.services.xml.serialize.NodesMap;
import org.exoplatform.services.xml.serialize.XMLMapper;
import org.exoplatform.services.xml.serialize.XMLSerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean2XML
implements XMLMapper {
    static ThreadSoftRef<Bean2XML> MAPPER = new ThreadSoftRef(Bean2XML.class);

    public static final Bean2XML getInstance() {
        return MAPPER.getRef();
    }

    @Override
    public XMLDocument toXMLDocument(Object bean) throws Exception {
        NodeMap map = bean.getClass().getAnnotation(NodeMap.class);
        if (map == null) {
            return null;
        }
        XMLNode node = new XMLNode(map.value().toCharArray(), map.value(), TypeToken.TAG);
        this.toXML(bean, node);
        return new XMLDocument(node);
    }

    @Override
    public void toXML(Object bean, XMLNode node) throws Exception {
        NodeMap map = bean.getClass().getAnnotation(NodeMap.class);
        if (map == null) {
            return;
        }
        this.toXMLValue(bean.getClass(), map.depth(), bean, node);
    }

    private void toXMLValue(Class<?> clazz, int depth, Object bean, XMLNode node) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType().isArray()) {
                this.toArray(field, bean, node);
                continue;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                this.toCollection(field, bean, node);
                continue;
            }
            this.toField(field, bean, node);
        }
        if (--depth <= 0 || clazz.getSuperclass() == null) {
            return;
        }
        this.toXMLValue(clazz.getSuperclass(), depth, bean, node);
    }

    protected void toField(Field field, Object bean, XMLNode node) throws Exception {
        if (bean == null) {
            return;
        }
        NodeMap map = field.getAnnotation(NodeMap.class);
        if (map == null) {
            return;
        }
        String name = map.value();
        boolean isAttribute = map.attribute();
        Class<?> type = field.getType();
        Object value = null;
        field.setAccessible(true);
        if (type.isPrimitive()) {
            try {
                value = this.getValue(type, field, bean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isAttribute) {
                this.setAttribute(node, name, (String)value);
            } else {
                this.setChild(node, name, (String)value);
            }
            return;
        }
        value = this.getValue(field, bean);
        if (XMLSerialize.REFLECT_UTIL.getRef().isPrimitiveType(type)) {
            if (value == null) {
                value = "";
            }
            if (isAttribute) {
                this.setAttribute(node, name, value.toString());
            } else {
                this.setChild(node, name, value.toString());
            }
            return;
        }
        XMLMapper mapper = XMLSerialize.getInstance().getXMLMapper(type);
        if (mapper == null) {
            if (value == null) {
                value = "";
            }
            if (isAttribute) {
                this.setAttribute(node, name, value.toString());
            } else {
                this.setChild(node, name, value.toString());
            }
            return;
        }
        XMLNode child = new XMLNode(name.toCharArray(), name, TypeToken.TAG);
        node.getChildren().add(child);
        NodeMap valueMap = value.getClass().getAnnotation(NodeMap.class);
        if (valueMap == null) {
            this.toXMLValue(value.getClass(), 1, value, child);
            return;
        }
        XMLNode valueNode = new XMLNode(valueMap.value().toCharArray(), valueMap.value(), TypeToken.TAG);
        child.addChild(valueNode);
        this.toXMLValue(value.getClass(), map.depth(), value, valueNode);
    }

    private void toCollection(Field field, Object bean, XMLNode parent) {
        NodesMap map = field.getAnnotation(NodesMap.class);
        if (map == null) {
            return;
        }
        field.setAccessible(true);
        String name = map.value();
        XMLNode node = new XMLNode(name.toCharArray(), name, TypeToken.TAG);
        parent.getChildren().add(node);
        if (bean == null) {
            return;
        }
        Object values = this.getValue(field, bean);
        Collection collection = (Collection)values;
        Object[] array = new Object[collection.size()];
        collection.toArray(array);
        this.toArray(node, (Object)array, map);
    }

    private void toArray(Field field, Object bean, XMLNode parent) {
        NodesMap map = field.getAnnotation(NodesMap.class);
        if (map == null) {
            return;
        }
        field.setAccessible(true);
        String name = map.value();
        XMLNode node = new XMLNode(name.toCharArray(), name, TypeToken.TAG);
        parent.getChildren().add(node);
        if (bean == null) {
            return;
        }
        Object values = this.getValue(field, bean);
        this.toArray(node, values, map);
    }

    private void toArray(XMLNode node, Object values, NodesMap map) {
        if (values == null) {
            return;
        }
        int length = Array.getLength(values);
        for (int i = 0; i < length; ++i) {
            String itemName = map.item();
            Object value = Array.get(values, i);
            if (value == null) continue;
            Class<?> type = value.getClass();
            XMLNode child = new XMLNode(itemName.toCharArray(), itemName, TypeToken.TAG);
            node.getChildren().add(child);
            if (type.isPrimitive() || XMLSerialize.REFLECT_UTIL.getRef().isPrimitiveType(type)) {
                child.addChild(new XMLNode(value.toString().toCharArray(), null, TypeToken.CONTENT));
                continue;
            }
            XMLMapper mapper = XMLSerialize.getInstance().getXMLMapper(value.getClass());
            if (mapper == null) {
                child.addChild(new XMLNode(value.toString().toCharArray(), null, TypeToken.CONTENT));
                continue;
            }
            try {
                NodeMap valueMap = value.getClass().getAnnotation(NodeMap.class);
                if (valueMap == null) {
                    mapper.toXML(value, child);
                    return;
                }
                XMLNode valueNode = new XMLNode(valueMap.value().toCharArray(), valueMap.value(), TypeToken.TAG);
                child.addChild(valueNode);
                mapper.toXML(value, valueNode);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private Object getValue(Field field, Object bean) {
        Object value = null;
        try {
            Method method = XMLSerialize.REFLECT_UTIL.getRef().getGetterMethod(bean.getClass(), field);
            if (method != null) {
                value = method.invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        try {
            value = field.get(bean);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    private String getValue(Class<?> type, Field field, Object bean) throws Exception {
        try {
            Method method = XMLSerialize.REFLECT_UTIL.getRef().getGetterMethod(bean.getClass(), field);
            if (method != null) {
                return String.valueOf(method.invoke(bean, new Object[0]));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (type == Boolean.TYPE) {
            return String.valueOf(field.getBoolean(bean));
        }
        if (type == Byte.TYPE) {
            return String.valueOf(field.getByte(bean));
        }
        if (type == Character.TYPE) {
            return String.valueOf(field.getChar(bean));
        }
        if (type == Short.TYPE) {
            return String.valueOf(field.getShort(bean));
        }
        if (type == Integer.TYPE) {
            return String.valueOf(field.getInt(bean));
        }
        if (type == Long.TYPE) {
            return String.valueOf(field.getLong(bean));
        }
        if (type == Float.TYPE) {
            return String.valueOf(field.getFloat(bean));
        }
        if (type == Double.TYPE) {
            return String.valueOf(field.getDouble(bean));
        }
        return "";
    }

    private void setChild(XMLNode parent, String name, String value) {
        List<XMLNode> children = parent.getChildren();
        for (XMLNode ele : children) {
            if (!ele.getName().equals(name)) continue;
            ele.addChild(new XMLNode(value.toCharArray(), null, TypeToken.CONTENT));
            return;
        }
        XMLNode node = new XMLNode(name.toCharArray(), name, TypeToken.TAG);
        node.addChild(new XMLNode(value.toCharArray(), null, TypeToken.CONTENT));
        children.add(node);
    }

    private void setAttribute(XMLNode parent, String name, String value) {
        Attributes attrs = AttributeParser.getAttributes(parent);
        for (Attribute ele : attrs) {
            if (!ele.getName().equals(name)) continue;
            ele.setValue(value);
            return;
        }
        Attribute attr = new Attribute(name, value);
        attrs.set(attr);
    }
}

