/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.Comment2000Atom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.util.LittleEndian;

public class Comment2000
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 12000L;
    private CString authorRecord;
    private CString authorInitialsRecord;
    private CString commentRecord;
    private Comment2000Atom commentAtom;

    public Comment2000Atom getComment2000Atom() {
        return this.commentAtom;
    }

    public String getAuthor() {
        return this.authorRecord.getText();
    }

    public void setAuthor(String author) {
        this.authorRecord.setText(author);
    }

    public String getAuthorInitials() {
        return this.authorInitialsRecord.getText();
    }

    public void setAuthorInitials(String initials) {
        this.authorInitialsRecord.setText(initials);
    }

    public String getText() {
        return this.commentRecord.getText();
    }

    public void setText(String text) {
        this.commentRecord.setText(text);
    }

    protected Comment2000(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (!(this._children[0] instanceof CString)) {
            throw new IllegalStateException("First child record wasn't a CString, was of type " + this._children[0].getRecordType());
        }
        this.authorRecord = (CString)this._children[0];
        if (!(this._children[1] instanceof CString)) {
            throw new IllegalStateException("Second child record wasn't a CString, was of type " + this._children[1].getRecordType());
        }
        this.commentRecord = (CString)this._children[1];
        if (!(this._children[2] instanceof CString)) {
            throw new IllegalStateException("Third child record wasn't a CString, was of type " + this._children[2].getRecordType());
        }
        this.authorInitialsRecord = (CString)this._children[2];
        if (!(this._children[3] instanceof Comment2000Atom)) {
            throw new IllegalStateException("Fourth child record wasn't a Comment2000Atom, was of type " + this._children[3].getRecordType());
        }
        this.commentAtom = (Comment2000Atom)this._children[3];
    }

    public Comment2000() {
        this._children = new Record[4];
        this._header[0] = 15;
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)_type));
        CString csa = new CString();
        CString csb = new CString();
        CString csc = new CString();
        csa.setCount(0);
        csb.setCount(16);
        csc.setCount(32);
        this._children[0] = csa;
        this._children[1] = csb;
        this._children[2] = csc;
        this._children[3] = new Comment2000Atom();
        this.findInterestingChildren();
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

