/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RedoLog {
    private static final Logger log = LoggerFactory.getLogger(RedoLog.class);
    private static final String REDO_LOG = "redo.log";
    private final ActionCollector ENTRY_COUNTER = new ActionCollector(){

        public void collect(MultiIndex.Action a) {
            RedoLog.this.entryCount++;
        }
    };
    private final Directory dir;
    private int entryCount = 0;
    private Writer out;

    RedoLog(Directory dir) throws IOException {
        this.dir = dir;
        this.read(this.ENTRY_COUNTER);
    }

    boolean hasEntries() {
        return this.entryCount > 0;
    }

    int getSize() {
        return this.entryCount;
    }

    List getActions() throws IOException {
        final ArrayList actions = new ArrayList();
        this.read(new ActionCollector(){

            public void collect(MultiIndex.Action a) {
                actions.add(a);
            }
        });
        return actions;
    }

    void append(MultiIndex.Action action) throws IOException {
        this.initOut();
        this.out.write(action.toString() + "\n");
        ++this.entryCount;
    }

    void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    void clear() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        this.dir.deleteFile(REDO_LOG);
        this.entryCount = 0;
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            IndexOutputStream os = new IndexOutputStream(this.dir.createOutput(REDO_LOG));
            this.out = new BufferedWriter(new OutputStreamWriter(os));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(ActionCollector collector) throws IOException {
        if (!this.dir.fileExists(REDO_LOG)) {
            return;
        }
        IndexInputStream in = new IndexInputStream(this.dir.openInput(REDO_LOG));
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                try {
                    collector.collect(MultiIndex.Action.fromString(line));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Malformed redo entry: " + e.getMessage());
                }
            }
            Object var7_6 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Exception while closing redo log: " + e.toString());
            }
            throw throwable;
        }
        try {
            ((InputStream)in).close();
            return;
        }
        catch (IOException e) {
            log.warn("Exception while closing redo log: " + e.toString());
        }
    }

    static interface ActionCollector {
        public void collect(MultiIndex.Action var1);
    }
}

