/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.sql.Types;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCMappingMetaData {
    private static Logger log = Logger.getLogger((String)JDBCMappingMetaData.class.getName());
    private final String javaType;
    private final int jdbcType;
    private final String sqlType;
    private final String paramSetter;
    private final String resultReader;

    public static int getJdbcTypeFromName(String name) throws DeploymentException {
        if (name == null) {
            throw new DeploymentException("jdbc-type cannot be null");
        }
        try {
            Integer constant = (Integer)Types.class.getField(name).get(null);
            return constant;
        }
        catch (Exception e) {
            log.warn((Object)("Unrecognized jdbc-type: " + name + ", using Types.OTHER"), (Throwable)e);
            return 1111;
        }
    }

    public JDBCMappingMetaData(Element element) throws DeploymentException {
        this.javaType = MetaData.getUniqueChildContent((Element)element, (String)"java-type");
        this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(MetaData.getUniqueChildContent((Element)element, (String)"jdbc-type"));
        this.sqlType = MetaData.getUniqueChildContent((Element)element, (String)"sql-type");
        this.paramSetter = MetaData.getOptionalChildContent((Element)element, (String)"param-setter");
        this.resultReader = MetaData.getOptionalChildContent((Element)element, (String)"result-reader");
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getParamSetter() {
        return this.paramSetter;
    }

    public String getResultReader() {
        return this.resultReader;
    }
}

