/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jgroups.Message;
import org.jgroups.stack.AckReceiverWindow;

public class AckReceiverWindowTest
extends TestCase {
    AckReceiverWindow win;

    public AckReceiverWindowTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.win = new AckReceiverWindow(1L);
    }

    public void tearDown() throws Exception {
        this.win.reset();
        super.tearDown();
    }

    public void testAdd() {
        this.win.reset();
        this.win = new AckReceiverWindow(10L);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        this.win.add(9L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        this.win.add(10L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(13L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)2, (int)this.win.size());
        Message msg = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)msg);
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        msg = this.win.remove();
        AckReceiverWindowTest.assertNull((Object)msg);
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(11L, AckReceiverWindowTest.msg());
        this.win.add(12L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)3, (int)this.win.size());
        msg = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)msg);
        msg = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)msg);
        msg = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)msg);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        msg = this.win.remove();
        AckReceiverWindowTest.assertNull((Object)msg);
    }

    public void testAddExisting() {
        this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(2L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)2, (int)this.win.size());
    }

    public void testAddLowerThanNextToRemove() {
        this.win.add(1L, AckReceiverWindowTest.msg());
        this.win.add(2L, AckReceiverWindowTest.msg());
        this.win.remove();
        this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
    }

    public void testRemove() {
        this.win.add(2L, AckReceiverWindowTest.msg());
        Message msg = this.win.remove();
        AckReceiverWindowTest.assertNull((Object)msg);
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)2, (int)this.win.size());
        AckReceiverWindowTest.assertNotNull((Object)this.win.remove());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        AckReceiverWindowTest.assertNotNull((Object)this.win.remove());
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        AckReceiverWindowTest.assertNull((Object)this.win.remove());
    }

    public void testRemoveOOBMessage() {
        this.win.add(2L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
        AckReceiverWindowTest.assertNull((Object)this.win.remove());
        this.win.add(1L, AckReceiverWindowTest.msg(true));
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNotNull((Object)this.win.removeOOBMessage());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
        AckReceiverWindowTest.assertNotNull((Object)this.win.remove());
        AckReceiverWindowTest.assertNull((Object)this.win.remove());
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
    }

    public void testDuplicates() {
        this.win = new AckReceiverWindow(2L);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        boolean rc = this.win.add(9L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(2L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(2L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(0L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(3L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(4L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(4L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
    }

    public void testMessageReadyForRemoval() {
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(2L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(3L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(1L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
    }

    private static Message msg() {
        return AckReceiverWindowTest.msg(false);
    }

    private static Message msg(boolean oob) {
        Message retval = new Message();
        if (oob) {
            retval.setFlag((byte)1);
        }
        return retval;
    }

    public static Test suite() {
        return new TestSuite(AckReceiverWindowTest.class);
    }
}

