/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.ScopeType;
import javax.event.Observes;
import javax.inject.CreationException;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.Production;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected AnnotatedClass<T> annotatedItem;
    private Set<FieldInjectionPoint<?>> injectableFields;
    private Set<MethodInjectionPoint<?>> initializerMethods;
    private Set<String> dependencies;
    private final String id;

    protected AbstractClassBean(AnnotatedClass<T> type, ManagerImpl manager) {
        super(manager);
        this.annotatedItem = type;
        this.id = AbstractClassBean.createId(((Object)((Object)this)).getClass().getSimpleName() + "-" + type.getName());
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkScopeAllowed();
        this.checkBeanImplementation();
        this.initInitializerMethods();
    }

    protected void injectBoundFields(T instance, CreationalContext<T> creationalContext) {
        for (FieldInjectionPoint<T> fieldInjectionPoint : this.injectableFields) {
            fieldInjectionPoint.inject(instance, this.manager, creationalContext);
        }
    }

    protected void callInitializers(T instance, CreationalContext<T> creationalContext) {
        for (MethodInjectionPoint<T> methodInjectionPoint : this.getInitializerMethods()) {
            methodInjectionPoint.invoke(instance, this.manager, creationalContext, CreationException.class);
        }
    }

    protected void initType() {
        log.trace((Object)"Bean type specified in Java");
        this.type = this.getAnnotatedItem().getRawType();
        this.dependencies = new HashSet<String>();
        for (Class clazz = this.type.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.dependencies.add(clazz.getName());
        }
    }

    protected void initInjectionPoints() {
        this.injectableFields = new HashSet(Beans.getFieldInjectionPoints(this.annotatedItem, this));
        this.injectionPoints.addAll(this.injectableFields);
        for (MethodInjectionPoint<?> initializer : this.getInitializerMethods()) {
            for (AnnotatedParameter<?> parameter : initializer.getParameters()) {
                this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
            }
        }
    }

    protected void initInitializerMethods() {
        this.initializerMethods = new HashSet();
        for (AnnotatedMethod<?> method : this.annotatedItem.getAnnotatedMethods(Initializer.class)) {
            if (method.isStatic()) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be static on " + this.getAnnotatedItem());
            }
            if (method.getAnnotation(Produces.class) != null) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Produces on " + this.getAnnotatedItem());
            }
            if (method.getAnnotatedParameters(Disposes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot have parameters annotated @Disposes on " + this.getAnnotatedItem());
            }
            if (method.getAnnotatedParameters(Observes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Observes on " + this.getAnnotatedItem());
            }
            this.initializerMethods.add(MethodInjectionPoint.of(this, method));
        }
    }

    @Override
    protected void initScopeType() {
        for (AnnotatedClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(scopeTypes.iterator().next().annotationType())) break;
                this.scopeType = scopeTypes.iterator().next().annotationType();
                log.trace((Object)("Scope " + this.scopeType + " specified by annotation"));
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified on " + this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace((Object)"Using default @Dependent scope");
        }
    }

    @Override
    protected void initDeploymentType() {
        for (AnnotatedClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> deploymentTypes = clazz.getDeclaredMetaAnnotations(DeploymentType.class);
            if (deploymentTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(deploymentTypes.iterator().next().annotationType())) break;
                this.deploymentType = deploymentTypes.iterator().next().annotationType();
                log.trace((Object)("Deployment type " + this.deploymentType + " specified by annotation"));
                break;
            }
            if (deploymentTypes.size() <= 1) continue;
            throw new DefinitionException("At most one deployment type may be specified");
        }
        if (this.deploymentType == null) {
            this.initDeploymentTypeFromStereotype();
        }
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace((Object)"Using default @Production deployment type");
            return;
        }
    }

    protected void checkScopeAllowed() {
        log.trace((Object)("Checking if " + this.getScopeType() + " is allowed for " + this.type));
        if (this.getMergedStereotypes().getSupportedScopes().size() > 0 && !this.getMergedStereotypes().getSupportedScopes().contains(this.getScopeType())) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not an allowed by the stereotype for " + this.type);
        }
    }

    protected void checkBeanImplementation() {
        if (Reflections.isAbstract(this.getType())) {
            throw new DefinitionException("Web Bean implementation class " + this.type + " cannot be declared abstract");
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getSuperclass() == null || this.getAnnotatedItem().getSuperclass().getRawType().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean " + this.toString());
        }
    }

    public AnnotatedClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        log.trace((Object)("Default name of " + this.type + " is " + name));
        return name;
    }

    public Set<? extends MethodInjectionPoint<?>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public Set<String> getSuperclasses() {
        return this.dependencies;
    }

    @Override
    public String toString() {
        return "AbstractClassBean " + this.getName();
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return Production.class;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

