/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Named;
import javax.context.ScopeType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentException;
import javax.inject.DeploymentType;
import javax.interceptor.InterceptorBindingType;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.ext.NotSimpleBeanChildrenChecker;
import org.jboss.webbeans.xml.checker.beanchildren.ext.ResourceBeanChildrenChecker;
import org.jboss.webbeans.xml.checker.beanchildren.ext.SimpleBeanChildrenChecker;
import org.jboss.webbeans.xml.registrator.bean.BeanElementRegistrator;
import org.jboss.webbeans.xml.registrator.bean.ext.JmsResourceElementRegistrator;
import org.jboss.webbeans.xml.registrator.bean.ext.ResourceElementRegistrator;
import org.jboss.webbeans.xml.registrator.bean.ext.SessionBeanElementRegistrator;
import org.jboss.webbeans.xml.registrator.bean.ext.SimpleBeanElementRegistrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParser {
    private static Log log = Logging.getLog(XmlParser.class);
    private final XmlEnvironment environment;
    private List<BeanElementRegistrator> beanElementRegistrators = new ArrayList<BeanElementRegistrator>();
    private boolean haveAnyDeployElement = false;
    private Map<String, Set<String>> packagesMap = new HashMap<String, Set<String>>();

    public XmlParser(XmlEnvironment environment) {
        this.environment = environment;
    }

    public void parse() {
        for (URL url : this.environment.getBeansXmlUrls()) {
            Document document = this.createDocument(url);
            if (document == null) continue;
            this.parseForArrays(document);
            this.parseForAnnotationTypes(document);
            this.parseForDeploy(document);
            this.parseForBeans(document);
        }
    }

    private void parseForArrays(Document document) {
        Element root = document.getRootElement();
        this.checkChildrenForArray(root);
    }

    private void checkChildrenForArray(Element element) {
        Iterator childIterator = element.elementIterator();
        while (childIterator.hasNext()) {
            Element child = (Element)childIterator.next();
            if (child.getName().equalsIgnoreCase("Array")) {
                boolean haveNotAnnotation = false;
                Iterator arrayIterator = child.elementIterator();
                while (arrayIterator.hasNext()) {
                    Element arrayChild = (Element)arrayIterator.next();
                    AnnotatedClass<Object> arrayChildType = ParseXmlHelper.loadElementClass(arrayChild, Object.class, this.environment, this.packagesMap);
                    boolean isAnnotation = arrayChildType.getRawType().isAnnotation();
                    if (isAnnotation) continue;
                    if (haveNotAnnotation) {
                        throw new DefinitionException("<Array> element have second child which is not annotation, it is '" + arrayChild.getName() + "'");
                    }
                    haveNotAnnotation = true;
                }
                if (haveNotAnnotation) continue;
                throw new DefinitionException("<Array> element must have one child elemen which is not annotation");
            }
            this.checkChildrenForArray(child);
        }
    }

    private void parseForAnnotationTypes(Document document) {
        Element root = document.getRootElement();
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Class<? extends Annotation>> interceptorBindingTypes = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Class<? extends Annotation>> stereotypes = new ArrayList<Class<? extends Annotation>>();
        Iterator elIterator = root.elementIterator();
        while (elIterator.hasNext()) {
            boolean isStereotype;
            Element element = (Element)elIterator.next();
            boolean isBindingType = ParseXmlHelper.findElementsInEeNamespace(element, "BindingType").size() > 0;
            boolean isInterceptorBindingType = ParseXmlHelper.findElementsInEeNamespace(element, "InterceptorBindingType").size() > 0;
            boolean bl = isStereotype = ParseXmlHelper.findElementsInEeNamespace(element, "Stereotype").size() > 0;
            if (!isBindingType && !isInterceptorBindingType && !isStereotype) continue;
            Class<Annotation> annotationType = ParseXmlHelper.loadAnnotationClass(element, Annotation.class, this.environment, this.packagesMap);
            if (isBindingType) {
                bindingTypes.add(annotationType);
            }
            if (isInterceptorBindingType) {
                interceptorBindingTypes.add(annotationType);
                this.checkForInterceptorBindingTypeChildren(element);
            }
            if (!isStereotype) continue;
            stereotypes.add(annotationType);
            this.checkForStereotypeChildren(element);
        }
        ParseXmlHelper.checkForUniqueElements(bindingTypes);
        ParseXmlHelper.checkForUniqueElements(interceptorBindingTypes);
        ParseXmlHelper.checkForUniqueElements(stereotypes);
    }

    private void parseForBeans(Document document) {
        List<Element> beanElements = this.findBeans(document);
        for (Element beanElement : beanElements) {
            AnnotatedClass<Object> beanClass = ParseXmlHelper.loadElementClass(beanElement, Object.class, this.environment, this.packagesMap);
            this.checkBeanElement(beanElement, beanClass);
        }
    }

    private void parseForDeploy(Document document) {
        Element root = document.getRootElement();
        Iterator elIterator = root.elementIterator();
        while (elIterator.hasNext()) {
            Element element = (Element)elIterator.next();
            if (!ParseXmlHelper.isJavaEeNamespace(element) || !element.getName().equalsIgnoreCase("Deploy")) continue;
            this.environment.getEnabledDeploymentTypes().addAll(this.obtainDeploymentTypes(element));
        }
    }

    private Document createDocument(URL url) {
        try {
            InputStream xmlStream = url.openStream();
            if (xmlStream.available() == 0) {
                return null;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(xmlStream);
            this.fullFillPackagesMap(document, url);
            return document;
        }
        catch (IOException e) {
            String message = "Can not open stream for " + url;
            log.debug((Object)message, (Throwable)e, new Object[0]);
            throw new DefinitionException(message, (Throwable)e);
        }
        catch (DocumentException e) {
            String message = "Error during the processing of a DOM4J document for " + url;
            log.debug((Object)message, (Throwable)e, new Object[0]);
            throw new DefinitionException(message, (Throwable)e);
        }
    }

    private void checkForInterceptorBindingTypeChildren(Element element) {
        Iterator elIterator = element.elementIterator();
        while (elIterator.hasNext()) {
            Element child = (Element)elIterator.next();
            Class<Annotation> clazz = ParseXmlHelper.loadAnnotationClass(child, Annotation.class, this.environment, this.packagesMap);
            if (child.getName().equalsIgnoreCase("InterceptorBindingType") || clazz.isAnnotationPresent(InterceptorBindingType.class)) continue;
            throw new DefinitionException("Direct child <" + child.getName() + "> of interceptor binding type <" + element.getName() + "> declaration must be interceptor binding type");
        }
    }

    private void checkForStereotypeChildren(Element stereotypeElement) {
        Iterator elIterator = stereotypeElement.elementIterator();
        while (elIterator.hasNext()) {
            Element stereotypeChild = (Element)elIterator.next();
            Class<Annotation> stereotypeClass = ParseXmlHelper.loadAnnotationClass(stereotypeChild, Annotation.class, this.environment, this.packagesMap);
            if (stereotypeChild.getName().equalsIgnoreCase("Stereotype") || stereotypeClass.isAnnotationPresent(ScopeType.class) || stereotypeClass.isAnnotationPresent(DeploymentType.class) || stereotypeClass.isAnnotationPresent(InterceptorBindingType.class) || stereotypeClass.isAnnotationPresent(Named.class)) continue;
            throw new DefinitionException("Direct child <" + stereotypeChild.getName() + "> of stereotype <" + stereotypeElement.getName() + "> declaration must be scope type, or deployment type, or interceptor binding type, or javax.annotation.Named");
        }
    }

    private List<Element> findBeans(Document document) {
        ArrayList<Element> beans = new ArrayList<Element>();
        Element root = document.getRootElement();
        Iterator elIterator = root.elementIterator();
        while (elIterator.hasNext()) {
            Element element = (Element)elIterator.next();
            if (!this.checkBeanElementName(element) || !this.checkBeanElementChildrenNames(element)) continue;
            beans.add(element);
        }
        return beans;
    }

    private boolean checkBeanElementName(Element element) {
        return !ParseXmlHelper.isJavaEeNamespace(element) || !element.getName().equalsIgnoreCase("Deploy") && !element.getName().equalsIgnoreCase("Interceptors") && !element.getName().equalsIgnoreCase("Decorators");
    }

    private boolean checkBeanElementChildrenNames(Element element) {
        Iterator elIterator = element.elementIterator();
        while (elIterator.hasNext()) {
            Element child = (Element)elIterator.next();
            if (!ParseXmlHelper.isJavaEeNamespace(child) || !child.getName().equalsIgnoreCase("BindingType") && !child.getName().equalsIgnoreCase("InterceptorBindingType") && !child.getName().equalsIgnoreCase("Stereotype")) continue;
            return false;
        }
        return true;
    }

    private List<Class<? extends Annotation>> obtainDeploymentTypes(Element element) {
        if (this.haveAnyDeployElement) {
            throw new DefinitionException("<Deploy> element is specified more than once");
        }
        List<Element> standardElements = ParseXmlHelper.findElementsInEeNamespace(element, "Standard");
        if (standardElements.size() == 0) {
            throw new DeploymentException("The @Standard deployment type must be declared");
        }
        ArrayList<Class<? extends Annotation>> deploymentClasses = new ArrayList<Class<? extends Annotation>>();
        Iterator deployIterator = element.elementIterator();
        while (deployIterator.hasNext()) {
            String elementUri;
            String elementPrefix;
            Element deploymentElement = (Element)deployIterator.next();
            String elementName = deploymentElement.getName();
            List<Element> deploymentElements = ParseXmlHelper.findElements(element, elementName, elementPrefix = deploymentElement.getNamespacePrefix(), elementUri = deploymentElement.getNamespaceURI());
            if (deploymentElements.size() != 1) {
                throw new DefinitionException("The same deployment type '" + deploymentElement.getName() + "' is declared more than once");
            }
            Class<Annotation> deploymentClass = ParseXmlHelper.loadAnnotationClass(deploymentElement, Annotation.class, this.environment, this.packagesMap);
            if (!deploymentClass.isAnnotationPresent(DeploymentType.class)) {
                throw new DefinitionException("<Deploy> child '" + deploymentElement.getName() + "' must be a deployment type");
            }
            deploymentClasses.add(deploymentClass);
        }
        this.haveAnyDeployElement = true;
        return deploymentClasses;
    }

    private void checkBeanElement(Element beanElement, AnnotatedClass<?> beanClass) {
        this.beanElementRegistrators.add(new JmsResourceElementRegistrator(new NotSimpleBeanChildrenChecker(this.environment, this.packagesMap)));
        this.beanElementRegistrators.add(new ResourceElementRegistrator(new ResourceBeanChildrenChecker(this.environment, this.packagesMap)));
        this.beanElementRegistrators.add(new SessionBeanElementRegistrator(new NotSimpleBeanChildrenChecker(this.environment, this.packagesMap), this.environment.getEjbDescriptors()));
        this.beanElementRegistrators.add(new SimpleBeanElementRegistrator(new SimpleBeanChildrenChecker(this.environment, this.packagesMap), this.environment.getEjbDescriptors()));
        boolean isValidType = false;
        for (BeanElementRegistrator beanElementRegistrator : this.beanElementRegistrators) {
            if (!beanElementRegistrator.accept(beanElement, beanClass)) continue;
            beanElementRegistrator.registerBeanElement(beanElement, beanClass);
            isValidType = true;
            break;
        }
        if (!isValidType) {
            throw new DefinitionException("Can't determine type of bean element <" + beanElement.getName() + ">");
        }
    }

    private void fullFillPackagesMap(Document document, URL xmlUrl) {
        Element root = document.getRootElement();
        ParseXmlHelper.checkRootAttributes(root, this.packagesMap, this.environment, xmlUrl);
        ParseXmlHelper.checkRootDeclaredNamespaces(root, this.packagesMap, this.environment, xmlUrl);
    }
}

