/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.error;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.AccountLimitExceededException;
import org.apache.juddi.error.AssertionNotFoundException;
import org.apache.juddi.error.AuthTokenExpiredException;
import org.apache.juddi.error.AuthTokenRequiredException;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.CategorizationNotAllowedException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.InvalidCategoryException;
import org.apache.juddi.error.InvalidCompletionStatusException;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.InvalidProjectionException;
import org.apache.juddi.error.InvalidTimeException;
import org.apache.juddi.error.InvalidURLPassedException;
import org.apache.juddi.error.InvalidValueException;
import org.apache.juddi.error.KeyRetiredException;
import org.apache.juddi.error.LanguageErrorException;
import org.apache.juddi.error.MessageTooLargeException;
import org.apache.juddi.error.NameTooLongException;
import org.apache.juddi.error.OperatorMismatchException;
import org.apache.juddi.error.PublisherCancelledException;
import org.apache.juddi.error.RequestDeniedException;
import org.apache.juddi.error.RequestTimeoutException;
import org.apache.juddi.error.ResultSetTooLargeException;
import org.apache.juddi.error.SecretUnknownException;
import org.apache.juddi.error.TooManyOptionsException;
import org.apache.juddi.error.TransferAbortedException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.error.UnrecognizedVersionException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.error.UnvalidatableException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.error.ValueNotAllowedException;

public class RegistryException
extends Exception
implements RegistryObject {
    private String faultActor;
    private String faultCode;
    private String faultString;
    private DispositionReport dispReport;

    public RegistryException(String msg) {
        super(msg);
        this.setFaultCode(null);
        this.setFaultString(msg);
        this.setFaultActor(null);
    }

    public RegistryException(Exception ex) {
        super(ex);
        if (ex != null) {
            if (ex instanceof RegistryException) {
                RegistryException regex = (RegistryException)ex;
                this.setFaultCode(regex.getFaultCode());
                this.setFaultString(regex.getFaultString());
                this.setFaultActor(regex.getFaultActor());
                this.setDispositionReport(regex.getDispositionReport());
            } else {
                this.setFaultString(ex.getMessage());
            }
        }
    }

    public RegistryException(String fCode, String fString, String fActor, DispositionReport dispRpt) {
        super(fString);
        this.setFaultCode(fCode);
        this.setFaultString(fString);
        this.setFaultActor(fActor);
        this.setDispositionReport(dispRpt);
    }

    RegistryException(String fCode, int errno, String msg) {
        super(RegistryException.buildMessage(errno, msg));
        String errCode = Result.lookupErrCode(errno);
        this.setFaultCode(fCode);
        this.setFaultString(this.getMessage());
        this.addResult(new Result(errno, errCode, this.getMessage()));
    }

    public void setFaultActor(String actor) {
        this.faultActor = actor;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultCode(String code) {
        this.faultCode = code;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String value) {
        this.faultString = value;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setDispositionReport(DispositionReport dispRpt) {
        this.dispReport = dispRpt;
    }

    public DispositionReport getDispositionReport() {
        return this.dispReport;
    }

    public void addResult(Result result) {
        if (this.dispReport == null) {
            this.dispReport = new DispositionReport();
        }
        this.dispReport.addResult(result);
    }

    public String toString() {
        String msg = this.getMessage();
        if (msg == null) {
            return "";
        }
        return this.getMessage();
    }

    private static final String buildMessage(int errno, String msg) {
        StringBuffer buffer = new StringBuffer();
        String errCode = Result.lookupErrCode(errno);
        if (errCode != null) {
            buffer.append(errCode);
            buffer.append(" ");
        }
        buffer.append("(");
        buffer.append(errno);
        buffer.append(") ");
        String errText = Result.lookupErrText(errno);
        if (errText != null) {
            buffer.append(errText);
            buffer.append(" ");
        }
        if (msg != null && msg.trim().length() > 0) {
            buffer.append(msg);
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws RegistryException {
        System.out.println(new AccountLimitExceededException("Additional error information."));
        System.out.println(new AssertionNotFoundException("Additional error information."));
        System.out.println(new AuthTokenExpiredException("Additional error information."));
        System.out.println(new AuthTokenRequiredException("Additional error information."));
        System.out.println(new BusyException("Additional error information."));
        System.out.println(new CategorizationNotAllowedException("Additional error information."));
        System.out.println(new FatalErrorException("Additional error information."));
        System.out.println(new InvalidCategoryException("Additional error information."));
        System.out.println(new InvalidCompletionStatusException("Additional error information."));
        System.out.println(new InvalidKeyPassedException("Additional error information."));
        System.out.println(new InvalidProjectionException("Additional error information."));
        System.out.println(new InvalidTimeException("Additional error information."));
        System.out.println(new InvalidURLPassedException("Additional error information."));
        System.out.println(new InvalidValueException("Additional error information."));
        System.out.println(new KeyRetiredException("Additional error information."));
        System.out.println(new LanguageErrorException("Additional error information."));
        System.out.println(new MessageTooLargeException("Additional error information."));
        System.out.println(new NameTooLongException("Additional error information."));
        System.out.println(new OperatorMismatchException("Additional error information."));
        System.out.println(new PublisherCancelledException("Additional error information."));
        System.out.println(new RequestDeniedException("Additional error information."));
        System.out.println(new RequestTimeoutException("Additional error information."));
        System.out.println(new ResultSetTooLargeException("Additional error information."));
        System.out.println(new SecretUnknownException("Additional error information."));
        System.out.println(new TooManyOptionsException("Additional error information."));
        System.out.println(new TransferAbortedException("Additional error information."));
        System.out.println(new UnknownUserException("Additional error information."));
        System.out.println(new UnknownUserException("Additional error information."));
        System.out.println(new UnrecognizedVersionException("Additional error information."));
        System.out.println(new UnsupportedException("Additional error information."));
        System.out.println(new UnvalidatableException("Additional error information."));
        System.out.println(new UserMismatchException("Additional error information."));
        System.out.println(new ValueNotAllowedException("Additional error information."));
        System.out.println("\n----- RegistryException(String) -----");
        System.out.println(new RegistryException((String)null));
        System.out.println(new RegistryException("Additional error information."));
        System.out.println("\n----- RegistryException(Exception) -----");
        System.out.println(new RegistryException((Exception)null));
        System.out.println(new RegistryException(new Exception("Additional error information.")));
        System.out.println(new RegistryException(new RegistryException("Additional error information.")));
        System.out.println(new RegistryException(new UnknownUserException("Additional error information.")));
        System.out.println("\n----- RegistryException(FaultCode,errno,String) -----");
        System.out.println(new RegistryException(null, -1, null));
        System.out.println(new RegistryException("Server", -1, null));
        System.out.println(new RegistryException("Server", 10400, null));
        System.out.println(new RegistryException("Server", 10400, "Additional error information."));
    }
}

