/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.notification;

import java.util.HashMap;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.mx.notification.ListenerRegistration;
import org.jboss.mx.notification.ListenerRegistrationFactory;
import org.jboss.mx.notification.ListenerRegistry;
import org.jboss.mx.notification.MBeanServerListenerRegistrationFactory;

public class MBeanServerListenerRegistry {
    private HashMap registries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ObjectName name, NotificationBroadcaster broadcaster, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        ListenerRegistry registry = null;
        HashMap hashMap = this.registries;
        synchronized (hashMap) {
            registry = (ListenerRegistry)this.registries.get(name);
            if (registry == null) {
                registry = new ListenerRegistry((ListenerRegistrationFactory)new MBeanServerListenerRegistrationFactory(name, broadcaster));
            }
            this.registries.put(name, registry);
        }
        try {
            registry.add(listener, filter, handback);
        }
        catch (JMException e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjectName name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ListenerRegistry registry = null;
        HashMap hashMap = this.registries;
        synchronized (hashMap) {
            registry = (ListenerRegistry)this.registries.remove(name);
            if (registry == null) {
                return;
            }
        }
        ListenerRegistry.ListenerRegistrationIterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            ListenerRegistration registration = iterator.nextRegistration();
            registration.removed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjectName name, NotificationListener listener) throws ListenerNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashMap hashMap = this.registries;
        synchronized (hashMap) {
            ListenerRegistry registry = (ListenerRegistry)this.registries.get(name);
            if (registry == null) {
                throw new ListenerNotFoundException("Listener not found " + listener + " for object name " + name);
            }
            registry.remove(listener);
            if (registry.isEmpty()) {
                this.registries.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashMap hashMap = this.registries;
        synchronized (hashMap) {
            ListenerRegistry registry = (ListenerRegistry)this.registries.get(name);
            if (registry == null) {
                throw new ListenerNotFoundException("Listener not found listener=" + listener + " filter=" + filter + " handback=" + handback + " for object name " + name);
            }
            registry.remove(listener, filter, handback);
            if (registry.isEmpty()) {
                this.registries.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        HashMap hashMap = this.registries;
        synchronized (hashMap) {
            Iterator it = this.registries.keySet().iterator();
            while (it.hasNext()) {
                ListenerRegistry registry = (ListenerRegistry)this.registries.get(it.next());
                registry.removeAll();
            }
        }
    }
}

