/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.ChannelContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.DownloadMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="ContentSource.findAll", query="SELECT cs FROM ContentSource cs "), @NamedQuery(name="ContentSource.findAllWithConfig", query="SELECT cs FROM ContentSource cs LEFT JOIN FETCH cs.configuration"), @NamedQuery(name="ContentSource.findByNameAndTypeName", query="SELECT cs   FROM ContentSource cs        LEFT JOIN FETCH cs.configuration WHERE cs.name = :name    AND cs.contentSourceType.name = :typeName "), @NamedQuery(name="ContentSource.findByIdWithConfig", query="SELECT cs   FROM ContentSource cs        LEFT JOIN FETCH cs.configuration WHERE cs.id = :id "), @NamedQuery(name="ContentSource.findByChannelId", query="SELECT cs FROM ContentSource cs LEFT JOIN cs.channelContentSources ccs WHERE ccs.channel.id = :id"), @NamedQuery(name="ContentSource.findAvailableByChannelId", query="SELECT cs     FROM ContentSource AS cs    WHERE cs.id NOT IN        ( SELECT ccs.contentSource.id            FROM ChannelContentSource ccs           WHERE ccs.channel.id = :channelId ) ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONTENT_SOURCE_ID_SEQ")
@Table(name="RHQ_CONTENT_SOURCE")
public class ContentSource
implements Serializable {
    public static final String QUERY_FIND_ALL = "ContentSource.findAll";
    public static final String QUERY_FIND_ALL_WITH_CONFIG = "ContentSource.findAllWithConfig";
    public static final String QUERY_FIND_BY_NAME_AND_TYPENAME = "ContentSource.findByNameAndTypeName";
    public static final String QUERY_FIND_BY_ID_WITH_CONFIG = "ContentSource.findByIdWithConfig";
    public static final String QUERY_FIND_BY_CHANNEL_ID = "ContentSource.findByChannelId";
    public static final String QUERY_FIND_AVAILABLE_BY_CHANNEL_ID = "ContentSource.findAvailableByChannelId";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="CONTENT_SOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private ContentSourceType contentSourceType;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="LAZY_LOAD", nullable=false)
    private boolean lazyLoad;
    @Column(name="DOWNLOAD_MODE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DownloadMode downloadMode = DownloadMode.DATABASE;
    @Column(name="SYNC_SCHEDULE", nullable=true)
    private String syncSchedule = "0 0 3 * * ?";
    @Column(name="LOAD_ERROR_MESSAGE", nullable=true)
    private String loadErrorMessage;
    @JoinColumn(name="CONFIGURATION_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration configuration;
    @Column(name="CREATION_TIME", nullable=false)
    private long creationDate;
    @Column(name="LAST_MODIFIED_TIME", nullable=false)
    private long lastModifiedDate;
    @OneToMany(mappedBy="contentSource", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @OrderBy(value="startTime DESC")
    private List<ContentSourceSyncResults> syncResults;
    @OneToMany(mappedBy="contentSource", fetch=FetchType.LAZY)
    private Set<ChannelContentSource> channelContentSources;

    public ContentSource() {
    }

    public ContentSource(String name, ContentSourceType contentSourceType) {
        this.name = name;
        this.contentSourceType = contentSourceType;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ContentSourceType getContentSourceType() {
        return this.contentSourceType;
    }

    public void setContentSourceType(ContentSourceType contentSourceType) {
        this.contentSourceType = contentSourceType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public DownloadMode getDownloadMode() {
        return this.downloadMode;
    }

    public void setDownloadMode(DownloadMode downloadMode) {
        this.downloadMode = downloadMode;
    }

    public String getSyncSchedule() {
        return this.syncSchedule;
    }

    public void setSyncSchedule(String syncSchedule) {
        if (syncSchedule != null && syncSchedule.trim().length() == 0) {
            syncSchedule = null;
        }
        this.syncSchedule = syncSchedule;
    }

    public String getLoadErrorMessage() {
        return this.loadErrorMessage;
    }

    public void setLoadErrorMessage(String loadErrorMessage) {
        this.loadErrorMessage = loadErrorMessage;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public List<ContentSourceSyncResults> getSyncResults() {
        return this.syncResults;
    }

    public void addSyncResult(ContentSourceSyncResults syncResult) {
        if (this.syncResults == null) {
            this.syncResults = new ArrayList<ContentSourceSyncResults>();
        }
        this.syncResults.add(syncResult);
        syncResult.setContentSource(this);
    }

    public void setSyncResults(List<ContentSourceSyncResults> syncResults) {
        this.syncResults = syncResults;
    }

    public Set<ChannelContentSource> getChannelContentSources() {
        return this.channelContentSources;
    }

    public Set<Channel> getChannels() {
        HashSet<Channel> channels = new HashSet<Channel>();
        if (this.channelContentSources != null) {
            for (ChannelContentSource ccs : this.channelContentSources) {
                channels.add(ccs.getChannelContentSourcePK().getChannel());
            }
        }
        return channels;
    }

    public ChannelContentSource addChannel(Channel channel) {
        if (this.channelContentSources == null) {
            this.channelContentSources = new HashSet<ChannelContentSource>();
        }
        ChannelContentSource mapping = new ChannelContentSource(channel, this);
        this.channelContentSources.add(mapping);
        channel.addContentSource(this);
        return mapping;
    }

    public ChannelContentSource removeChannel(Channel channel) {
        if (this.channelContentSources == null || channel == null) {
            return null;
        }
        ChannelContentSource doomed = null;
        for (ChannelContentSource ccs : this.channelContentSources) {
            if (!channel.equals(ccs.getChannelContentSourcePK().getChannel())) continue;
            doomed = ccs;
            channel.removeContentSource(this);
            break;
        }
        if (doomed != null) {
            this.channelContentSources.remove(doomed);
        }
        return doomed;
    }

    @PrePersist
    void onPersist() {
        this.lastModifiedDate = this.creationDate = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public String toString() {
        return "ContentSource: id=[" + this.id + "], name=[" + this.name + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contentSourceType == null ? 0 : this.contentSourceType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ContentSource)) {
            return false;
        }
        ContentSource other = (ContentSource)obj;
        if (this.contentSourceType == null ? other.contentSourceType != null : !this.contentSourceType.equals(other.contentSourceType)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

