/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.signature.OAuthSignatureMethod;

public class SimpleOAuthValidator
implements OAuthValidator {
    public static final long DEFAULT_TIMESTAMP_WINDOW = 300000L;
    protected final double minVersion = 1.0;
    protected final double maxVersion;
    protected final long timestampWindow;

    public SimpleOAuthValidator() {
        this(300000L, Double.parseDouble("1.0"));
    }

    public SimpleOAuthValidator(long timestampWindowMsec, double maxVersion) {
        this.timestampWindow = timestampWindowMsec;
        this.maxVersion = maxVersion;
    }

    public void validateMessage(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        this.validateVersion(message);
        this.validateTimestampAndNonce(message);
        this.validateSignature(message, accessor);
    }

    protected void validateVersion(OAuthMessage message) throws OAuthException, IOException {
        double version;
        String versionString = message.getParameter("oauth_version");
        if (versionString != null && ((version = Double.parseDouble(versionString)) < 1.0 || this.maxVersion < version)) {
            OAuthProblemException problem = new OAuthProblemException("version_rejected");
            problem.setParameter("oauth_acceptable_versions", "1.0-" + this.maxVersion);
            throw problem;
        }
    }

    protected void validateTimestampAndNonce(OAuthMessage message) throws IOException, OAuthProblemException {
        message.requireParameters("oauth_timestamp", "oauth_nonce");
        long timestamp = Long.parseLong(message.getParameter("oauth_timestamp")) * 1000L;
        long now = this.currentTimeMsec();
        long min = now - this.timestampWindow;
        long max = now + this.timestampWindow;
        if (timestamp < min || max < timestamp) {
            OAuthProblemException problem = new OAuthProblemException("timestamp_refused");
            problem.setParameter("oauth_acceptable_timestamps", String.valueOf(min) + "-" + max);
            throw problem;
        }
    }

    protected void validateSignature(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        message.requireParameters("oauth_consumer_key", "oauth_signature_method", "oauth_signature");
        OAuthSignatureMethod.newSigner(message, accessor).validate(message);
    }

    protected long currentTimeMsec() {
        return System.currentTimeMillis();
    }
}

