/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.LifecycleDependencyItem;
import org.jboss.system.microcontainer.ServiceControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDependencyListValueMetaData
extends AbstractMetaDataVisitorNode
implements ServiceValueMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> dependencies;
    private List<ObjectName> objectNames;

    public ServiceDependencyListValueMetaData() {
    }

    public ServiceDependencyListValueMetaData(List<String> dependencies) {
        this.setDependencies(dependencies);
    }

    public List<String> getDependencies() {
        if (this.dependencies == null) {
            ArrayList<String> result = new ArrayList<String>(this.objectNames.size());
            for (ObjectName objectName : this.objectNames) {
                result.add(objectName.getCanonicalName());
            }
            return result;
        }
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException("Null dependencies");
        }
        for (String dependency : dependencies) {
            if (dependency != null) continue;
            throw new IllegalArgumentException("Null dependency in dependencies");
        }
        this.dependencies = dependencies;
        this.objectNames = null;
    }

    public List<ObjectName> getObjectNames() throws MalformedObjectNameException {
        if (this.objectNames == null) {
            ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.dependencies.size());
            for (String dependency : this.dependencies) {
                if (dependency.trim().length() == 0) {
                    throw new MalformedObjectNameException("Missing object name in depends-list");
                }
                ObjectName objectName = new ObjectName(dependency);
                if (objectName.isPattern()) {
                    throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends-list: " + dependency);
                }
                names.add(objectName);
            }
            this.objectNames = names;
            this.dependencies = null;
        }
        return this.objectNames;
    }

    public void setObjectNames(List<ObjectName> objectNames) {
        if (objectNames == null) {
            throw new IllegalArgumentException("Null objectNames");
        }
        for (ObjectName objectName : objectNames) {
            if (objectName != null) continue;
            throw new IllegalArgumentException("Null object name in objectNames");
        }
        this.objectNames = objectNames;
    }

    @Override
    public Object getValue(ServiceValueContext valueContext) throws Exception {
        return this.getObjectNames();
    }

    @Override
    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context = visitor.getControllerContext();
        Object name = context.getName();
        List<String> list = this.dependencies;
        try {
            List<ObjectName> names = this.getObjectNames();
            list = new ArrayList<String>(names.size());
            for (ObjectName objectName : names) {
                list.add(objectName.getCanonicalName());
            }
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        for (String other : list) {
            visitor.addDependency((DependencyItem)new LifecycleDependencyItem(name, other, ControllerState.CREATE));
            visitor.addDependency((DependencyItem)new LifecycleDependencyItem(name, other, ControllerState.START));
        }
        visitor.visit(this);
    }
}

