/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy.deployer.util;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.PrimitiveAssertion;

public class PrimitiveAssertionWriter {
    private int num = 1;

    PrimitiveAssertionWriter() {
    }

    public static PrimitiveAssertionWriter newInstance() {
        return new PrimitiveAssertionWriter();
    }

    public void writePrimitiveAssertion(PrimitiveAssertion assertion, ByteArrayOutputStream stream) throws XMLStreamException {
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream);
        this.writePrimitiveAssertion(assertion, writer);
    }

    public void writePrimitiveAssertion(PrimitiveAssertion assertion, XMLStreamWriter writer) throws XMLStreamException {
        QName qname = assertion.getName();
        String writerPrefix = writer.getPrefix(qname.getNamespaceURI());
        if (writerPrefix != null) {
            writer.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
        } else {
            String prefix = qname.getPrefix() != null ? qname.getPrefix() : this.generateNamespace();
            writer.writeStartElement(prefix, qname.getLocalPart(), qname.getNamespaceURI());
            writer.writeNamespace(prefix, qname.getNamespaceURI());
            writer.setPrefix(prefix, qname.getNamespaceURI());
        }
        Hashtable attributes = assertion.getAttributes();
        this.writeAttributes(attributes, writer);
        String text = assertion.getStrValue();
        if (text != null) {
            writer.writeCharacters(text);
        }
        List terms = assertion.getTerms();
        this.writeTerms(terms, writer);
        writer.writeEndElement();
        writer.flush();
    }

    private void writeTerms(List terms, XMLStreamWriter writer) throws XMLStreamException {
        for (Assertion assertion : terms) {
            this.writePrimitiveAssertion((PrimitiveAssertion)assertion, writer);
        }
    }

    private void writeAttributes(Hashtable attributes, XMLStreamWriter writer) throws XMLStreamException {
        for (QName qname : attributes.keySet()) {
            String value = (String)attributes.get(qname);
            String prefix = qname.getPrefix();
            if (prefix != null) {
                writer.writeAttribute(prefix, qname.getNamespaceURI(), qname.getLocalPart(), value);
                continue;
            }
            writer.writeAttribute(qname.getNamespaceURI(), qname.getLocalPart(), value);
        }
    }

    private String generateNamespace() {
        return "ns" + this.num++;
    }
}

