/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinuxDistroInfo {
    private static final String DEFAULT_NAME = "UNKNOWN";
    private static final String DEFAULT_VERSION = "UNKNOWN";
    private static final File LSB_RELEASE_FILE = new File("/etc/lsb-release");
    private static final File REDHAT_RELEASE_FILE = new File("/etc/redhat-release");
    private static final File REDHAT_VERSION_FILE = new File("/etc/redhat-version");
    private static final File DEBIAN_VERSION_FILE = new File("/etc/debian_version");
    private static final String DISTRIB_ID_VARIABLE = "DISTRIB_ID";
    private static final String DISTRIB_RELEASE_VARIABLE = "DISTRIB_RELEASE";
    private static final String DISTRIB_CODENAME_VARIABLE = "DISTRIB_CODENAME";
    private static LinuxDistroInfo instance;
    private final Log log = LogFactory.getLog(LinuxDistroInfo.class);
    private String name;
    private String version;

    public static LinuxDistroInfo getInstance() {
        if (instance == null) {
            if (!LinuxDistroInfo.isLinux()) {
                throw new IllegalStateException("Attempt to determine Linux distro information for a non-Linux machine.");
            }
            instance = new LinuxDistroInfo();
        }
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    private LinuxDistroInfo() {
        String codename = null;
        if (REDHAT_RELEASE_FILE.exists() || REDHAT_VERSION_FILE.exists()) {
            int index;
            File releaseFile = REDHAT_RELEASE_FILE.exists() ? REDHAT_RELEASE_FILE : REDHAT_VERSION_FILE;
            String release = this.readSingleLineReleaseFile(releaseFile);
            if (release != null && (index = release.indexOf("release ")) != -1) {
                this.name = release.substring(0, index).trim();
                this.version = release.substring(index);
            }
            if (this.name == null) {
                this.name = "Red Hat Linux";
            }
        } else if (DEBIAN_VERSION_FILE.exists()) {
            String release = this.readSingleLineReleaseFile(DEBIAN_VERSION_FILE);
            this.name = "Debian";
            if (release != null) {
                this.name = this.name + " " + release;
            }
        }
        if (LSB_RELEASE_FILE.exists()) {
            String lsbVersion;
            Properties releaseInfo = this.readMultiVariableReleaseFile(LSB_RELEASE_FILE);
            String lsbName = releaseInfo.getProperty(DISTRIB_ID_VARIABLE);
            if (lsbName != null) {
                this.name = lsbName;
            }
            if ((lsbVersion = releaseInfo.getProperty(DISTRIB_RELEASE_VARIABLE)) != null) {
                this.version = lsbVersion;
            }
            codename = releaseInfo.getProperty(DISTRIB_CODENAME_VARIABLE);
        }
        if (this.name == null) {
            this.name = "UNKNOWN";
        }
        if (this.version == null) {
            this.name = "UNKNOWN";
        }
        if (codename != null) {
            this.version = this.version + " (" + codename + ")";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSingleLineReleaseFile(File releaseFile) {
        String release = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(releaseFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                release = line;
                break;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Failed reading single-line release file: " + releaseFile), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.log.debug((Object)("Failed closing single-line release file: " + releaseFile), (Throwable)e);
                }
            }
        }
        return release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readMultiVariableReleaseFile(File releaseFile) {
        Properties variables = new Properties();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(releaseFile));
            while ((line = reader.readLine()) != null) {
                int index;
                if ((line = line.trim()).equals("") || line.charAt(0) == '#' || (index = line.indexOf(61)) == -1) continue;
                String varName = line.substring(0, index);
                String varValue = line.substring(index + 1);
                varValue = this.stripSurroundingQuotes(varValue);
                variables.setProperty(varName, varValue);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Failed reading multi-variable release file: " + releaseFile), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.log.debug((Object)("Failed closing multi-variable release file: " + releaseFile), (Throwable)e);
                }
            }
        }
        return variables;
    }

    private String stripSurroundingQuotes(String varValue) {
        if (varValue.charAt(0) == '\"' && varValue.charAt(varValue.length() - 1) == '\"' || varValue.charAt(0) == '\'' && varValue.charAt(varValue.length() - 1) == '\'') {
            varValue = varValue.substring(1, varValue.length() - 1);
        }
        return varValue;
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.US).indexOf("linux") != -1;
    }
}

