/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.ReadOnlyThroughChanges;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListenerFilter;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedItemData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ReadOnlyWorkspaceException;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspacePersistentDataManager
implements PersistentDataManager {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.WorkspacePersistentDataManager");
    protected final WorkspaceDataContainer dataContainer;
    protected final WorkspaceDataContainer systemDataContainer;
    protected final List<ItemsPersistenceListener> listeners;
    protected final List<MandatoryItemsPersistenceListener> mandatoryListeners;
    protected final List<ItemsPersistenceListenerFilter> liestenerFilters;
    protected boolean readOnly = false;

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder) {
        this.dataContainer = dataContainer;
        this.systemDataContainer = systemDataContainerHolder.getContainer();
        this.listeners = new ArrayList<ItemsPersistenceListener>();
        this.mandatoryListeners = new ArrayList<MandatoryItemsPersistenceListener>();
        this.liestenerFilters = new ArrayList<ItemsPersistenceListenerFilter>();
    }

    @Override
    public void save(ItemStateChangesLog changesLog) throws RepositoryException {
        ItemStateChangesLog persistedLog;
        if (this.readOnly && !(changesLog instanceof ReadOnlyThroughChanges)) {
            throw new ReadOnlyWorkspaceException("Workspace container '" + this.dataContainer.getName() + "' is read-only.");
        }
        ChangesLogPersister persister = new ChangesLogPersister();
        try {
            try {
                if (changesLog instanceof PlainChangesLogImpl) {
                    persistedLog = persister.save((PlainChangesLogImpl)changesLog);
                } else if (changesLog instanceof TransactionChangesLog) {
                    TransactionChangesLog orig = (TransactionChangesLog)changesLog;
                    TransactionChangesLog persisted = new TransactionChangesLog();
                    persisted.setSystemId(orig.getSystemId());
                    ChangesLogIterator iter = orig.getLogIterator();
                    while (iter.hasNextLog()) {
                        persisted.addLog(persister.save(iter.nextLog()));
                    }
                    persistedLog = persisted;
                } else {
                    throw new RepositoryException("Unsupported changes log class " + changesLog.getClass());
                }
                persister.commit();
            }
            catch (IOException e) {
                throw new RepositoryException("Save error", (Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            persister.rollback();
            throw throwable;
        }
        persister.rollback();
        this.notifySaveItems(persistedLog, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            itemData = con.getItemData(identifier);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        ArrayList<PropertyData> arrayList;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> allRefs = con.getReferencesData(identifier);
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = allRefs.get(i);
                if (skipVersionStorage) {
                    if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                    refProps.add(ref);
                    continue;
                }
                refProps.add(ref);
            }
            arrayList = refProps;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        List<NodeData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildNodesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        int n;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            n = con.getChildNodesCount(parent);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildPropertiesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.listChildPropertiesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSameNameSibling(NodeData node, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException {
        block5: {
            if (node.getQPath().getIndex() > 1) {
                QPathEntry[] path = node.getQPath().getEntries();
                QPathEntry[] siblingPath = new QPathEntry[path.length];
                int li = path.length - 1;
                System.arraycopy(path, 0, siblingPath, 0, li);
                siblingPath[li] = new QPathEntry(path[li], path[li].getIndex() - 1);
                if (addedNodes.contains(new QPath(siblingPath))) {
                    return;
                }
                if (this.dataContainer.isCheckSNSNewConnection()) {
                    WorkspaceStorageConnection acon = this.dataContainer.openConnection();
                    try {
                        this.checkPersistedSNS(node, acon);
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        acon.close();
                        throw throwable;
                    }
                    acon.close();
                    {
                        break block5;
                    }
                }
                this.checkPersistedSNS(node, con);
            }
        }
    }

    private void checkPersistedSNS(NodeData node, WorkspaceStorageConnection acon) throws RepositoryException {
        QPathEntry myName;
        NodeData parent = (NodeData)acon.getItemData(node.getParentIdentifier());
        ItemData sibling = acon.getItemData(parent, new QPathEntry((myName = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]).getNamespace(), myName.getName(), myName.getIndex() - 1));
        if (sibling == null || !sibling.isNode()) {
            throw new InvalidItemStateException("Node can't be saved " + node.getQPath().getAsString() + ". No same-name sibling exists with index " + (myName.getIndex() - 1) + ".");
        }
    }

    protected void doDelete(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.delete((NodeData)item);
        } else {
            con.delete((PropertyData)item);
        }
    }

    protected void doUpdate(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.update((NodeData)item);
        } else {
            con.update((PropertyData)item);
        }
    }

    protected void doAdd(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            this.checkSameNameSibling(node, con, addedNodes);
            addedNodes.add(node.getQPath());
            con.add(node);
        } else {
            con.add((PropertyData)item);
        }
    }

    protected void doRename(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        NodeData node = (NodeData)item;
        this.checkSameNameSibling(node, con, addedNodes);
        addedNodes.add(node.getQPath());
        con.rename(node);
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    @Override
    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.add((MandatoryItemsPersistenceListener)listener);
        } else {
            this.listeners.add(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener registered: " + listener));
        }
    }

    @Override
    public void removeItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.remove(listener);
        } else {
            this.listeners.remove(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener unregistered: " + listener));
        }
    }

    @Override
    public void addItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.liestenerFilters.add(filter);
    }

    @Override
    public void removeItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.liestenerFilters.remove(filter);
    }

    protected boolean isListenerAccepted(ItemsPersistenceListener listener) {
        for (ItemsPersistenceListenerFilter f : this.liestenerFilters) {
            if (f.accept(listener)) continue;
            return false;
        }
        return true;
    }

    protected void notifySaveItems(ItemStateChangesLog changesLog, boolean isListenerTXAware) {
        for (MandatoryItemsPersistenceListener mlistener : this.mandatoryListeners) {
            if (mlistener.isTXAware() != isListenerTXAware) continue;
            mlistener.onSaveItems(changesLog);
        }
        for (ItemsPersistenceListener listener : this.listeners) {
            if (listener.isTXAware() != isListenerTXAware || !this.isListenerAccepted(listener)) continue;
            listener.onSaveItems(changesLog);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            itemData = con.getItemData(parentData, name);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return itemData;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean status) {
        this.readOnly = status;
    }

    class ChangesLogPersister {
        private final Set<QPath> addedNodes = new HashSet<QPath>();
        private WorkspaceStorageConnection thisConnection = null;
        private WorkspaceStorageConnection systemConnection = null;

        ChangesLogPersister() {
        }

        protected void commit() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null) {
                this.thisConnection.commit();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection)) {
                this.systemConnection.commit();
            }
        }

        protected void rollback() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null && this.thisConnection.isOpened()) {
                this.thisConnection.rollback();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection) && this.systemConnection.isOpened()) {
                this.systemConnection.rollback();
            }
            this.addedNodes.clear();
        }

        protected WorkspaceStorageConnection getSystemConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.systemConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.systemDataContainer.equals(WorkspacePersistentDataManager.this.dataContainer) && this.thisConnection != null ? WorkspacePersistentDataManager.this.systemDataContainer.reuseConnection(this.thisConnection) : WorkspacePersistentDataManager.this.systemDataContainer.openConnection()) : (this.thisConnection == null ? (this.thisConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection()) : this.thisConnection);
                workspaceStorageConnection = this.systemConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.systemConnection;
            }
            return workspaceStorageConnection;
        }

        protected WorkspaceStorageConnection getThisConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.thisConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.dataContainer.equals(WorkspacePersistentDataManager.this.systemDataContainer) && this.systemConnection != null ? WorkspacePersistentDataManager.this.dataContainer.reuseConnection(this.systemConnection) : WorkspacePersistentDataManager.this.dataContainer.openConnection()) : (this.systemConnection == null ? (this.systemConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection()) : this.systemConnection);
                workspaceStorageConnection = this.thisConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.thisConnection;
            }
            return workspaceStorageConnection;
        }

        protected PlainChangesLogImpl save(PlainChangesLog changesLog) throws InvalidItemStateException, RepositoryException, IOException {
            PlainChangesLogImpl newLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), changesLog.getSessionId(), changesLog.getEventType(), changesLog.getPairId());
            for (ItemState prevState : changesLog.getAllStates()) {
                ItemData prevData;
                ItemData newData;
                if (prevState.getData() instanceof PersistedItemData) {
                    newData = prevState.getData();
                } else if (prevState.isNode()) {
                    prevData = (NodeData)prevState.getData();
                    newData = new PersistedNodeData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getOrderNumber(), prevData.getPrimaryTypeName(), prevData.getMixinTypeNames(), prevData.getACL());
                } else {
                    prevData = (PropertyData)prevState.getData();
                    if (prevData.getValues() != null) {
                        ArrayList<ValueData> values = new ArrayList<ValueData>();
                        for (int i = 0; i < prevData.getValues().size(); ++i) {
                            ValueData vd = prevData.getValues().get(i);
                            if (vd instanceof TransientValueData) {
                                AbstractPersistedValueData pvd;
                                TransientValueData tvd = (TransientValueData)vd;
                                if (vd.isByteArray()) {
                                    pvd = new ByteArrayPersistedValueData(i, vd.getAsByteArray());
                                    values.add(pvd);
                                } else {
                                    File destFile = null;
                                    pvd = tvd.getSpoolFile() != null ? new StreamPersistedValueData(i, tvd.getSpoolFile(), destFile) : new StreamPersistedValueData(i, tvd.getOriginalStream(), destFile);
                                    values.add(pvd);
                                }
                                tvd.delegate(pvd);
                                continue;
                            }
                            values.add(vd);
                        }
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), values);
                    } else {
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), null);
                    }
                }
                ItemState itemState = new ItemState(newData, prevState.getState(), prevState.isEventFire(), prevState.getAncestorToSave(), prevState.isInternallyCreated(), prevState.isPersisted());
                newLog.add(itemState);
                if (!itemState.isPersisted()) continue;
                long start = System.currentTimeMillis();
                ItemData data = itemState.getData();
                WorkspaceStorageConnection conn = WorkspacePersistentDataManager.this.isSystemDescendant(data.getQPath()) ? this.getSystemConnection() : this.getThisConnection();
                if (itemState.isAdded()) {
                    WorkspacePersistentDataManager.this.doAdd(data, conn, this.addedNodes);
                } else if (itemState.isUpdated()) {
                    WorkspacePersistentDataManager.this.doUpdate(data, conn);
                } else if (itemState.isDeleted()) {
                    WorkspacePersistentDataManager.this.doDelete(data, conn);
                } else if (itemState.isRenamed()) {
                    WorkspacePersistentDataManager.this.doRename(data, conn, this.addedNodes);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(ItemState.nameFromValue(itemState.getState()) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
            }
            return newLog;
        }
    }
}

