/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.Invariant;
import org.jboss.aspects.dbc.StaticInvariant;
import org.jboss.aspects.dbc.condition.ExecutableCondition;
import org.jboss.aspects.dbc.condition.InvariantCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionManager {
    protected static HashMap<AccessibleObject, ExecutableCondition[]> preConditions = new HashMap();
    protected static HashMap<AccessibleObject, ExecutableCondition[]> postConditions = new HashMap();
    protected static HashMap<Class<?>, InvariantCondition[]> invariants = new HashMap();

    public static synchronized InvariantCondition[] getInvariants(Class<?> clazz) {
        InvariantCondition[] inv = invariants.get(clazz);
        if (inv != null) {
            return inv;
        }
        ConditionManager.initialise(clazz);
        return invariants.get(clazz);
    }

    protected static void initialise(Class<?> clazz) {
        ArrayList<InvariantCondition> invConds = new ArrayList<InvariantCondition>();
        if (invariants.get(clazz) != null && DesignByContractAspect.verbose) {
            System.out.println("[dbc] Already have invariants for class: " + clazz);
        }
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] ===== Initialising invariants for class: " + clazz);
        }
        for (Class<?> curClazz = clazz; curClazz != null; curClazz = curClazz.getSuperclass()) {
            ConditionManager.addInvariantConditions(invConds, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ConditionManager.addInvariantConditions(invConds, interfaces[i]);
            }
        }
        InvariantCondition[] inv = invConds.toArray(new InvariantCondition[invConds.size()]);
        invariants.put(clazz, inv);
    }

    private static void addInvariantConditions(ArrayList<InvariantCondition> conditions, Class<?> clazz) {
        StaticInvariant statinv;
        Invariant inv = (Invariant)AnnotationElement.getAnyAnnotation(clazz, Invariant.class);
        if (inv != null) {
            String[] exprs;
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found non-static invariants in class: " + clazz);
            }
            if ((exprs = inv.value()) != null) {
                for (int i = 0; i < exprs.length; ++i) {
                    conditions.add(new InvariantCondition(clazz, exprs[i], false));
                }
            }
        }
        if ((statinv = (StaticInvariant)AnnotationElement.getAnyAnnotation(clazz, StaticInvariant.class)) != null) {
            String[] exprs;
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found static invariants in class: " + clazz);
            }
            if ((exprs = statinv.value()) != null) {
                for (int i = 0; i < exprs.length; ++i) {
                    conditions.add(new InvariantCondition(clazz, exprs[i], true));
                }
            }
        }
    }
}

