/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.s3;

import java.lang.reflect.Field;
import java.util.Properties;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.CallingFormat;
import net.noderunner.amazon.s3.Connection;
import org.jboss.cache.CacheException;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.s3.S3CacheLoader;

public class S3LoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = 4626734068542420865L;
    private String accessKeyId;
    private String secretAccessKey;
    private boolean secure;
    private String server = "s3.amazonaws.com";
    private int port;
    private transient Bucket bucket = new Bucket("jboss-cache");
    private transient CallingFormat callingFormat = CallingFormat.SUBDOMAIN;
    private String location = Connection.LOCATION_DEFAULT;
    private boolean optimize = false;
    private boolean parentCache = true;

    public S3LoaderConfig() {
        this.setClassName(S3CacheLoader.class.getName());
    }

    S3LoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.setClassName(S3CacheLoader.class.getName());
        this.populateFromBaseConfig(base);
    }

    Connection getConnection() {
        return new Connection(this.getAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getPort(), this.getCallingFormat());
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        if (props == null) {
            return;
        }
        this.setAccessKeyId(props.getProperty("cache.s3.accessKeyId"));
        this.setSecretAccessKey(props.getProperty("cache.s3.secretAccessKey"));
        this.setSecure(props.getProperty("cache.s3.secure"));
        this.setServer(props.getProperty("cache.s3.server", "s3.amazonaws.com"));
        this.setPort(props.getProperty("cache.s3.port"));
        this.setBucket(props.getProperty("cache.s3.bucket"));
        this.setCallingFormat(props.getProperty("cache.s3.callingFormat"));
        this.setOptimize(props.getProperty("cache.s3.optimize"));
        this.setParentCache(props.getProperty("cache.s3.parentCache"));
        this.setLocation(props.getProperty("cache.s3.location"));
    }

    private void setLocation(String s) {
        if (s != null) {
            this.location = s;
        }
    }

    private void setParentCache(String s) {
        if (s != null) {
            this.setParentCache(Boolean.valueOf(s));
        }
    }

    private void setOptimize(String s) {
        if (s != null) {
            this.setOptimize(Boolean.valueOf(s));
        }
    }

    private void setCallingFormat(String s) {
        if (s != null) {
            try {
                Field field = CallingFormat.class.getDeclaredField(s);
                this.setCallingFormat((CallingFormat)field.get(null));
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
    }

    private void setBucket(String s) {
        if (s != null) {
            this.setBucket(new Bucket(s));
        }
    }

    private void setSecure(String s) {
        if (s != null) {
            this.setSecure(Boolean.valueOf(s));
        }
    }

    private void setPort(String s) {
        if (s != null) {
            this.setPort(Integer.parseInt(s));
        } else {
            this.setPort(this.secure ? 443 : 80);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof S3LoaderConfig && this.equalsExcludingProperties(obj)) {
            return this == obj;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties();
    }

    public S3LoaderConfig clone() throws CloneNotSupportedException {
        return (S3LoaderConfig)super.clone();
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId.trim();
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey.trim();
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    public CallingFormat getCallingFormat() {
        return this.callingFormat;
    }

    public void setCallingFormat(CallingFormat callingFormat) {
        this.callingFormat = callingFormat;
    }

    public String toString() {
        return super.toString() + " keyid=" + this.accessKeyId + " secret=" + "***" + " secure=" + this.secure + " server=" + this.server + " port=" + this.port + " bucket=" + this.bucket + " cf=" + this.callingFormat + " location=" + this.location;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean getParentCache() {
        return this.parentCache;
    }

    public void setParentCache(boolean parentCache) {
        this.parentCache = parentCache;
    }

    public String getLocation() {
        return this.location;
    }
}

