/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;

public class MemoryIndex
implements Serializable {
    private final HashMap fields = new HashMap();
    private transient Map.Entry[] sortedFields;
    private final int stride;
    private static final float docBoost = 1.0f;
    private static final long serialVersionUID = 2782195016849084649L;
    private static final boolean DEBUG = false;
    private static final Comparator termComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry) {
                o1 = ((Map.Entry)o1).getKey();
            }
            if (o2 instanceof Map.Entry) {
                o2 = ((Map.Entry)o2).getKey();
            }
            if (o1 == o2) {
                return 0;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };
    private static final Term MATCH_ALL_TERM = new Term("");
    static /* synthetic */ Class class$org$apache$lucene$index$memory$MemoryIndex;

    public MemoryIndex() {
        this(false);
    }

    private MemoryIndex(boolean storeOffsets) {
        this.stride = storeOffsets ? 3 : 1;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        TokenStream stream = analyzer instanceof PatternAnalyzer ? ((PatternAnalyzer)analyzer).tokenStream(fieldName, text) : analyzer.tokenStream(fieldName, (Reader)new PatternAnalyzer.FastStringReader(text));
        this.addField(fieldName, stream);
    }

    public TokenStream keywordTokenStream(final Collection keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator iter;
            private int start;
            static final /* synthetic */ boolean $assertionsDisabled;
            {
                this.iter = keywords.iterator();
                this.start = 0;
            }

            public Token next(Token reusableToken) {
                if (!$assertionsDisabled && reusableToken == null) {
                    throw new AssertionError();
                }
                if (!this.iter.hasNext()) {
                    return null;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                reusableToken.reinit(term, this.start, this.start + reusableToken.termLength());
                this.start += term.length() + 1;
                return reusableToken;
            }

            static {
                $assertionsDisabled = !(class$org$apache$lucene$index$memory$MemoryIndex == null ? (class$org$apache$lucene$index$memory$MemoryIndex = MemoryIndex.class$("org.apache.lucene.index.memory.MemoryIndex")) : class$org$apache$lucene$index$memory$MemoryIndex).desiredAssertionStatus();
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        try {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName must not be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("token stream must not be null");
            }
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("boost factor must be greater than 0.0");
            }
            if (this.fields.get(fieldName) != null) {
                throw new IllegalArgumentException("field must not be added more than once");
            }
            HashMap<String, ArrayIntList> terms = new HashMap<String, ArrayIntList>();
            int numTokens = 0;
            int pos = -1;
            Token reusableToken = new Token();
            Token nextToken = stream.next(reusableToken);
            while (nextToken != null) {
                String term = nextToken.term();
                if (term.length() != 0) {
                    ++numTokens;
                    pos += nextToken.getPositionIncrement();
                    ArrayIntList positions = (ArrayIntList)terms.get(term);
                    if (positions == null) {
                        positions = new ArrayIntList(this.stride);
                        terms.put(term, positions);
                    }
                    if (this.stride == 1) {
                        positions.add(pos);
                    } else {
                        positions.add(pos, nextToken.startOffset(), nextToken.endOffset());
                    }
                }
                nextToken = stream.next(reusableToken);
            }
            if (numTokens > 0) {
                this.fields.put(fieldName, new Info(terms, numTokens, boost *= 1.0f));
                this.sortedFields = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        reader.setSearcher((Searcher)searcher);
        return searcher;
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            searcher.search(query, new HitCollector(){

                public void collect(int doc, float score) {
                    scores[0] = score;
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMemorySize() {
        int PTR = VM.PTR;
        int INT = 4;
        int size = 0;
        size += VM.sizeOfObject(2 * PTR + INT);
        if (this.sortedFields != null) {
            size += VM.sizeOfObjectArray(this.sortedFields.length);
        }
        size += VM.sizeOfHashMap(this.fields.size());
        Iterator iter = this.fields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Info info = (Info)entry.getValue();
            size += VM.sizeOfObject(2 * INT + 3 * PTR);
            if (info.sortedTerms != null) {
                size += VM.sizeOfObjectArray(info.sortedTerms.length);
            }
            int len = info.terms.size();
            size += VM.sizeOfHashMap(len);
            Iterator iter2 = info.terms.entrySet().iterator();
            while (--len >= 0) {
                Map.Entry e = iter2.next();
                size += VM.sizeOfObject(PTR + 3 * INT);
                ArrayIntList positions = (ArrayIntList)e.getValue();
                size += VM.sizeOfArrayIntList(positions.size());
            }
        }
        return size;
    }

    private int numPositions(ArrayIntList positions) {
        return positions.size() / this.stride;
    }

    private void sortFields() {
        if (this.sortedFields == null) {
            this.sortedFields = MemoryIndex.sort(this.fields);
        }
    }

    private static Map.Entry[] sort(HashMap map) {
        int size = map.size();
        Map.Entry[] entries = new Map.Entry[size];
        Iterator iter = map.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            entries[i] = iter.next();
        }
        if (size > 1) {
            Arrays.sort(entries, termComparator);
        }
        return entries;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        this.sortFields();
        int sumChars = 0;
        int sumPositions = 0;
        int sumTerms = 0;
        for (int i = 0; i < this.sortedFields.length; ++i) {
            Map.Entry entry = this.sortedFields[i];
            String fieldName = (String)entry.getKey();
            Info info = (Info)entry.getValue();
            info.sortTerms();
            result.append(fieldName + ":\n");
            int numChars = 0;
            int numPositions = 0;
            for (int j = 0; j < info.sortedTerms.length; ++j) {
                Map.Entry e = info.sortedTerms[j];
                String term = (String)e.getKey();
                ArrayIntList positions = (ArrayIntList)e.getValue();
                result.append("\t'" + term + "':" + this.numPositions(positions) + ":");
                result.append(positions.toString(this.stride));
                result.append("\n");
                numPositions += this.numPositions(positions);
                numChars += term.length();
            }
            result.append("\tterms=" + info.sortedTerms.length);
            result.append(", positions=" + numPositions);
            result.append(", Kchars=" + (float)numChars / 1000.0f);
            result.append("\n");
            sumPositions += numPositions;
            sumChars += numChars;
            sumTerms += info.sortedTerms.length;
        }
        result.append("\nfields=" + this.sortedFields.length);
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        result.append(", Kchars=" + (float)sumChars / 1000.0f);
        return result.toString();
    }

    private static final class VM {
        public static final int PTR = VM.is64BitVM() ? 8 : 4;
        public static final int BOOLEAN = 1;
        public static final int BYTE = 1;
        public static final int CHAR = 2;
        public static final int SHORT = 2;
        public static final int INT = 4;
        public static final int LONG = 8;
        public static final int FLOAT = 4;
        public static final int DOUBLE = 8;
        private static final int LOG_PTR = (int)Math.round(VM.log2(PTR));
        private static final int OBJECT_HEADER = 2 * PTR;
        private static final boolean IS_WORD_ALIGNED_VM = true;

        private VM() {
        }

        private static int sizeOf(int n) {
            return (n - 1 >> LOG_PTR) + 1 << LOG_PTR;
        }

        public static int sizeOfObject(int n) {
            return VM.sizeOf(OBJECT_HEADER + n);
        }

        public static int sizeOfObjectArray(int len) {
            return VM.sizeOfObject(4 + PTR * len);
        }

        public static int sizeOfCharArray(int len) {
            return VM.sizeOfObject(4 + 2 * len);
        }

        public static int sizeOfIntArray(int len) {
            return VM.sizeOfObject(4 + 4 * len);
        }

        public static int sizeOfString(int len) {
            return VM.sizeOfObject(12 + PTR) + VM.sizeOfCharArray(len);
        }

        public static int sizeOfHashMap(int len) {
            return VM.sizeOfObject(4 * PTR + 16) + VM.sizeOfObjectArray(len) + len * VM.sizeOfObject(3 * PTR + 4);
        }

        public static int sizeOfArrayList(int len) {
            return VM.sizeOfObject(PTR + 8) + VM.sizeOfObjectArray(len);
        }

        public static int sizeOfArrayIntList(int len) {
            return VM.sizeOfObject(PTR + 4) + VM.sizeOfIntArray(len);
        }

        private static boolean is64BitVM() {
            try {
                int bits = Integer.getInteger("sun.arch.data.model", 0);
                if (bits != 0) {
                    return bits == 64;
                }
                return System.getProperty("java.vm.name").toLowerCase().indexOf("64") >= 0;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static double log2(double value) {
            return Math.log(value) / Math.log(2.0);
        }
    }

    private final class MemoryIndexReader
    extends IndexReader {
        private Searcher searcher;
        private byte[] cachedNorms;
        private String cachedFieldName;
        private Similarity cachedSimilarity;

        private MemoryIndexReader() {
            super(null);
        }

        protected void finalize() {
        }

        private Info getInfo(String fieldName) {
            return (Info)MemoryIndex.this.fields.get(fieldName);
        }

        private Info getInfo(int pos) {
            return (Info)MemoryIndex.this.sortedFields[pos].getValue();
        }

        public int docFreq(Term term) {
            Info info = this.getInfo(term.field());
            int freq = 0;
            if (info != null) {
                freq = info.getPositions(term.text()) != null ? 1 : 0;
            }
            return freq;
        }

        public TermEnum terms() {
            return this.terms(MATCH_ALL_TERM);
        }

        public TermEnum terms(Term term) {
            int i;
            MemoryIndex.this.sortFields();
            int j = MemoryIndex.this.sortedFields.length == 1 && MemoryIndex.this.sortedFields[0].getKey() == term.field() ? 0 : Arrays.binarySearch(MemoryIndex.this.sortedFields, term.field(), termComparator);
            if (j < 0) {
                j = -j - 1;
                i = 0;
                if (j < MemoryIndex.this.sortedFields.length) {
                    this.getInfo(j).sortTerms();
                }
            } else {
                Info info = this.getInfo(j);
                info.sortTerms();
                i = Arrays.binarySearch(info.sortedTerms, term.text(), termComparator);
                if (i < 0 && (i = -i - 1) >= info.sortedTerms.length) {
                    i = 0;
                    if (++j < MemoryIndex.this.sortedFields.length) {
                        this.getInfo(j).sortTerms();
                    }
                }
            }
            final int ix = i;
            final int jx = j;
            return new TermEnum(){
                private int i;
                private int j;
                {
                    this.i = ix;
                    this.j = jx;
                }

                public boolean next() {
                    if (this.j >= MemoryIndex.this.sortedFields.length) {
                        return false;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.j);
                    if (++this.i < info.sortedTerms.length) {
                        return true;
                    }
                    ++this.j;
                    this.i = 0;
                    if (this.j >= MemoryIndex.this.sortedFields.length) {
                        return false;
                    }
                    MemoryIndexReader.this.getInfo(this.j).sortTerms();
                    return true;
                }

                public Term term() {
                    if (this.j >= MemoryIndex.this.sortedFields.length) {
                        return null;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.j);
                    if (this.i >= info.sortedTerms.length) {
                        return null;
                    }
                    return this.createTerm(info, this.j, (String)info.sortedTerms[this.i].getKey());
                }

                public int docFreq() {
                    if (this.j >= MemoryIndex.this.sortedFields.length) {
                        return 0;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.j);
                    if (this.i >= info.sortedTerms.length) {
                        return 0;
                    }
                    return MemoryIndex.this.numPositions(info.getPositions(this.i));
                }

                public void close() {
                }

                private Term createTerm(Info info, int pos, String text) {
                    Term template = info.template;
                    if (template == null) {
                        String fieldName = (String)MemoryIndex.this.sortedFields[pos].getKey();
                        info.template = template = new Term(fieldName);
                    }
                    return template.createTerm(text);
                }
            };
        }

        public TermPositions termPositions() {
            return new TermPositions(){
                private boolean hasNext;
                private int cursor = 0;
                private ArrayIntList current;

                public void seek(Term term) {
                    Info info = MemoryIndexReader.this.getInfo(term.field());
                    this.current = info == null ? null : info.getPositions(term.text());
                    this.hasNext = this.current != null;
                    this.cursor = 0;
                }

                public void seek(TermEnum termEnum) {
                    this.seek(termEnum.term());
                }

                public int doc() {
                    return 0;
                }

                public int freq() {
                    int freq = this.current != null ? MemoryIndex.this.numPositions(this.current) : 0;
                    return freq;
                }

                public boolean next() {
                    boolean next = this.hasNext;
                    this.hasNext = false;
                    return next;
                }

                public int read(int[] docs, int[] freqs) {
                    if (!this.hasNext) {
                        return 0;
                    }
                    this.hasNext = false;
                    docs[0] = 0;
                    freqs[0] = this.freq();
                    return 1;
                }

                public boolean skipTo(int target) {
                    return this.next();
                }

                public void close() {
                }

                public int nextPosition() {
                    int pos = this.current.get(this.cursor);
                    this.cursor += MemoryIndex.this.stride;
                    return pos;
                }

                public int getPayloadLength() {
                    throw new UnsupportedOperationException();
                }

                public byte[] getPayload(byte[] data, int offset) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean isPayloadAvailable() {
                    return false;
                }
            };
        }

        public TermDocs termDocs() {
            return this.termPositions();
        }

        public TermFreqVector[] getTermFreqVectors(int docNumber) {
            TermFreqVector[] vectors = new TermFreqVector[MemoryIndex.this.fields.size()];
            Iterator iter = MemoryIndex.this.fields.keySet().iterator();
            for (int i = 0; i < vectors.length; ++i) {
                String fieldName = (String)iter.next();
                vectors[i] = this.getTermFreqVector(docNumber, fieldName);
            }
            return vectors;
        }

        public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
            Iterator iterator = MemoryIndex.this.fields.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                this.getTermFreqVector(docNumber, fieldName, mapper);
            }
        }

        public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
            Info info = this.getInfo(field);
            if (info == null) {
                return;
            }
            info.sortTerms();
            mapper.setExpectations(field, info.sortedTerms.length, MemoryIndex.this.stride != 1, true);
            int i = info.sortedTerms.length;
            while (--i >= 0) {
                ArrayIntList positions = (ArrayIntList)info.sortedTerms[i].getValue();
                int size = positions.size();
                TermVectorOffsetInfo[] offsets = new TermVectorOffsetInfo[size / MemoryIndex.this.stride];
                int k = 0;
                for (int j = 1; j < size; j += MemoryIndex.this.stride) {
                    int start = positions.get(j);
                    int end = positions.get(j + 1);
                    offsets[k] = new TermVectorOffsetInfo(start, end);
                    ++k;
                }
                mapper.map((String)info.sortedTerms[i].getKey(), MemoryIndex.this.numPositions((ArrayIntList)info.sortedTerms[i].getValue()), offsets, ((ArrayIntList)info.sortedTerms[i].getValue()).toArray(MemoryIndex.this.stride));
            }
        }

        public TermFreqVector getTermFreqVector(int docNumber, final String fieldName) {
            final Info info = this.getInfo(fieldName);
            if (info == null) {
                return null;
            }
            info.sortTerms();
            return new TermPositionVector(){
                private final Map.Entry[] sortedTerms;
                {
                    this.sortedTerms = info.sortedTerms;
                }

                public String getField() {
                    return fieldName;
                }

                public int size() {
                    return this.sortedTerms.length;
                }

                public String[] getTerms() {
                    String[] terms = new String[this.sortedTerms.length];
                    int i = this.sortedTerms.length;
                    while (--i >= 0) {
                        terms[i] = (String)this.sortedTerms[i].getKey();
                    }
                    return terms;
                }

                public int[] getTermFrequencies() {
                    int[] freqs = new int[this.sortedTerms.length];
                    int i = this.sortedTerms.length;
                    while (--i >= 0) {
                        freqs[i] = MemoryIndex.this.numPositions((ArrayIntList)this.sortedTerms[i].getValue());
                    }
                    return freqs;
                }

                public int indexOf(String term) {
                    int i = Arrays.binarySearch(this.sortedTerms, term, termComparator);
                    return i >= 0 ? i : -1;
                }

                public int[] indexesOf(String[] terms, int start, int len) {
                    int[] indexes = new int[len];
                    for (int i = 0; i < len; ++i) {
                        indexes[i] = this.indexOf(terms[start++]);
                    }
                    return indexes;
                }

                public int[] getTermPositions(int index) {
                    return ((ArrayIntList)this.sortedTerms[index].getValue()).toArray(MemoryIndex.this.stride);
                }

                public TermVectorOffsetInfo[] getOffsets(int index) {
                    if (MemoryIndex.this.stride == 1) {
                        return null;
                    }
                    ArrayIntList positions = (ArrayIntList)this.sortedTerms[index].getValue();
                    int size = positions.size();
                    TermVectorOffsetInfo[] offsets = new TermVectorOffsetInfo[size / MemoryIndex.this.stride];
                    int i = 0;
                    for (int j = 1; j < size; j += MemoryIndex.this.stride) {
                        int start = positions.get(j);
                        int end = positions.get(j + 1);
                        offsets[i] = new TermVectorOffsetInfo(start, end);
                        ++i;
                    }
                    return offsets;
                }
            };
        }

        private Similarity getSimilarity() {
            if (this.searcher != null) {
                return this.searcher.getSimilarity();
            }
            return Similarity.getDefault();
        }

        private void setSearcher(Searcher searcher) {
            this.searcher = searcher;
        }

        public byte[] norms(String fieldName) {
            byte[] norms = this.cachedNorms;
            Similarity sim = this.getSimilarity();
            if (fieldName != this.cachedFieldName || sim != this.cachedSimilarity) {
                Info info = this.getInfo(fieldName);
                int numTokens = info != null ? info.numTokens : 0;
                float n = sim.lengthNorm(fieldName, numTokens);
                float boost = info != null ? info.getBoost() : 1.0f;
                byte norm = Similarity.encodeNorm((float)(n *= boost));
                this.cachedNorms = norms = new byte[]{norm};
                this.cachedFieldName = fieldName;
                this.cachedSimilarity = sim;
            }
            return norms;
        }

        public void norms(String fieldName, byte[] bytes, int offset) {
            byte[] norms = this.norms(fieldName);
            System.arraycopy(norms, 0, bytes, offset, norms.length);
        }

        protected void doSetNorm(int doc, String fieldName, byte value) {
            throw new UnsupportedOperationException();
        }

        public int numDocs() {
            return MemoryIndex.this.fields.size() > 0 ? 1 : 0;
        }

        public int maxDoc() {
            return 1;
        }

        public Document document(int n) {
            return new Document();
        }

        public Document document(int n, FieldSelector fieldSelector) throws IOException {
            return new Document();
        }

        public boolean isDeleted(int n) {
            return false;
        }

        public boolean hasDeletions() {
            return false;
        }

        protected void doDelete(int docNum) {
            throw new UnsupportedOperationException();
        }

        protected void doUndeleteAll() {
            throw new UnsupportedOperationException();
        }

        protected void doCommit() {
        }

        protected void doClose() {
        }

        public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
            if (fieldOption == IndexReader.FieldOption.UNINDEXED) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET && MemoryIndex.this.stride == 1) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET && MemoryIndex.this.stride == 1) {
                return Collections.EMPTY_SET;
            }
            return Collections.unmodifiableSet(MemoryIndex.this.fields.keySet());
        }
    }

    private static final class ArrayIntList
    implements Serializable {
        private int[] elements;
        private int size = 0;
        private static final long serialVersionUID = 2282195016849084649L;

        public ArrayIntList() {
            this(10);
        }

        public ArrayIntList(int initialCapacity) {
            this.elements = new int[initialCapacity];
        }

        public void add(int elem) {
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elements[this.size++] = elem;
        }

        public void add(int pos, int start, int end) {
            if (this.size + 3 > this.elements.length) {
                this.ensureCapacity(this.size + 3);
            }
            this.elements[this.size] = pos;
            this.elements[this.size + 1] = start;
            this.elements[this.size + 2] = end;
            this.size += 3;
        }

        public int get(int index) {
            if (index >= this.size) {
                this.throwIndex(index);
            }
            return this.elements[index];
        }

        public int size() {
            return this.size;
        }

        public int[] toArray(int stride) {
            int[] arr = new int[this.size() / stride];
            if (stride == 1) {
                System.arraycopy(this.elements, 0, arr, 0, this.size);
            } else {
                int i = 0;
                for (int j = 0; j < this.size; j += stride) {
                    arr[i] = this.elements[j];
                    ++i;
                }
            }
            return arr;
        }

        private void ensureCapacity(int minCapacity) {
            int newCapacity = Math.max(minCapacity, this.elements.length * 3 / 2 + 1);
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }

        private void throwIndex(int index) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }

        public String toString(int stride) {
            int s = this.size() / stride;
            int len = Math.min(10, s);
            StringBuffer buf = new StringBuffer(4 * len);
            buf.append("[");
            for (int i = 0; i < len; ++i) {
                buf.append(this.get(i * stride));
                if (i >= len - 1) continue;
                buf.append(", ");
            }
            if (len != s) {
                buf.append(", ...");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static final class Info
    implements Serializable {
        private final HashMap terms;
        private transient Map.Entry[] sortedTerms;
        private final int numTokens;
        private final float boost;
        public transient Term template;
        private static final long serialVersionUID = 2882195016849084649L;

        public Info(HashMap terms, int numTokens, float boost) {
            this.terms = terms;
            this.numTokens = numTokens;
            this.boost = boost;
        }

        public void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = MemoryIndex.sort(this.terms);
            }
        }

        public ArrayIntList getPositions(String term) {
            return (ArrayIntList)this.terms.get(term);
        }

        public ArrayIntList getPositions(int pos) {
            return (ArrayIntList)this.sortedTerms[pos].getValue();
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

