/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.aspects.asynchronous.ProcessingTime;
import org.jboss.aspects.asynchronous.concurrent.AdapterTask;

public class TimedCallableImpl
implements Callable,
ProcessingTime {
    private final AdapterTask function;
    private final long millis;
    private long endingTime = -1L;
    private long startingTime = -1L;

    public TimedCallableImpl(AdapterTask function, long millis) {
        this.function = function;
        this.millis = millis;
    }

    public Object call() throws Exception {
        FutureTask result = new FutureTask(this.function);
        Thread thread = Executors.defaultThreadFactory().newThread(result);
        thread.start();
        try {
            this.startingTime = System.currentTimeMillis();
            Object obj = result.get(this.millis, TimeUnit.MILLISECONDS);
            this.endingTime = System.currentTimeMillis();
            return obj;
        }
        catch (TimeoutException ex) {
            this.endingTime = System.currentTimeMillis();
            this.function.cleanup();
            thread.interrupt();
            throw ex;
        }
    }

    public long getEndingTime() {
        return this.endingTime;
    }

    public long getStartingTime() {
        return this.startingTime;
    }
}

