/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.mxbean.MXBean;
import org.jboss.mx.mxbean.MXBeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanMetaData
extends AbstractBuilder {
    private Object mbeanInstance;
    private Class<?> mbeanClass;
    private Class<?> mbeanInterface;

    public static Class<?> findMXBeanInterface(Class<?> mbeanClass) {
        for (Class<?> concrete = mbeanClass; null != concrete; concrete = concrete.getSuperclass()) {
            Class<?> result = MXBeanMetaData.findMXBeanInterface(concrete, concrete.getInterfaces());
            if (null == result) continue;
            return result;
        }
        return null;
    }

    private static Class<?> findMXBeanInterface(Class<?> concrete, Class<?>[] interfaces) {
        String mxName = concrete.getName() + "MXBean";
        String stdName = concrete.getName() + "MBean";
        for (Class<?> intf : interfaces) {
            String name = intf.getName();
            if (mxName.equals(name) || stdName.equals(name)) {
                return intf;
            }
            MXBean mxBean = intf.getAnnotation(MXBean.class);
            if (mxBean == null || !mxBean.value()) continue;
            return intf;
        }
        return null;
    }

    public MXBeanMetaData(Object mbeanInstance) throws NotCompliantMBeanException {
        this(mbeanInstance.getClass());
        this.mbeanInstance = mbeanInstance;
    }

    public MXBeanMetaData(Class<?> mbeanClass) throws NotCompliantMBeanException {
        this.mbeanClass = mbeanClass;
        this.mbeanInterface = MXBeanMetaData.findMXBeanInterface(mbeanClass);
        if (this.mbeanInterface == null) {
            throw new NotCompliantMBeanException("Cannot obtain MXBean interface for: " + mbeanClass);
        }
    }

    public MXBeanMetaData(Object mbeanInstance, Class<?> mbeanInterface) throws NotCompliantMBeanException {
        this.mbeanInstance = mbeanInstance;
        this.mbeanClass = mbeanInstance.getClass();
        this.mbeanInterface = mbeanInterface;
        if (this.mbeanInterface == null) {
            this.mbeanInterface = MXBeanMetaData.findMXBeanInterface(this.mbeanClass);
        }
        if (this.mbeanInterface == null) {
            throw new NotCompliantMBeanException("Cannot obtain mxbean interface for: " + this.mbeanClass);
        }
        if (!this.mbeanInterface.isInterface()) {
            throw new NotCompliantMBeanException("Management interface is not an interface: " + mbeanInterface);
        }
    }

    public Class<?> getMBeanInterface() {
        return this.mbeanInterface;
    }

    @Override
    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            String[] keys;
            Object info;
            Method[] methods;
            if (this.mbeanInterface == null) {
                throw new NotCompliantMBeanException("The mbean does not implement a management interface");
            }
            if (this.mbeanInstance != null && !this.mbeanInterface.isInstance(this.mbeanInstance)) {
                throw new NotCompliantMBeanException("The mbean does not implement its management interface " + this.mbeanInterface.getName());
            }
            OpenMBeanConstructorInfo[] constructorInfo = this.buildConstructors();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, OpenMBeanOperationInfo> operInfo = new HashMap<String, OpenMBeanOperationInfo>();
            ArrayList<Object> attrInfo = new ArrayList<Object>();
            for (Method method : methods = this.mbeanInterface.getMethods()) {
                Method getter;
                String key;
                String methodName = method.getName();
                Type[] signature = method.getGenericParameterTypes();
                Type returnType = method.getGenericReturnType();
                if (methodName.startsWith("set") && methodName.length() > 3 && signature.length == 1 && returnType == Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    Method setter = (Method)setters.get(key);
                    if (setter != null && !setter.getGenericParameterTypes()[0].equals(signature[0])) {
                        throw new IntrospectionException("overloaded type for attribute set: " + key);
                    }
                    setters.put(key, method);
                    continue;
                }
                if (methodName.startsWith("get") && methodName.length() > 3 && signature.length == 0 && returnType != Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("is")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, method);
                    continue;
                }
                if (methodName.startsWith("is") && methodName.length() > 2 && signature.length == 0 && this.isBooleanReturn(returnType)) {
                    key = methodName.substring(2, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("get")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, method);
                    continue;
                }
                info = this.buildOperation(method);
                operInfo.put(this.getSignatureString(method), (OpenMBeanOperationInfo)info);
            }
            for (String key : keys = getters.keySet().toArray(new String[getters.size()])) {
                Method getter = (Method)getters.remove(key);
                Method setter = (Method)setters.remove(key);
                info = this.buildAttribute(key, getter, setter);
                attrInfo.add(info);
            }
            for (String key : setters.keySet()) {
                Method setter = (Method)setters.remove(key);
                OpenMBeanAttributeInfo info2 = this.buildAttribute(key, null, setter);
                attrInfo.add(info2);
            }
            OpenMBeanAttributeInfo[] attributeInfo = attrInfo.toArray(new OpenMBeanAttributeInfo[attrInfo.size()]);
            Collection operations = operInfo.values();
            OpenMBeanOperationInfo[] operationInfo = operations.toArray(new OpenMBeanOperationInfo[operations.size()]);
            MBeanNotificationInfo[] notifications = null;
            notifications = this.mbeanInstance instanceof NotificationBroadcaster ? ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo() : new MBeanNotificationInfo[]{};
            return this.buildMBeanInfo(attributeInfo, constructorInfo, operationInfo, notifications);
        }
        catch (Throwable t) {
            NotCompliantMBeanException e = new NotCompliantMBeanException("Error generating OpenMBeanInfo.");
            e.initCause(t);
            throw e;
        }
    }

    private OpenMBeanConstructorInfo[] buildConstructors() throws Exception {
        Constructor<?>[] constructors = this.mbeanClass.getConstructors();
        OpenMBeanConstructorInfo[] constructorInfo = new OpenMBeanConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructorInfo[i] = this.buildConstructor(constructors[i]);
        }
        return constructorInfo;
    }

    private OpenMBeanConstructorInfo buildConstructor(Constructor<?> constructor) throws Exception {
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        OpenMBeanParameterInfo[] parameterInfo = new OpenMBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterInfo[i] = this.buildParameter(i, parameterTypes[i]);
        }
        return new OpenMBeanConstructorInfoSupport("MBean Constructor.", "MBean Constructor.", parameterInfo);
    }

    private OpenMBeanParameterInfo buildParameter(int i, Type parameterType) throws Exception {
        OpenType openType = MXBeanUtils.getOpenType(parameterType);
        return new OpenMBeanParameterInfoSupport("arg" + i, "MBean Parameter.", openType);
    }

    private OpenMBeanAttributeInfo buildAttribute(String attrName, Method getter, Method setter) throws Exception {
        boolean isReadable = getter != null;
        boolean isWritable = setter != null;
        boolean isIs = false;
        OpenType openType = null;
        if (getter != null) {
            openType = MXBeanUtils.getOpenType(getter.getGenericReturnType());
            if (getter.getName().startsWith("is")) {
                isIs = true;
            }
        } else {
            openType = MXBeanUtils.getOpenType(setter.getGenericParameterTypes()[0]);
        }
        return new OpenMBeanAttributeInfoSupport(attrName, attrName, openType, isReadable, isWritable, isIs);
    }

    private OpenMBeanOperationInfo buildOperation(Method method) throws Exception {
        Type[] parameterTypes = method.getGenericParameterTypes();
        OpenMBeanParameterInfo[] parameterInfo = new OpenMBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterInfo[i] = this.buildParameter(i, parameterTypes[i]);
        }
        OpenType openType = MXBeanUtils.getOpenType(method.getGenericReturnType());
        return new OpenMBeanOperationInfoSupport(method.getName(), method.getName(), parameterInfo, openType, 1);
    }

    private OpenMBeanInfoSupport buildMBeanInfo(OpenMBeanAttributeInfo[] attributes, OpenMBeanConstructorInfo[] constructors, OpenMBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) throws Exception {
        return new OpenMBeanInfoSupport(this.mbeanClass.getName(), this.mbeanClass.getName(), attributes, constructors, operations, notifications);
    }

    private boolean isBooleanReturn(Type returnType) {
        return returnType == Boolean.TYPE;
    }

    private String getSignatureString(Method method) {
        String name = method.getName();
        Class<?>[] signature = method.getParameterTypes();
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(name);
        buffer.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                buffer.append(signature[i].getName());
                if (i >= signature.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

