/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.ejb;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.integration.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossEJBDescriptorAdaptor<T>
implements EjbDescriptor<T> {
    private final Class<T> type;
    private final String ejbName;

    public JBossEJBDescriptorAdaptor(JBossEnterpriseBeanMetaData enterpriseBeanMetaData, DeploymentUnit deploymentUnit, EjbReferenceResolver resolver) {
        try {
            this.type = Reflections.classForName(enterpriseBeanMetaData.getEjbClass(), deploymentUnit.getClassLoader());
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Error loading EJB Session bean class", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load EJB Session bean class", e);
        }
        this.ejbName = enterpriseBeanMetaData.getEjbName();
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getEjbName());
        if (this.isStateful()) {
            builder.append(" (SFSB)");
        }
        if (this.isStateless()) {
            builder.append(" (SLSB)");
        }
        if (this.isSingleton()) {
            builder.append(" (Singleton)");
        }
        if (this.isMessageDriven()) {
            builder.append(" (MDB)");
        }
        builder.append("; BeanClass: " + this.getType() + "; Local Business Interfaces: " + this.getLocalBusinessInterfaces());
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof EjbDescriptor) {
            EjbDescriptor that = (EjbDescriptor)other;
            return this.getEjbName().equals(that.getEjbName());
        }
        return false;
    }

    public int hashCode() {
        return this.getEjbName().hashCode();
    }
}

