/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.GenericAnnotationResourceVisitor;
import org.jboss.deployers.plugins.annotations.ScopedGenericAnnotationDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredGenericAnnotationDeployer
extends ScopedGenericAnnotationDeployer {
    private ResourceFilter resourceFilter;
    private ResourceFilter recurseFilter;

    protected <T> T getFilter(DeploymentUnit unit, Class<T> expectedClass, String suffix, T defaultValue) {
        String name = expectedClass.getName() + "." + (suffix != null ? suffix : "");
        Object result = unit.getAttachment(name, expectedClass);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    @Override
    protected void visitModule(DeploymentUnit unit, Module module, GenericAnnotationResourceVisitor visitor) {
        ResourceFilter filter = this.getFilter(unit, ResourceFilter.class, "resource", this.resourceFilter);
        if (filter == null) {
            filter = visitor.getFilter();
        }
        ResourceFilter recurse = this.getFilter(unit, ResourceFilter.class, "recurse", this.recurseFilter);
        module.visit((ResourceVisitor)visitor, filter, recurse, this.getUrls(unit));
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setRecurseFilter(ResourceFilter recurseFilter) {
        this.recurseFilter = recurseFilter;
    }
}

