/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.rewrite;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.web.rewrite.Resolver;
import org.jboss.web.rewrite.RewriteMap;
import org.jboss.web.rewrite.Substitution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteCond {
    protected String testString = null;
    protected String condPattern = null;
    protected boolean positive = true;
    protected Substitution test = null;
    protected ThreadLocal<Condition> condition = new ThreadLocal();
    public boolean nocase = false;
    public boolean ornext = false;

    public String getCondPattern() {
        return this.condPattern;
    }

    public void setCondPattern(String condPattern) {
        this.condPattern = condPattern;
    }

    public String getTestString() {
        return this.testString;
    }

    public void setTestString(String testString) {
        this.testString = testString;
    }

    public void parse(Map<String, RewriteMap> maps) {
        this.test = new Substitution();
        this.test.setSub(this.testString);
        this.test.parse(maps);
        if (this.condPattern.startsWith("!")) {
            this.positive = false;
            this.condPattern = this.condPattern.substring(1);
        }
        if (this.condPattern.startsWith("<")) {
            LexicalCondition condition = new LexicalCondition();
            condition.type = -1;
            condition.condition = this.condPattern.substring(1);
        } else if (this.condPattern.startsWith(">")) {
            LexicalCondition condition = new LexicalCondition();
            condition.type = 1;
            condition.condition = this.condPattern.substring(1);
        } else if (this.condPattern.startsWith("=")) {
            LexicalCondition condition = new LexicalCondition();
            condition.type = 0;
            condition.condition = this.condPattern.substring(1);
        } else if (this.condPattern.equals("-d")) {
            ResourceCondition ncondition = new ResourceCondition();
            ncondition.type = 0;
        } else if (this.condPattern.equals("-f")) {
            ResourceCondition ncondition = new ResourceCondition();
            ncondition.type = 1;
        } else if (this.condPattern.equals("-s")) {
            ResourceCondition ncondition = new ResourceCondition();
            ncondition.type = 2;
        } else {
            PatternCondition condition = new PatternCondition();
            int flags = 0;
            if (this.isNocase()) {
                flags |= 2;
            }
            condition.pattern = Pattern.compile(this.condPattern, flags);
        }
    }

    public Matcher getMatcher() {
        Condition condition = this.condition.get();
        if (condition instanceof PatternCondition) {
            return ((PatternCondition)condition).matcher;
        }
        return null;
    }

    public String toString() {
        return "RewriteCond " + this.testString + " " + this.condPattern;
    }

    public boolean evaluate(Matcher rule, Matcher cond, Resolver resolver) {
        Condition condition;
        String value = this.test.evaluate(rule, cond, resolver);
        if (this.nocase) {
            value = value.toLowerCase();
        }
        if ((condition = this.condition.get()) == null) {
            if (this.condPattern.startsWith("<")) {
                LexicalCondition ncondition = new LexicalCondition();
                ncondition.type = -1;
                ncondition.condition = this.condPattern.substring(1);
                condition = ncondition;
            } else if (this.condPattern.startsWith(">")) {
                LexicalCondition ncondition = new LexicalCondition();
                ncondition.type = 1;
                ncondition.condition = this.condPattern.substring(1);
                condition = ncondition;
            } else if (this.condPattern.startsWith("=")) {
                LexicalCondition ncondition = new LexicalCondition();
                ncondition.type = 0;
                ncondition.condition = this.condPattern.substring(1);
                condition = ncondition;
            } else if (this.condPattern.equals("-d")) {
                ResourceCondition ncondition = new ResourceCondition();
                ncondition.type = 0;
                condition = ncondition;
            } else if (this.condPattern.equals("-f")) {
                ResourceCondition ncondition = new ResourceCondition();
                ncondition.type = 1;
                condition = ncondition;
            } else if (this.condPattern.equals("-s")) {
                ResourceCondition ncondition = new ResourceCondition();
                ncondition.type = 2;
                condition = ncondition;
            } else {
                PatternCondition ncondition = new PatternCondition();
                int flags = 0;
                if (this.isNocase()) {
                    flags |= 2;
                }
                ncondition.pattern = Pattern.compile(this.condPattern, flags);
                condition = ncondition;
            }
            this.condition.set(condition);
        }
        if (this.positive) {
            return condition.evaluate(value, resolver);
        }
        return !condition.evaluate(value, resolver);
    }

    public boolean isNocase() {
        return this.nocase;
    }

    public void setNocase(boolean nocase) {
        this.nocase = nocase;
    }

    public boolean isOrnext() {
        return this.ornext;
    }

    public void setOrnext(boolean ornext) {
        this.ornext = ornext;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public void setPositive(boolean positive) {
        this.positive = positive;
    }

    public class ResourceCondition
    extends Condition {
        public int type;

        public ResourceCondition() {
            this.type = 0;
        }

        public boolean evaluate(String value, Resolver resolver) {
            switch (this.type) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }
    }

    public class LexicalCondition
    extends Condition {
        public int type;
        public String condition;

        public LexicalCondition() {
            this.type = 0;
        }

        public boolean evaluate(String value, Resolver resolver) {
            int result = value.compareTo(this.condition);
            switch (this.type) {
                case -1: {
                    return result < 0;
                }
                case 0: {
                    return result == 0;
                }
                case 1: {
                    return result > 0;
                }
            }
            return false;
        }
    }

    public class PatternCondition
    extends Condition {
        public Pattern pattern;
        public Matcher matcher;

        public PatternCondition() {
            this.matcher = null;
        }

        public boolean evaluate(String value, Resolver resolver) {
            Matcher m = this.pattern.matcher(value);
            if (m.matches()) {
                this.matcher = m;
                return true;
            }
            return false;
        }
    }

    public abstract class Condition {
        public abstract boolean evaluate(String var1, Resolver var2);
    }
}

