/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.test;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.test.AbstractManagedComponentTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxConnectionFactoryTest
extends AbstractManagedComponentTest {
    private static final String TEMPLATE_NAME = "TxConnectionFactoryTemplate";
    private static final ComponentType COMPONENT_TYPE = KnownComponentTypes.ConnectionFactoryTypes.XA.getType();

    public TxConnectionFactoryTest(ProfileServiceConnection connection) {
        super(connection);
    }

    public void testCreateValid() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Map properties = template.getProperties();
        this.setKnownRequiredProperties(componentName, properties);
        ManagedComponent component = this.createComponent(COMPONENT_TYPE, componentName, template);
        assert (component.getProperty("jndi-name").getValue().equals(new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)componentName))));
        this.managementView.removeComponent(component);
    }

    public void testCreateNonMandatoryPropertiesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> nonMandatoryProperties = this.getNonMandatoryProperties(template);
        for (ManagedProperty nonMandatoryProperty : nonMandatoryProperties) {
            template.getProperties().remove(nonMandatoryProperty.getName());
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        ManagedComponent component = this.createComponent(COMPONENT_TYPE, componentName, template);
        this.managementView.removeComponent(component);
    }

    public void testCreateNonMandatoryPropertyValuesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> nonMandatoryProperties = this.getNonMandatoryProperties(template);
        for (ManagedProperty nonMandatoryProperty : nonMandatoryProperties) {
            nonMandatoryProperty.setValue(null);
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        ManagedComponent component = this.createComponent(COMPONENT_TYPE, componentName, template);
        this.managementView.removeComponent(component);
    }

    public void testCreateNonMandatoryPropertyInnerValuesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> nonMandatoryProperties = this.getNonMandatoryProperties(template);
        for (ManagedProperty nonMandatoryProperty : nonMandatoryProperties) {
            MetaValue value = nonMandatoryProperty.getValue();
            if (value instanceof SimpleValueSupport) {
                SimpleValueSupport simpleValueSupport = (SimpleValueSupport)value;
                simpleValueSupport.setValue(null);
                continue;
            }
            if (!(value instanceof EnumValueSupport)) continue;
            EnumValueSupport enumValueSupport = (EnumValueSupport)value;
            enumValueSupport.setValue(null);
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        ManagedComponent component = this.createComponent(COMPONENT_TYPE, componentName, template);
        this.managementView.removeComponent(component);
    }

    public void testCreateMandatoryPropertiesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> mandatoryProperties = this.getMandatoryProperties(template);
        for (ManagedProperty mandatoryProperty : mandatoryProperties) {
            template.getProperties().remove(mandatoryProperty.getName());
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        this.createComponentWithFailureExpected(COMPONENT_TYPE, componentName, template);
    }

    public void testCreateMandatoryPropertyValuesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> mandatoryProperties = this.getMandatoryProperties(template);
        for (ManagedProperty mandatoryProperty : mandatoryProperties) {
            mandatoryProperty.setValue(null);
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        this.createComponentWithFailureExpected(COMPONENT_TYPE, componentName, template);
    }

    public void testCreateMandatoryPropertyInnerValuesNull() throws Exception {
        String componentName = UUID.randomUUID().toString();
        DeploymentTemplateInfo template = this.managementView.getTemplate(TEMPLATE_NAME);
        Set<ManagedProperty> mandatoryProperties = this.getMandatoryProperties(template);
        for (ManagedProperty mandatoryProperty : mandatoryProperties) {
            MetaValue value = mandatoryProperty.getValue();
            if (value instanceof SimpleValueSupport) {
                SimpleValueSupport simpleValueSupport = (SimpleValueSupport)value;
                simpleValueSupport.setValue(null);
                continue;
            }
            if (!(value instanceof EnumValueSupport)) continue;
            EnumValueSupport enumValueSupport = (EnumValueSupport)value;
            enumValueSupport.setValue(null);
        }
        this.setKnownRequiredProperties(componentName, template.getProperties());
        this.createComponentWithFailureExpected(COMPONENT_TYPE, componentName, template);
    }

    private void setKnownRequiredProperties(String componentName, Map<String, ManagedProperty> properties) {
        this.setSimpleStringProperty(properties, "jndi-name", componentName);
        this.setSimpleStringProperty(properties, "rar-name", "jms-ra.rar");
        this.setSimpleStringProperty(properties, "connection-definition", "org.jboss.resource.adapter.jms.JmsConnectionFactory");
    }
}

