/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.definition;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.definition.PortalContainerDefinition;
import org.exoplatform.container.definition.PortalContainerDefinitionPlugin;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalContainerConfig
implements Startable {
    private static final Log log = ExoLogger.getLogger(PortalContainerConfig.class);
    public static final String PORTAL_CONTAINER_SETTING_NAME = "name";
    public static final String REST_CONTEXT_SETTING_NAME = "rest";
    public static final String REALM_SETTING_NAME = "realm";
    public static final String DEFAULT_PORTAL_CONTAINER_NAME = new String("portal");
    public static final String DEFAULT_REST_CONTEXT_NAME = new String("rest");
    public static final String DEFAULT_REALM_NAME = new String("exo-domain");
    private final PortalContainerDefinition defaultDefinition;
    private volatile boolean initialized;
    private List<String> portalContainerNames;
    private Map<String, List<String>> scopes;
    private Map<String, PortalContainerDefinition> definitions = Collections.unmodifiableMap(new HashMap());
    private final ConfigurationManager cm;
    private final J2EEServerInfo serverInfo;
    private final PropertyConfigurator pc;

    public PortalContainerConfig(ConfigurationManager cm) {
        this(null, cm, new J2EEServerInfo(), null);
    }

    public PortalContainerConfig(ConfigurationManager cm, PropertyConfigurator pc) {
        this(null, cm, new J2EEServerInfo(), pc);
    }

    public PortalContainerConfig(ConfigurationManager cm, J2EEServerInfo serverInfo) {
        this(null, cm, serverInfo, null);
    }

    public PortalContainerConfig(ConfigurationManager cm, J2EEServerInfo serverInfo, PropertyConfigurator pc) {
        this(null, cm, serverInfo, pc);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm) {
        this(params, cm, new J2EEServerInfo(), null);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, PropertyConfigurator pc) {
        this(params, cm, new J2EEServerInfo(), pc);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, J2EEServerInfo serverInfo) {
        this(params, cm, serverInfo, null);
    }

    public PortalContainerConfig(InitParams params, ConfigurationManager cm, J2EEServerInfo serverInfo, PropertyConfigurator pc) {
        this.pc = pc;
        this.cm = cm;
        this.serverInfo = serverInfo;
        this.defaultDefinition = this.create(params);
    }

    private PortalContainerDefinition create(InitParams params) {
        ObjectParameter oDpd = null;
        if (params != null) {
            oDpd = params.getObjectParam("default.portal.definition");
        }
        PortalContainerDefinition def = null;
        if (oDpd != null) {
            Object o = oDpd.getObject();
            if (o instanceof PortalContainerDefinition) {
                def = (PortalContainerDefinition)o;
            } else {
                log.warn((Object)("The object parameter 'default.portal.definition' should be of type " + PortalContainerDefinition.class));
            }
        }
        if (def == null) {
            def = new PortalContainerDefinition();
        }
        this.initName(params, def);
        this.initRestContextName(params, def);
        this.initRealmName(params, def);
        this.initializeSettings(def, false);
        return def;
    }

    private void initRealmName(InitParams params, PortalContainerDefinition def) {
        if (def.getRealmName() == null || def.getRealmName().trim().length() == 0) {
            def.setRealmName(DEFAULT_REALM_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.realm.name");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setRealmName(vp.getValue().trim());
            }
        } else {
            def.setRealmName(def.getRealmName().trim());
        }
    }

    private void initRestContextName(InitParams params, PortalContainerDefinition def) {
        if (def.getRestContextName() == null || def.getRestContextName().trim().length() == 0) {
            def.setRestContextName(DEFAULT_REST_CONTEXT_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.rest.context");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setRestContextName(vp.getValue().trim());
            }
        } else {
            def.setRestContextName(def.getRestContextName().trim());
        }
    }

    private void initName(InitParams params, PortalContainerDefinition def) {
        if (def.getName() == null || def.getName().trim().length() == 0) {
            def.setName(DEFAULT_PORTAL_CONTAINER_NAME);
            if (params == null) {
                return;
            }
            ValueParam vp = params.getValueParam("default.portal.container");
            if (vp != null && vp.getValue().trim().length() > 0) {
                def.setName(vp.getValue().trim());
            }
        } else {
            def.setName(def.getName().trim());
        }
    }

    public String getDefaultPortalContainer() {
        return this.defaultDefinition.getName();
    }

    public String getDefaultRestContext() {
        return this.defaultDefinition.getRestContextName();
    }

    public String getDefaultRealmName() {
        return this.defaultDefinition.getRealmName();
    }

    public boolean hasDefinition() {
        return !this.definitions.isEmpty();
    }

    public synchronized void registerPortalContainerName(String name) {
        if (!this.portalContainerNames.contains(name)) {
            ArrayList<String> lPortalContainerNames = new ArrayList<String>(this.portalContainerNames.size() + 1);
            lPortalContainerNames.add(name);
            lPortalContainerNames.addAll(this.portalContainerNames);
            this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        }
    }

    public synchronized void unregisterPortalContainerName(String name) {
        if (this.portalContainerNames.contains(name)) {
            ArrayList<String> lPortalContainerNames = new ArrayList<String>(this.portalContainerNames);
            lPortalContainerNames.remove(name);
            this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        }
    }

    public boolean isPortalContainerName(String name) {
        return name == null ? false : this.portalContainerNames.contains(name);
    }

    public List<String> getPortalContainerNames(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            String portalContainerName = this.portalContainerNames.contains(contextName) ? contextName : this.defaultDefinition.getName();
            return Collections.singletonList(portalContainerName);
        }
        return result;
    }

    public String getPortalContainerName(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        if (this.portalContainerNames.contains(contextName)) {
            return contextName;
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            return this.defaultDefinition.getName();
        }
        return result.get(0);
    }

    public List<String> getDependencies(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        List<String> result = null;
        if (definition != null) {
            result = definition.getDependencies();
        }
        return result == null ? this.defaultDefinition.getDependencies() : result;
    }

    public Object getSetting(String portalContainerName, String settingName) {
        Map<String, Object> settings;
        if (settingName == null) {
            throw new IllegalArgumentException("The setting name cannot be null");
        }
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition != null && (settings = definition.getSettings()) != null) {
            return settings.get(settingName);
        }
        Map<String, Object> defaultSettings = this.defaultDefinition.getSettings();
        return defaultSettings == null ? null : defaultSettings.get(settingName);
    }

    public String getRestContextName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultDefinition.getRestContextName();
        }
        String contextName = definition.getRestContextName();
        return contextName == null ? this.defaultDefinition.getRestContextName() : contextName;
    }

    public String getRealmName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultDefinition.getRealmName();
        }
        String realmName = definition.getRealmName();
        return realmName == null ? this.defaultDefinition.getRealmName() : realmName;
    }

    public boolean isScopeValid(String portalContainerName, String contextName) {
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            return true;
        }
        return result.contains(portalContainerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(PortalContainerDefinitionPlugin plugin) {
        List<PortalContainerDefinition> lDefs = plugin.getPortalContainerDefinitions();
        if (lDefs != null && !lDefs.isEmpty()) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    throw new IllegalStateException("The PortalContainerConfig has already been initialized");
                }
                HashMap<String, PortalContainerDefinition> tempDefinitions = new HashMap<String, PortalContainerDefinition>(this.definitions);
                for (PortalContainerDefinition def : lDefs) {
                    String name = def.getName();
                    if (name == null || (name = name.trim()).length() == 0) {
                        log.warn((Object)"A PortalContainerDefinition cannot have an empty name");
                        continue;
                    }
                    def.setName(name);
                    tempDefinitions.put(name, def);
                }
                this.definitions = Collections.unmodifiableMap(tempDefinitions);
            }
        }
    }

    private void registerDependencies(PortalContainerDefinition definition, Map<String, List<String>> scopes) {
        List<String> dependencies = definition.getDependencies();
        if ((dependencies == null || dependencies.isEmpty()) && ((dependencies = this.defaultDefinition.getDependencies()) == null || dependencies.isEmpty())) {
            return;
        }
        for (String context : dependencies) {
            if (context == null || (context = context.trim()).length() == 0) continue;
            List<String> lPortalContainerNames = scopes.get(context);
            lPortalContainerNames = lPortalContainerNames == null ? new ArrayList<String>() : new ArrayList<String>(lPortalContainerNames);
            lPortalContainerNames.add(definition.getName());
            scopes.put(context, Collections.unmodifiableList(lPortalContainerNames));
        }
    }

    private void initializeSettings(PortalContainerDefinition def, boolean addDefaultSettings) {
        PortalContainerDefinition[] defs = addDefaultSettings ? new PortalContainerDefinition[]{this.defaultDefinition, def} : new PortalContainerDefinition[]{def};
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.loadInternalSettings(defs, settings);
        if (this.pc != null) {
            this.resolveInternalSettings(settings);
        }
        LinkedHashMap<String, String> externalSettings = new LinkedHashMap<String, String>();
        this.loadExternalSettings(def, defs, externalSettings);
        if (!externalSettings.isEmpty()) {
            this.resolveExternalSettings(def, settings, externalSettings);
            this.mergeSettings(settings, externalSettings);
        }
        settings.putAll(this.getMainSettings(def));
        def.setSettings(Collections.unmodifiableMap(settings));
    }

    private void resolveExternalSettings(PortalContainerDefinition def, Map<String, Object> settings, Map<String, String> externalSettings) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        ctx.putAll(settings);
        ctx.putAll(externalSettings);
        ctx.putAll(this.getMainSettings(def));
        for (Map.Entry<String, String> entry : externalSettings.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            propertyValue = Deserializer.resolveVariables(propertyValue, ctx);
            externalSettings.put(propertyName, propertyValue);
            ctx.put(propertyName, propertyValue);
        }
    }

    private void loadExternalSettings(PortalContainerDefinition def, PortalContainerDefinition[] defs, Map<String, String> externalSettings) {
        for (PortalContainerDefinition pcd : defs) {
            Map<String, String> props;
            String path = pcd.getExternalSettingsPath();
            if (path == null || (path = path.trim()).length() <= 0 || (props = this.loadExternalSettings(path, this.defaultDefinition == null || pcd == this.defaultDefinition, def)) == null || props.isEmpty()) continue;
            externalSettings.putAll(props);
        }
    }

    private void resolveInternalSettings(Map<String, Object> settings) {
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (!(propertyValue instanceof String)) continue;
            propertyValue = Deserializer.resolveVariables((String)propertyValue);
            settings.put(propertyName, propertyValue);
        }
    }

    private void loadInternalSettings(PortalContainerDefinition[] defs, Map<String, Object> settings) {
        for (PortalContainerDefinition pcd : defs) {
            Map<String, Object> tmpSettings = pcd.getSettings();
            if (tmpSettings == null || tmpSettings.isEmpty()) continue;
            settings.putAll(tmpSettings);
        }
    }

    private Map<String, String> getMainSettings(PortalContainerDefinition def) {
        HashMap<String, String> settings = new HashMap<String, String>(3);
        settings.put(PORTAL_CONTAINER_SETTING_NAME, def.getName());
        settings.put(REST_CONTEXT_SETTING_NAME, def.getRestContextName() == null ? this.defaultDefinition.getRestContextName() : def.getRestContextName());
        settings.put(REALM_SETTING_NAME, def.getRealmName() == null ? this.defaultDefinition.getRealmName() : def.getRealmName());
        return settings;
    }

    private Map<String, String> loadExternalSettings(String path, boolean isPath4DefaultPCD, PortalContainerDefinition def) {
        try {
            String fullPath;
            File file;
            URL url = null;
            if (path.indexOf(58) == -1 && (file = new File(fullPath = this.serverInfo.getExoConfigurationDirectory() + "/portal/" + (isPath4DefaultPCD ? "" : def.getName() + "/") + path)).exists()) {
                url = file.toURI().toURL();
            }
            if (url == null) {
                url = this.cm.getURL(path);
            }
            return ContainerUtil.loadProperties(url, false);
        }
        catch (Exception e) {
            log.error((Object)("Cannot load property file " + path), (Throwable)e);
            return null;
        }
    }

    private void mergeSettings(Map<String, Object> settings, Map<String, String> props) {
        if (settings.isEmpty()) {
            settings.putAll(props);
        } else {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String propertyName = entry.getKey();
                Object propertyValue = entry.getValue();
                if ((propertyValue = Deserializer.resolveString((String)propertyValue)) == null) continue;
                Object oldValue = settings.get(propertyName);
                if (oldValue != null) {
                    Method m;
                    block9: {
                        m = null;
                        try {
                            m = oldValue.getClass().getMethod("valueOf", String.class);
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug((Object)("The static method valueOf(String) cannot be found for the class " + oldValue.getClass()), (Throwable)e);
                        }
                    }
                    if (m != null) {
                        String sPropertyValue = ((String)propertyValue).trim();
                        if (sPropertyValue.length() == 0) continue;
                        try {
                            propertyValue = m.invoke(null, propertyValue);
                        }
                        catch (Exception e) {
                            log.error((Object)("Cannot convert the value '" + propertyValue + "' to an Object of type " + oldValue.getClass()), (Throwable)e);
                            continue;
                        }
                    }
                }
                settings.put(propertyName, propertyValue);
            }
        }
    }

    private void initialize(Map<String, PortalContainerDefinition> mDefinitions) {
        ArrayList<String> lPortalContainerNames = new ArrayList<String>(mDefinitions.size() + 1);
        lPortalContainerNames.add(this.defaultDefinition.getName());
        HashMap<String, List<String>> mScopes = new HashMap<String, List<String>>();
        for (Map.Entry<String, PortalContainerDefinition> entry : mDefinitions.entrySet()) {
            PortalContainerDefinition definition = entry.getValue();
            String name = definition.getName();
            boolean hasChanged = false;
            if (!name.equals(this.defaultDefinition.getName())) {
                if (this.defaultDefinition.getName() == DEFAULT_PORTAL_CONTAINER_NAME) {
                    this.defaultDefinition.setName(name);
                    hasChanged = true;
                }
                lPortalContainerNames.add(name);
            }
            if (this.defaultDefinition.getRestContextName() == DEFAULT_REST_CONTEXT_NAME && definition.getRestContextName() != null && definition.getRestContextName().trim().length() > 0) {
                this.defaultDefinition.setRestContextName(definition.getRestContextName().trim());
                hasChanged = true;
            }
            if (this.defaultDefinition.getRealmName() == DEFAULT_REALM_NAME && definition.getRealmName() != null && definition.getRealmName().trim().length() > 0) {
                this.defaultDefinition.setRealmName(definition.getRealmName().trim());
                hasChanged = true;
            }
            this.registerDependencies(definition, mScopes);
            if (hasChanged) {
                this.initializeSettings(this.defaultDefinition, false);
            }
            this.initializeSettings(definition, true);
        }
        this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        this.scopes = Collections.unmodifiableMap(mScopes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    return;
                }
                this.initialized = true;
            }
        } else {
            return;
        }
        this.initialize(this.definitions);
    }

    public void stop() {
    }
}

