/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.swing.Workspaces;

public class ListOpenedFileViewPlugin
extends JPanel
implements ViewPlugin {
    public ListOpenedFileViewPlugin() {
        this.setLayout(new BorderLayout());
        this.setName("ListOpenedFiles");
        this.setPreferredSize(new Dimension(200, 500));
        this.setMinimumSize(new Dimension(200, 400));
        AbstractAction actionWSQA = new AbstractAction("WSQA"){

            public void actionPerformed(ActionEvent ae) {
                System.out.println("a");
            }
        };
        AbstractAction actionLog = new AbstractAction("Log"){

            public void actionPerformed(ActionEvent ae) {
                System.out.println("a");
            }
        };
        AbstractAction actionText = new AbstractAction("Text"){

            public void actionPerformed(ActionEvent ae) {
                System.out.println("a");
            }
        };
        SmallButton btnWSQA = new SmallButton(actionWSQA);
        SmallButton btnLog = new SmallButton(actionLog);
        SmallButton btnText = new SmallButton(actionText);
        btnWSQA.setHorizontalAlignment(2);
        btnLog.setHorizontalAlignment(2);
        btnText.setHorizontalAlignment(2);
        JPanel pnlTop = new JPanel(new GridLayout(4, 1));
        pnlTop.add(btnWSQA);
        pnlTop.add(btnLog);
        pnlTop.add(btnText);
        this.add((Component)pnlTop, "First");
        JPanel pnlDown = new JPanel();
        final JButton btnShowHide = new JButton("Hide All");
        JButton btnCascade = new JButton("Cascade");
        pnlDown.add(btnShowHide);
        pnlDown.add(btnCascade);
        this.add((Component)pnlDown, "South");
        btnShowHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int i;
                Workspaces workspaces = Application.getInstance().getWorkspaces();
                Map<String, Workspaces.ViewFrame> frames = workspaces.getOpenFrames();
                Object[] objFrames = frames.values().toArray();
                Workspaces.ViewFrame[] viewFrames = new Workspaces.ViewFrame[objFrames.length];
                System.out.println("open frame: " + objFrames.length);
                for (i = 0; i < objFrames.length; ++i) {
                    viewFrames[i] = (Workspaces.ViewFrame)objFrames[i];
                }
                if (btnShowHide.getText().equalsIgnoreCase("Hide All")) {
                    for (i = 0; i < objFrames.length; ++i) {
                        try {
                            ListOpenedFileViewPlugin.this.minimizeFrame(viewFrames[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    btnShowHide.setText("Show All");
                } else {
                    for (i = 0; i < objFrames.length; ++i) {
                        try {
                            ListOpenedFileViewPlugin.this.maximizeFrame(viewFrames[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    btnShowHide.setText("Hide All");
                }
            }
        });
        btnCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Workspaces workspaces = Application.getInstance().getWorkspaces();
                Map<String, Workspaces.ViewFrame> frames = workspaces.getOpenFrames();
                Object[] objFrames = frames.values().toArray();
                Workspaces.ViewFrame[] viewFrames = new Workspaces.ViewFrame[objFrames.length];
                for (int i = 0; i < objFrames.length; ++i) {
                    viewFrames[i] = (Workspaces.ViewFrame)objFrames[i];
                    if (!viewFrames[i].isVisible()) continue;
                    viewFrames[i].setLocation(15 * i, 20 * i);
                    viewFrames[i].toFront();
                }
            }
        });
    }

    public void minimizeFrame(JInternalFrame frame) throws Exception {
        frame.setIcon(true);
    }

    public void maximizeFrame(JInternalFrame frame) throws Exception {
        frame.setVisible(true);
        frame.setIcon(false);
    }

    public String getTitle() {
        return "Open  Files";
    }

    class SmallButton
    extends JButton
    implements MouseListener {
        protected Border m_inactive;
        protected Border m_border;
        protected Border m_lowered;
        protected Border m_raised;
        protected Insets m_ins;

        public SmallButton() {
            this.m_border = this.m_inactive = new EmptyBorder(3, 3, 3, 3);
            this.m_lowered = new SoftBevelBorder(1);
            this.m_raised = new SoftBevelBorder(0);
            this.m_ins = new Insets(4, 4, 4, 4);
            this.setBorder(this.m_inactive);
            this.setMargin(this.m_ins);
            this.setRequestFocusEnabled(false);
            this.addMouseListener(this);
        }

        public SmallButton(Action act) {
            this();
            this.setAction(act);
            this.setRequestFocusEnabled(false);
            this.addMouseListener(this);
        }

        public float getAlignmentY() {
            return 0.5f;
        }

        public Border getBorder() {
            return this.m_border;
        }

        public Insets getInsets() {
            return this.m_ins;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (this.isEnabled()) {
                this.m_border = this.m_raised;
                this.setBorder(this.m_raised);
            }
        }

        public void mouseExited(MouseEvent e) {
            this.m_border = this.m_inactive;
            this.setBorder(this.m_inactive);
        }

        public void mousePressed(MouseEvent e) {
            this.m_border = this.m_lowered;
            this.setBorder(this.m_lowered);
        }

        public void mouseReleased(MouseEvent e) {
            this.m_border = this.m_inactive;
            this.setBorder(this.m_inactive);
        }
    }
}

