/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestBody {
    protected String contentType_;
    protected int contentLength_;
    protected byte[] originalData_;

    public HttpRequestBody(String contentType) throws Exception {
        this.contentType_ = contentType;
    }

    public HttpRequestBody(String contentType, int contentLength, InputStream is) throws Exception {
        this.contentType_ = contentType;
        this.contentLength_ = contentLength;
        this.originalData_ = this.parse(is, contentLength);
    }

    public String getContentType() {
        return this.contentType_;
    }

    public int getContentLength() {
        return this.contentLength_;
    }

    public byte[] toBytes() {
        return this.originalData_;
    }

    public byte[] getOrgininalData() {
        return this.originalData_;
    }

    public Map<String, Parameter> getBodyParameters() {
        return null;
    }

    private byte[] parse(InputStream is, int bodySize) throws Exception {
        int read;
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        int totalRead = 0;
        byte[] buf = new byte[4092];
        while ((read = is.read(buf)) != -1) {
            body.write(buf, 0, read);
            if ((totalRead += read) < bodySize) continue;
            break;
        }
        if (totalRead != bodySize) {
            throw new Exception("Expect body size " + bodySize + ", but the total read " + totalRead);
        }
        this.originalData_ = body.toByteArray();
        return this.originalData_;
    }
}

