/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SendMailJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.SendMailJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        for (Object ct : dataMap.values()) {
            try {
                MailService mailService = (MailService)ExoContainerContext.getContainerByName((String)((String)ct)).getComponentInstanceOfType(MailService.class);
                if (mailService == null) {
                    log_.warn((Object)"\nThere is no MailService for sending notification via email...");
                    continue;
                }
                ForumService forumService = (ForumService)ExoContainerContext.getContainerByName((String)((String)ct)).getComponentInstanceOfType(ForumService.class);
                int countEmail = 0;
                Iterator<SendMessageInfo> iter = forumService.getPendingMessages();
                while (iter.hasNext()) {
                    try {
                        SendMessageInfo messageInfo = iter.next();
                        List<String> emailAddresses = messageInfo.getEmailAddresses();
                        Message message = messageInfo.getMessage();
                        if (message == null || emailAddresses == null || emailAddresses.size() <= 0) continue;
                        ArrayList<String> sentMessages = new ArrayList<String>();
                        for (String address : emailAddresses) {
                            if (sentMessages.contains(address)) continue;
                            message.setTo(address);
                            mailService.sendMessage(message);
                            sentMessages.add(address);
                            ++countEmail;
                        }
                    }
                    catch (Exception e) {
                    }
                }
                if (!log_.isInfoEnabled() || countEmail <= 0) continue;
                log_.info((Object)("\n\nEmail notifications has been sent to " + countEmail + " addresses"));
            }
            catch (Exception e) {
                log_.warn((Object)("\n\n Unable send email notification at container '" + ct + "' "));
            }
        }
    }
}

