/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

public abstract class AbstractSynchAdapter
implements SynchAdapter {
    protected static Logger log = Logger.getLogger(AbstractSynchAdapter.class);

    public long add(VirtualFile fileToAdd, VirtualFile tempRoot, String pathToFile) throws IOException {
        try {
            URL realURL = VFSUtils.getRealURL((VirtualFile)tempRoot);
            File rootDir = new File(realURL.toURI());
            File newFile = new File(rootDir, pathToFile);
            return AbstractSynchAdapter.copy(fileToAdd, newFile);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected static long copy(VirtualFile fileToAdd, File newFile) throws IOException {
        FileOutputStream out = new FileOutputStream(newFile);
        VFSUtils.copyStreamAndClose((InputStream)fileToAdd.openStream(), (OutputStream)out);
        return newFile.lastModified();
    }

    public boolean delete(VirtualFile fileToDelete) throws IOException {
        return fileToDelete.delete();
    }

    static class MergeException
    extends IOException {
        MergeException(VirtualFile dest, VirtualFile source, Exception cause) {
            super("Conflict merging files, dest: " + dest + ", source: " + source);
            this.initCause(cause);
        }
    }
}

