/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsInitializer {
    private static Logger log = Logger.getLogger(BindingsInitializer.class);
    private Map<String, ?> bindings;
    private Context ctx;

    public Map<String, ?> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, ?> bindings) {
        this.bindings = bindings;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void start() throws NamingException {
        log.debug("start");
        if (this.ctx != null && this.bindings != null) {
            for (Map.Entry<String, ?> entry : this.bindings.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                log.debug("Binding, key=" + key + ", value=" + value + ", type=" + value.getClass());
                Util.bind(this.ctx, key, value);
            }
        }
    }

    public void stop() throws NamingException {
        if (this.ctx != null && this.bindings != null) {
            for (String key : this.bindings.keySet()) {
                Util.unbind(this.ctx, key);
            }
        }
    }
}

