/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.mvcc.ReadCommittedNode;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeFactory<K, V>
implements NodeFactory<K, V> {
    protected CacheSPI<K, V> cache;
    protected boolean useVersionedNode;
    protected Configuration configuration;
    protected InvocationContextContainer invocationContextContainer;
    protected InterceptorChain interceptorChain;
    protected CommandsFactory commandsFactory;
    protected ComponentRegistry componentRegistry;
    protected DataContainer dataContainer;

    @Inject
    void injectComponentRegistry(ComponentRegistry componentRegistry, DataContainer dataContainer) {
        this.componentRegistry = componentRegistry;
        this.dataContainer = dataContainer;
    }

    @Inject
    public void injectDependencies(CacheSPI<K, V> cache, Configuration configuration, InvocationContextContainer invocationContextContainer, InterceptorChain interceptorChain, CommandsFactory commandsFactory) {
        this.cache = cache;
        this.configuration = configuration;
        this.invocationContextContainer = invocationContextContainer;
        this.interceptorChain = interceptorChain;
        this.commandsFactory = commandsFactory;
    }

    private NodeSPI<K, V> initializeNodeInvocationDelegate(UnversionedNode<K, V> internal) {
        internal.setDataLoaded(false);
        NodeSPI<K, V> nid = this.createNodeInvocationDelegate(internal, false);
        internal.setDelegate(nid);
        return nid;
    }

    @Override
    public NodeSPI<K, V> createNode(Fqn fqn, NodeSPI<K, V> parent, Map<K, V> data) {
        UnversionedNode<K, V> internal = this.createInternalNode(fqn.getLastElement(), fqn, parent, data);
        return this.initializeNodeInvocationDelegate(internal);
    }

    @Override
    public NodeSPI<K, V> createNode(Object childName, NodeSPI<K, V> parent, Map<K, V> data) {
        UnversionedNode<K, V> internal = this.createInternalNode(childName, Fqn.fromRelativeElements(parent.getFqn(), childName), parent, data);
        return this.initializeNodeInvocationDelegate(internal);
    }

    @Override
    public NodeSPI<K, V> createNode(Fqn fqn, NodeSPI<K, V> parent) {
        UnversionedNode<K, V> internal = this.createInternalNode(fqn.getLastElement(), fqn, parent, null);
        return this.initializeNodeInvocationDelegate(internal);
    }

    @Override
    public InternalNode<K, V> createInternalNode(Fqn fqn) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }

    @Override
    public NodeSPI<K, V> createNode(Object childName, NodeSPI<K, V> parent) {
        UnversionedNode<K, V> internal = this.createInternalNode(childName, Fqn.fromRelativeElements(parent.getFqn(), childName), parent, null);
        return this.initializeNodeInvocationDelegate(internal);
    }

    protected UnversionedNode<K, V> createInternalNode(Object childName, Fqn fqn, NodeSPI<K, V> parent, Map<K, V> data) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }

    @Override
    public WorkspaceNode<K, V> createWrappedNode(NodeSPI<K, V> dataNode, TransactionWorkspace workspace) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }

    @Override
    public ReadCommittedNode createWrappedNode(InternalNode<K, V> node, InternalNode<K, V> parent) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }

    @Override
    public ReadCommittedNode createWrappedNodeForRemoval(Fqn fqn, InternalNode<K, V> node, InternalNode<K, V> parent) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }

    @Override
    public NodeSPI<K, V> createRootNode() {
        return this.createNode(Fqn.ROOT, null);
    }

    private NodeSPI<K, V> createNodeInvocationDelegate(InternalNode<K, V> internalNode, boolean wrapWithNodeReference) {
        if (wrapWithNodeReference) {
            throw new UnsupportedOperationException("wrapWithNodeReferences is not supported in this impl!");
        }
        NodeInvocationDelegate<K, V> nid = new NodeInvocationDelegate<K, V>(internalNode);
        nid.initialize(this.configuration, this.invocationContextContainer, this.componentRegistry, this.interceptorChain);
        nid.injectDependencies(this.cache);
        return nid;
    }

    @Override
    public InternalNode<K, V> createChildNode(Fqn fqn, InternalNode<K, V> parent, InvocationContext ctx, boolean attachToParent) {
        throw new UnsupportedOperationException("Unsupported in this implementation (" + this.getClass().getSimpleName() + ")!");
    }
}

