/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.lock;

import java.io.Serializable;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.AbstractClusterLockSupport;
import org.jboss.ha.framework.server.lock.ClusterLockState;
import org.jboss.ha.framework.server.lock.LocalLockHandler;
import org.jboss.ha.framework.server.lock.RemoteLockResponse;

public class NonGloballyExclusiveClusterLockSupport
extends AbstractClusterLockSupport {
    public NonGloballyExclusiveClusterLockSupport(String serviceHAName, HAPartition partition, LocalLockHandler handler) {
        super(serviceHAName, partition, handler);
    }

    public void unlock(Serializable lockId) {
        ClusterNode myself = this.getLocalClusterNode();
        if (myself == null) {
            throw new IllegalStateException("Must call start() before first call to unlock()");
        }
        ClusterLockState lockState = this.getClusterLockState(lockId, false);
        if (lockState != null && myself.equals(lockState.getHolder())) {
            this.getLocalHandler().unlockFromCluster(lockId, myself);
            lockState.release();
            try {
                this.getPartition().callMethodOnCluster(this.getServiceHAName(), "releaseRemoteLock", new Object[]{lockId, myself}, RELEASE_REMOTE_LOCK_TYPES, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed releasing remote lock", e);
            }
        }
    }

    protected ClusterLockState getClusterLockState(Serializable categoryName) {
        return this.getClusterLockState(categoryName, true);
    }

    protected RemoteLockResponse yieldLock(ClusterLockState lockState, ClusterNode caller, long timeout) {
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.REJECT, lockState.getHolder());
    }

    protected RemoteLockResponse handleLockSuccess(ClusterLockState lockState, ClusterNode caller) {
        this.recordLockHolder(lockState, caller);
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
    }
}

