/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.OverviewURL;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.log4j.Logger;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;

public class ScoutJaxrUddiHelper {
    private static Logger log = Logger.getLogger((Class)(class$org$apache$ws$scout$util$ScoutJaxrUddiHelper == null ? (class$org$apache$ws$scout$util$ScoutJaxrUddiHelper = ScoutJaxrUddiHelper.class$("org.apache.ws.scout.util.ScoutJaxrUddiHelper")) : class$org$apache$ws$scout$util$ScoutJaxrUddiHelper));
    private static final String UDDI_ORG_TYPES = "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4";
    static /* synthetic */ Class class$org$apache$ws$scout$util$ScoutJaxrUddiHelper;

    public static Address getAddress(PostalAddress post) throws JAXRException {
        Address address = new Address();
        Vector<AddressLine> addvect = new Vector<AddressLine>();
        String stnum = post.getStreetNumber();
        String st = post.getStreet();
        String city = post.getCity();
        String country = post.getCountry();
        String code = post.getPostalCode();
        String state = post.getStateOrProvince();
        AddressLine stnumAL = new AddressLine();
        stnumAL.setKeyName("STREET_NUMBER");
        stnumAL.setKeyValue(stnum);
        AddressLine stAL = new AddressLine();
        stAL.setKeyName("STREET");
        stAL.setKeyValue(st);
        AddressLine cityAL = new AddressLine();
        cityAL.setKeyName("CITY");
        cityAL.setKeyValue(city);
        AddressLine countryAL = new AddressLine();
        countryAL.setKeyName("COUNTRY");
        countryAL.setKeyValue(country);
        AddressLine codeAL = new AddressLine();
        codeAL.setKeyName("POSTALCODE");
        codeAL.setKeyValue(code);
        AddressLine stateAL = new AddressLine();
        stateAL.setKeyName("STATE");
        stateAL.setKeyValue(state);
        addvect.add(stnumAL);
        addvect.add(stAL);
        addvect.add(cityAL);
        addvect.add(countryAL);
        addvect.add(codeAL);
        addvect.add(stateAL);
        address.setAddressLineVector(addvect);
        return address;
    }

    public static BindingTemplate getBindingTemplateFromJAXRSB(ServiceBinding serve) throws JAXRException {
        BindingTemplate bt = new BindingTemplate();
        if (serve.getKey() != null) {
            bt.setBindingKey(serve.getKey().getId());
        }
        try {
            Service svc;
            ServiceBinding sb;
            String accessuri = serve.getAccessURI();
            if (accessuri != null) {
                AccessPoint ap = new AccessPoint();
                ap.setURLType(ScoutJaxrUddiHelper.getURLType(accessuri));
                ap.setURL(accessuri);
                bt.setAccessPoint(ap);
            }
            if ((sb = serve.getTargetBinding()) != null) {
                HostingRedirector red = new HostingRedirector();
                Key key = sb.getKey();
                if (key != null) {
                    red.setBindingKey(key.getId());
                }
                bt.setHostingRedirector(red);
            }
            if ((svc = serve.getService()) != null) {
                bt.setServiceKey(svc.getKey().getId());
            }
            bt.addDescription(new Description(serve.getDescription().getValue()));
            Collection slcol = serve.getSpecificationLinks();
            TModelInstanceDetails tid = new TModelInstanceDetails();
            if (slcol != null && slcol.isEmpty()) {
                Iterator iter = slcol.iterator();
                while (iter.hasNext()) {
                    SpecificationLink slink = (SpecificationLink)iter.next();
                    TModelInstanceInfo tinfo = new TModelInstanceInfo();
                    tinfo.setTModelKey(slink.getSpecificationObject().getKey().getId());
                    tid.addTModelInstanceInfo(tinfo);
                }
                bt.setTModelInstanceDetails(tid);
            }
            log.debug((Object)("BindingTemplate=" + bt.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bt;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociation(Association assc) throws JAXRException {
        PublisherAssertion pa = new PublisherAssertion();
        try {
            pa.setFromKey(assc.getSourceObject().getKey().getId());
            pa.setToKey(assc.getTargetObject().getKey().getId());
            Concept c = assc.getAssociationType();
            String v = c.getValue();
            KeyedReference kr = new KeyedReference();
            Key key = c.getKey();
            if (key == null) {
                key = c.getClassificationScheme().getKey();
            }
            if (key != null) {
                kr.setTModelKey(key.getId());
            }
            kr.setKeyName("Concept");
            kr.setKeyValue(v);
            pa.setKeyedReference(kr);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociationKey(String key) throws JAXRException {
        PublisherAssertion pa = new PublisherAssertion();
        try {
            StringTokenizer token = new StringTokenizer(key, ":");
            if (token.hasMoreTokens()) {
                pa.setFromKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setToKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                KeyedReference kr = new KeyedReference();
                String str = ScoutJaxrUddiHelper.getToken(token.nextToken());
                if ("UUID".equals(str)) {
                    str = str + ":" + ScoutJaxrUddiHelper.getToken(token.nextToken());
                }
                kr.setTModelKey(str);
                kr.setKeyName(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                kr.setKeyValue(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setKeyedReference(kr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static BusinessService getBusinessServiceFromJAXRService(Service serve) throws JAXRException {
        BusinessService bs = new BusinessService();
        try {
            InternationalStringImpl iname = (InternationalStringImpl)serve.getName();
            String name = iname.getValue();
            bs.addName(new Name(name, Locale.getDefault().getLanguage()));
            bs.addDescription(new Description(serve.getDescription().getValue()));
            Organization o = serve.getProvidingOrganization();
            if (o != null) {
                Key k = o.getKey();
                if (k != null) {
                    bs.setBusinessKey(k.getId());
                }
            } else {
                throw new JAXRException("Service has no associated organization");
            }
            if (serve.getKey() != null) {
                bs.setServiceKey(serve.getKey().getId());
            }
            bs.setBindingTemplates(ScoutJaxrUddiHelper.getBindingTemplates(serve.getServiceBindings()));
            log.debug((Object)("BusinessService=" + bs.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bs;
    }

    public static TModel getTModelFromJAXRClassificationScheme(ClassificationScheme scheme) throws JAXRException {
        TModel tm = new TModel();
        try {
            Slot s;
            Key k = scheme.getKey();
            if (k != null) {
                tm.setTModelKey(k.getId());
            }
            if ((s = scheme.getSlot("authorizedName")) != null) {
                tm.setAuthorizedName(s.getName());
            }
            if ((s = scheme.getSlot("operator")) != null) {
                tm.setOperator(s.getName());
            }
            InternationalStringImpl iname = (InternationalStringImpl)scheme.getName();
            String name = iname.getValue();
            tm.setName(new Name(name, Locale.getDefault().getLanguage()));
            tm.addDescription(new Description(scheme.getDescription().getValue()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static TModel getTModelFromJAXRConcept(Concept scheme) throws JAXRException {
        TModel tm = new TModel();
        if (scheme == null) {
            return null;
        }
        try {
            Slot sl2;
            Slot sl1;
            Key key = scheme.getKey();
            if (key != null) {
                tm.setTModelKey(key.getId());
            }
            if ((sl1 = scheme.getSlot("authorizedName")) != null) {
                tm.setAuthorizedName(sl1.getName());
            }
            if ((sl2 = scheme.getSlot("operator")) != null) {
                tm.setOperator(sl2.getName());
            }
            InternationalStringImpl iname = (InternationalStringImpl)scheme.getName();
            String name = iname.getValue();
            tm.setName(new Name(name, Locale.getDefault().getLanguage()));
            tm.addDescription(new Description(scheme.getDescription().getValue()));
            Collection externalLinks = scheme.getExternalLinks();
            if (externalLinks != null && externalLinks.size() > 0) {
                tm.setOverviewDoc(ScoutJaxrUddiHelper.getOverviewDocFromExternalLink((ExternalLink)externalLinks.iterator().next()));
            }
            IdentifierBag idBag = new IdentifierBag();
            idBag.setKeyedReferenceVector(ScoutJaxrUddiHelper.getKeyedReferenceVector(scheme.getExternalIdentifiers()));
            tm.setIdentifierBag(idBag);
            Collection classifications = scheme.getClassifications();
            if (classifications != null && !classifications.isEmpty()) {
                tm.setCategoryBag(ScoutJaxrUddiHelper.getCategoryBagFromConcept());
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static BusinessEntity getBusinessEntityFromJAXROrg(Organization org) throws JAXRException {
        BusinessEntity biz = new BusinessEntity();
        BusinessServices bss = new BusinessServices();
        Vector<BusinessService> bvect = new Vector<BusinessService>();
        try {
            Key key = org.getKey();
            if (key != null) {
                biz.setBusinessKey(key.getId());
            }
            String language = Locale.getDefault().getLanguage();
            biz.addName(new Name(org.getName().getValue(), language));
            biz.addDescription(new Description(org.getDescription().getValue()));
            if (org.getPrimaryContact() != null) {
                biz.setAuthorizedName(org.getPrimaryContact().getPersonName().getFullName());
            }
            Collection s = org.getServices();
            log.debug((Object)("?Org has services=" + s.isEmpty()));
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                BusinessService bs = ScoutJaxrUddiHelper.getBusinessServiceFromJAXRService((Service)iter.next());
                bvect.add(bs);
            }
            Contacts cts = new Contacts();
            Vector<Contact> cvect = new Vector<Contact>();
            User primaryContact = org.getPrimaryContact();
            Collection users = org.getUsers();
            if (primaryContact != null) {
                Contact ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(primaryContact);
                cvect.add(ct);
            }
            Iterator it = users.iterator();
            while (it.hasNext()) {
                User u = (User)it.next();
                if (u == primaryContact) continue;
                Contact ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(u);
                cvect.add(ct);
            }
            bss.setBusinessServiceVector(bvect);
            cts.setContactVector(cvect);
            biz.setContacts(cts);
            biz.setBusinessServices(bss);
            Iterator exiter = org.getExternalLinks().iterator();
            while (exiter.hasNext()) {
                ExternalLink link = (ExternalLink)exiter.next();
                biz.addDiscoveryURL(new DiscoveryURL("businessEntityExt", link.getExternalURI()));
            }
            Collection exid = org.getExternalIdentifiers();
            Iterator exiditer = exid.iterator();
            while (exiditer.hasNext()) {
                ExternalIdentifier ei = (ExternalIdentifier)exiditer.next();
                KeyedReference keyr = new KeyedReference();
                Key ekey = ei.getKey();
                if (ekey != null) {
                    keyr.setTModelKey(ekey.getId());
                }
                keyr.setKeyValue(ei.getValue());
                keyr.setKeyName(ei.getName().getValue());
                biz.addIdentifier(keyr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return biz;
    }

    public static Contact getContactFromJAXRUser(User user) throws JAXRException {
        Contact ct = new Contact();
        if (user == null) {
            return ct;
        }
        Vector<Address> addvect = new Vector<Address>();
        Vector<Phone> phonevect = new Vector<Phone>();
        Vector<Email> emailvect = new Vector<Email>();
        try {
            ct.setPersonName(new PersonName(user.getPersonName().getFullName()));
            ct.setUseType(user.getType());
            Collection postc = user.getPostalAddresses();
            Iterator iterator = postc.iterator();
            while (iterator.hasNext()) {
                PostalAddress post = (PostalAddress)iterator.next();
                addvect.add(ScoutJaxrUddiHelper.getAddress(post));
            }
            Collection ph = user.getTelephoneNumbers(null);
            Iterator it = ph.iterator();
            while (it.hasNext()) {
                TelephoneNumber t = (TelephoneNumber)it.next();
                Phone phone = new Phone();
                String str = t.getNumber();
                log.debug((Object)("Telephone=" + str));
                phone.setValue(str);
                phonevect.add(phone);
            }
            Collection ec = user.getEmailAddresses();
            Iterator iter = ec.iterator();
            while (iter.hasNext()) {
                EmailAddress ea = (EmailAddress)iter.next();
                Email email = new Email();
                email.setValue(ea.getAddress());
                email.setUseType(ea.getType());
                emailvect.add(email);
            }
            ct.setAddressVector(addvect);
            ct.setPhoneVector(phonevect);
            ct.setEmailVector(emailvect);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return ct;
    }

    private static String getToken(String tokenstr) {
        if (tokenstr.equals("NULL")) {
            tokenstr = "";
        }
        return tokenstr;
    }

    private static String getURLType(String accessuri) {
        String acc = accessuri.toLowerCase();
        String uri = "other";
        if (acc.startsWith("http:")) {
            uri = "http";
        } else if (acc.startsWith("https:")) {
            uri = "https";
        } else if (acc.startsWith("ftp:")) {
            uri = "ftp";
        } else if (acc.startsWith("phone:")) {
            uri = "phone";
        }
        return uri;
    }

    private static OverviewDoc getOverviewDocFromExternalLink(ExternalLink link) throws JAXRException {
        InternationalString extDesc;
        OverviewDoc od = new OverviewDoc();
        String url = link.getExternalURI();
        if (url != null) {
            od.setOverviewURL(new OverviewURL(url));
        }
        if ((extDesc = link.getDescription()) != null) {
            od.addDescription(new Description(extDesc.getValue()));
        }
        return od;
    }

    private static Vector getKeyedReferenceVector(Collection externalIdentifiers) throws JAXRException {
        Vector<KeyedReference> krv = new Vector<KeyedReference>();
        if (externalIdentifiers != null) {
            Iterator iter = externalIdentifiers.iterator();
            while (iter.hasNext()) {
                KeyedReference kr = new KeyedReference();
                ExternalIdentifier eid = (ExternalIdentifier)iter.next();
                kr.setTModelKey(eid.getObjectType().getClassificationScheme().getKey().getId());
                kr.setKeyName(eid.getObjectType().getName().getValue());
                kr.setKeyValue(eid.getObjectType().getValue());
                krv.add(kr);
            }
        }
        return krv;
    }

    private static CategoryBag getCategoryBagFromConcept() {
        CategoryBag cbag = new CategoryBag();
        Vector<KeyedReference> krv = new Vector<KeyedReference>();
        KeyedReference kr = new KeyedReference();
        kr.setTModelKey(UDDI_ORG_TYPES);
        kr.setKeyValue("specification");
        krv.add(kr);
        cbag.setKeyedReferenceVector(krv);
        return cbag;
    }

    private static BindingTemplates getBindingTemplates(Collection serviceBindings) throws JAXRException {
        BindingTemplates bt = new BindingTemplates();
        if (serviceBindings != null) {
            Iterator iter = serviceBindings.iterator();
            while (iter.hasNext()) {
                ServiceBinding sb = (ServiceBinding)iter.next();
                bt.addBindingTemplate(ScoutJaxrUddiHelper.getBindingTemplate(sb));
            }
        }
        return bt;
    }

    private static BindingTemplate getBindingTemplate(ServiceBinding serviceBinding) throws JAXRException {
        BindingTemplate bt = new BindingTemplate();
        if (serviceBinding != null) {
            InternationalString desc;
            Key serviceKey;
            Key key;
            ServiceBinding sb;
            String accessURI = serviceBinding.getAccessURI();
            if (accessURI != null) {
                bt.setAccessPoint(ScoutJaxrUddiHelper.getAccessPoint(accessURI));
            }
            if ((sb = serviceBinding.getTargetBinding()) != null) {
                bt.setHostingRedirector(new HostingRedirector(accessURI));
            }
            if ((key = serviceBinding.getKey()) != null) {
                bt.setBindingKey(key.getId());
            }
            if ((serviceKey = serviceBinding.getService().getKey()) != null) {
                bt.setServiceKey(serviceKey.getId());
            }
            if ((desc = serviceBinding.getDescription()) != null) {
                Vector<Description> dvect = new Vector<Description>();
                dvect.add(new Description(desc.getValue()));
                bt.setDescriptionVector(dvect);
            }
        }
        return bt;
    }

    private static AccessPoint getAccessPoint(String accessURI) {
        String type = "other";
        String temp = accessURI.toLowerCase();
        if (temp.startsWith("https")) {
            type = "https";
        } else if (temp.startsWith("http")) {
            type = "http";
        } else if (temp.startsWith("mail")) {
            type = "mailto";
        } else if (temp.startsWith("ftp")) {
            type = "ftp";
        } else if (Character.isLetterOrDigit(temp.charAt(0))) {
            type = "phone";
        }
        return new AccessPoint(type, accessURI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

