/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Message;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.util.ajax.JSON;

public class JSONTransport
extends AbstractTransport {
    private int _responses = 0;
    private PrintWriter _out;
    protected String _contentType;
    protected String _start;
    protected String _end;
    private boolean _commented;

    public JSONTransport(boolean commented) {
        this.setJSONCommented(commented);
    }

    public boolean isJSONCommented() {
        return this._commented;
    }

    public void setJSONCommented(boolean commented) {
        this._commented = commented;
        if (commented) {
            this._contentType = "text/json-comment-filtered; charset=utf-8";
            this._start = "/*[";
            this._end = "]*/\r\n";
        } else {
            this._contentType = "text/json; charset=utf-8";
            this._start = "[";
            this._end = "]\r\n";
        }
    }

    public synchronized void send(Message message) throws IOException {
        if (message != null) {
            if (message.size() == 0) {
                throw new IllegalStateException();
            }
            String r = message instanceof MessageImpl ? ((MessageImpl)message).getJSON() : JSON.toString((Map)message);
            ((MessageImpl)message).decRef();
            HttpServletResponse response = this.getResponse();
            switch (this._responses) {
                case 0: {
                    response.setStatus(200);
                    response.setContentType(this._contentType);
                    this._out = response.getWriter();
                    this._out.write(this._start);
                    this._out.write(r);
                    break;
                }
                default: {
                    this._out.write(44);
                    this._out.write(r);
                }
            }
            ++this._responses;
        }
    }

    public synchronized void complete() throws IOException {
        if (this._responses == 0) {
            HttpServletResponse response = this.getResponse();
            response.setStatus(200);
            this._out = response.getWriter();
            this._out.write(this._start);
        }
        this._out.write(this._end);
        this._responses = 0;
    }

    public boolean resumePoll() {
        return false;
    }
}

