/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.JBossWebComponent;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;
import org.rhq.plugins.jbossas5.util.RegularExpressionNameMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDiscoveryComponent
implements ResourceDiscoveryComponent<JBossWebComponent> {
    private static final String WEB_REQUEST_PROCESSOR_COMPONENT_NAMES_REGEX = "jboss.web:name=([^\\-]+)-([^\\-]+)-([0-9]+),type=GlobalRequestProcessor";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JBossWebComponent> discoveryContext) throws Exception {
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        JBossWebComponent jbossWebComponent = (JBossWebComponent)discoveryContext.getParentResourceComponent();
        ManagementView managementView = jbossWebComponent.getConnection().getManagementView();
        managementView.load();
        Set<ManagedComponent> webRequestProcessorComponents = ConnectorDiscoveryComponent.getWebRequestProcessorComponents(managementView);
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>(webRequestProcessorComponents.size());
        for (ManagedComponent webRequestProcessorComponent : webRequestProcessorComponents) {
            Pattern pattern = Pattern.compile(WEB_REQUEST_PROCESSOR_COMPONENT_NAMES_REGEX);
            Matcher matcher = pattern.matcher(webRequestProcessorComponent.getName());
            if (!matcher.matches()) {
                this.log.error((Object)("Component name '" + webRequestProcessorComponent.getName() + "' does not match regex '" + pattern + "'."));
                continue;
            }
            String protocol = matcher.group(1);
            String address = matcher.group(2);
            int port = Integer.valueOf(matcher.group(3));
            String resourceKey = protocol + "://" + address + ":" + port;
            String resourceName = protocol + "://" + address + ":" + port;
            String resourceDescription = resourceType.getDescription();
            String resourceVersion = null;
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple("componentName", (Object)webRequestProcessorComponent.getName()));
            pluginConfig.put((Property)new PropertySimple("protocol", (Object)protocol));
            pluginConfig.put((Property)new PropertySimple("address", (Object)address));
            pluginConfig.put((Property)new PropertySimple("port", (Object)port));
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, resourceVersion, resourceDescription, pluginConfig, null);
            discoveredResources.add(resource);
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }

    private static Set<ManagedComponent> getWebRequestProcessorComponents(ManagementView managementView) throws Exception {
        ComponentType webRequestProcessorComponentType = MoreKnownComponentTypes.MBean.WebRequestProcessor.getType();
        return managementView.getMatchingComponents(WEB_REQUEST_PROCESSOR_COMPONENT_NAMES_REGEX, webRequestProcessorComponentType, (NameMatcher)new RegularExpressionNameMatcher());
    }
}

