/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.compress;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CompressingMarshaller
extends SerializableMarshaller {
    public static final String DATATYPE = "compressible";
    private Marshaller wrappedMarshaller;
    private static final long serialVersionUID = 8731343309128430753L;

    public CompressingMarshaller() {
    }

    public CompressingMarshaller(Marshaller marshaller) {
        this.wrappedMarshaller = marshaller;
    }

    public OutputStream getMarshallingStream(OutputStream outputStream) throws IOException {
        return outputStream;
    }

    public void write(Object dataObject, OutputStream output, int version) throws IOException {
        output.flush();
        GZIPOutputStream gzos = new GZIPOutputStream(output);
        BufferedOutputStream bos = new BufferedOutputStream(gzos);
        ObjectOutputStream oos = SerializationStreamFactory.getManagerInstance(this.getSerializationType()).createOutput(bos);
        if (this.wrappedMarshaller != null) {
            if (this.wrappedMarshaller instanceof VersionedMarshaller) {
                ((VersionedMarshaller)this.wrappedMarshaller).write(dataObject, oos, version);
            } else {
                this.wrappedMarshaller.write(dataObject, oos);
            }
        } else {
            super.write(dataObject, oos, version);
        }
        oos.flush();
        bos.flush();
        gzos.flush();
        gzos.finish();
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new CompressingMarshaller(this.wrappedMarshaller);
    }
}

