/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.stack;

import java.util.ArrayList;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.stack.MetaDataStackPermission;

public final class MetaDataStack {
    private static ThreadLocal<ArrayList<MetaData>> stack = new ThreadLocal<ArrayList<MetaData>>(){

        @Override
        protected ArrayList<MetaData> initialValue() {
            return new ArrayList<MetaData>();
        }
    };

    public static void push(MetaData metaData) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MetaDataStackPermission.MODIFY);
        }
        stack.get().add(metaData);
    }

    public static void pop() {
        ArrayList<MetaData> list = stack.get();
        if (list.size() == 0) {
            throw new IllegalArgumentException("Empty stack");
        }
        list.remove(list.size() - 1);
    }

    public static MetaData peek() {
        ArrayList<MetaData> list = stack.get();
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static void mask() {
        stack.get().add(null);
    }

    public static void unmask() {
        MetaDataStack.pop();
    }
}

